/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0003\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "nothingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "stringType", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "CallableReferenceBuilder", "Companion", "ReferenceTransformer", "backend.js"})
public final class CallableReferenceLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrType nothingType;
    @NotNull
    private final IrType stringType;
    @NotNull
    private static final Name THIS_NAME;
    @NotNull
    private static final Name BOUND_RECEIVER_NAME;

    public CallableReferenceLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.nothingType = this.context.getIrBuiltIns().getNothingType();
        this.stringType = this.context.getIrBuiltIns().getStringType();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix$default(this, irFile, true, false, 4, null);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        IrDeclarationParent irDeclarationParent = container2 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container2) : null;
        IrDeclarationParent realContainer = irDeclarationParent == null ? container2.getParent() : irDeclarationParent;
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new ReferenceTransformer(realContainer));
    }

    static {
        Name name = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<this>\")");
        THIS_NAME = name;
        name = Name.identifier("$boundThis");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"\\$boundThis\")");
        BOUND_RECEIVER_NAME = name;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "buildFunctionReference", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "buildLambdaReference", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunctionReference", "backend.js"})
    private final class ReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrDeclarationParent container;

        public ReferenceTransformer(IrDeclarationParent container2) {
            Intrinsics.checkNotNullParameter((Object)CallableReferenceLowering.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
            this.container = container2;
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2) {
            Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunction function2 = expression2.getFunction();
            Pair<IrClass, IrConstructor> pair = this.buildLambdaReference(function2, expression2);
            IrClass clazz = (IrClass)pair.component1();
            IrConstructor ctor = (IrConstructor)pair.component2();
            clazz.setParent(this.container);
            IrFunctionExpression irFunctionExpression = expression2;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionExpression $this$visitFunctionExpression_u24lambda_u2d1 = irFunctionExpression;
            boolean bl3 = false;
            int vpCount = function2.isSuspend() ? 1 : 0;
            Object[] objectArray = new IrConstructorCallImpl($this$visitFunctionExpression_u24lambda_u2d1.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getEndOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getType(), ctor.getSymbol(), 0, 0, vpCount, Companion.CALLABLE_REFERENCE_CREATE.INSTANCE);
            boolean bl4 = false;
            boolean bl5 = false;
            Object[] $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0 = objectArray;
            boolean bl6 = false;
            if (function2.isSuspend()) {
                $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.putValueArgument(0, IrConstImpl.Companion.constNull($this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.getEndOffset(), callableReferenceLowering2.context.getIrBuiltIns().getNothingNType()));
            }
            Object[] ctorCall = objectArray;
            objectArray = new IrElement[]{clazz, (IrElement)ctorCall};
            return new IrCompositeImpl($this$visitFunctionExpression_u24lambda_u2d1.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getEndOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getType(), $this$visitFunctionExpression_u24lambda_u2d1.getOrigin(), CollectionsKt.listOf((Object[])objectArray));
        }

        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            Pair<IrClass, IrConstructor> pair = this.buildFunctionReference(expression2);
            IrClass clazz = (IrClass)pair.component1();
            IrConstructor ctor = (IrConstructor)pair.component2();
            clazz.setParent(this.container);
            IrFunctionReference irFunctionReference = expression2;
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionReference $this$visitFunctionReference_u24lambda_u2d5 = irFunctionReference;
            boolean bl3 = false;
            IrFunctionReference irFunctionReference2 = expression2;
            boolean bl4 = false;
            boolean bl5 = false;
            IrFunctionReference $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2 = irFunctionReference2;
            boolean bl6 = false;
            IrExpression irExpression = $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2.getDispatchReceiver();
            IrExpression boundReceiver = irExpression == null ? $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2.getExtensionReceiver() : irExpression;
            int vpCount = boundReceiver != null ? 1 : 0;
            Object[] objectArray = new IrConstructorCallImpl($this$visitFunctionReference_u24lambda_u2d5.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d5.getEndOffset(), $this$visitFunctionReference_u24lambda_u2d5.getType(), ctor.getSymbol(), 0, 0, vpCount, Companion.CALLABLE_REFERENCE_CREATE.INSTANCE);
            boolean bl7 = false;
            boolean bl8 = false;
            Object[] $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d4 = objectArray;
            boolean bl9 = false;
            IrExpression irExpression2 = boundReceiver;
            if (irExpression2 != null) {
                IrExpression irExpression3 = irExpression2;
                boolean bl10 = false;
                boolean bl11 = false;
                IrExpression it = irExpression3;
                boolean bl12 = false;
                $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(0, it);
            }
            Object[] ctorCall = objectArray;
            objectArray = new IrElement[]{clazz, (IrElement)ctorCall};
            return new IrCompositeImpl($this$visitFunctionReference_u24lambda_u2d5.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d5.getEndOffset(), $this$visitFunctionReference_u24lambda_u2d5.getType(), $this$visitFunctionReference_u24lambda_u2d5.getOrigin(), CollectionsKt.listOf((Object[])objectArray));
        }

        private final Pair<IrClass, IrConstructor> buildFunctionReference(IrFunctionReference expression2) {
            return new CallableReferenceBuilder(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), expression2, false).build();
        }

        private final Pair<IrClass, IrConstructor> buildLambdaReference(IrSimpleFunction function2, IrFunctionExpression expression2) {
            return new CallableReferenceBuilder(function2, expression2, true).build();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\u00020 *\u00020\u0018H\u0002J\f\u0010!\u001a\u00020\"*\u00020\u0013H\u0002J\f\u0010#\u001a\u00020\u001a*\u00020\u0018H\u0002J\f\u0010$\u001a\u00020\u001a*\u00020\u0018H\u0002J\f\u0010%\u001a\u00020\u001a*\u00020\u0010H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceBuilder;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isLambda", "", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Z)V", "boundReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isKReference", "isSuspendLambda", "superClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "superFunctionInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "build", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildReferenceClass", "createConstructor", "clazz", "createInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createNameProperty", "", "getValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "d", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "buildInvoke", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "countContextTypeParameters", "", "createFunctionReferenceInvokeMethod", "createLambdaInvokeMethod", "createReceiverField", "backend.js"})
    private final class CallableReferenceBuilder {
        @NotNull
        private final IrFunction function;
        @NotNull
        private final IrExpression reference;
        private final boolean isLambda;
        private final boolean isSuspendLambda;
        @NotNull
        private final IrType superClass;
        @Nullable
        private IrField boundReceiverField;
        @NotNull
        private final IrClass superFunctionInterface;
        private final boolean isKReference;

        public CallableReferenceBuilder(@NotNull IrFunction function2, IrExpression reference, boolean isLambda) {
            IrClass irClass2;
            Intrinsics.checkNotNullParameter((Object)CallableReferenceLowering.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            this.function = function2;
            this.reference = reference;
            this.isLambda = isLambda;
            this.isSuspendLambda = this.isLambda && AdditionalIrUtilsKt.isSuspend(this.function);
            this.superClass = this.isSuspendLambda ? (IrType)IrUtilsKt.getDefaultType((IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().getCoroutineImpl().getOwner()) : CallableReferenceLowering.this.context.getIrBuiltIns().getAnyType();
            Object object = IrTypesKt.getClassOrNull(this.reference.getType());
            IrClass irClass3 = irClass2 = object == null ? null : (IrClass)object.getOwner();
            if (irClass2 == null) {
                object = "Expected functional type";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            this.superFunctionInterface = irClass2;
            this.isKReference = this.superFunctionInterface.getName().getIdentifier().charAt(0) == 'K';
        }

        private final IrClass buildReferenceClass() {
            IrFactory $this$buildClass$iv = CallableReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder irClassBuilder = new IrClassBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = irClassBuilder;
            boolean bl3 = false;
            IrClassBuilder $this$buildReferenceClass_u24lambda_u2d0 = $this$buildClass_u24lambda_u2d1$iv;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange($this$buildReferenceClass_u24lambda_u2d0, this.reference);
            Object object = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LOCAL");
            $this$buildReferenceClass_u24lambda_u2d0.setVisibility((DescriptorVisibility)object);
            $this$buildReferenceClass_u24lambda_u2d0.setOrigin(this.isKReference || !this.isLambda ? (IrDeclarationOrigin)Companion.FUNCTION_REFERENCE_IMPL.INSTANCE : (IrDeclarationOrigin)Companion.LAMBDA_IMPL.INSTANCE);
            object = SpecialNames.NO_NAME_PROVIDED;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NO_NAME_PROVIDED");
            $this$buildReferenceClass_u24lambda_u2d0.setName((Name)object);
            IrClass irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            IrClass $this$buildReferenceClass_u24lambda_u2d1 = irClass2;
            boolean bl7 = false;
            Object[] objectArray = new IrType[]{this.superClass, this.reference.getType()};
            $this$buildReferenceClass_u24lambda_u2d1.setSuperTypes(CollectionsKt.listOf((Object[])objectArray));
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$buildReferenceClass_u24lambda_u2d1);
            this.createReceiverField($this$buildReferenceClass_u24lambda_u2d1);
            return irClass2;
        }

        private final void createReceiverField(IrClass $this$createReceiverField) {
            IrFunctionReference funRef;
            if (this.isLambda) {
                return;
            }
            IrFunctionReference irFunctionReference = funRef = (IrFunctionReference)this.reference;
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionReference $this$createReceiverField_u24lambda_u2d2 = irFunctionReference;
            boolean bl3 = false;
            IrExpression irExpression = $this$createReceiverField_u24lambda_u2d2.getDispatchReceiver();
            IrExpression boundReceiver = irExpression == null ? $this$createReceiverField_u24lambda_u2d2.getExtensionReceiver() : irExpression;
            if (boundReceiver != null) {
                this.boundReceiverField = DeclarationBuildersKt.addField$default($this$createReceiverField, Companion.getBOUND_RECEIVER_NAME(), boundReceiver.getType(), null, 4, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor(IrClass clazz) {
            void $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            Unit unit;
            Object superContinuation;
            boolean bl;
            boolean bl2;
            boolean bl32;
            Object it;
            IrValueParameter irValueParameter;
            IrClass $this$addConstructor$iv = clazz;
            boolean $i$f$addConstructor = false;
            IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2d18$iv$iv = irFunctionBuilder;
            boolean bl6 = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2d19$iv = $this$buildConstructor_u24lambda_u2d18$iv$iv;
            boolean bl7 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u2d3 = $this$addConstructor_u24lambda_u2d19$iv;
            boolean bl8 = false;
            $this$createConstructor_u24lambda_u2d3.setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$createConstructor_u24lambda_u2d3.setReturnType(IrUtilsKt.getDefaultType(clazz));
            $this$createConstructor_u24lambda_u2d3.setPrimary(true);
            $this$addConstructor_u24lambda_u2d19$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2d18$iv$iv);
            boolean bl9 = false;
            boolean bl10 = false;
            IrConstructor constructor$iv = irConstructor2;
            boolean $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = false;
            $this$addConstructor$iv.getDeclarations().add(constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            IrConstructor irConstructor3 = irConstructor2;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            boolean bl11 = false;
            bl9 = false;
            IrConstructor $this$createConstructor_u24lambda_u2d12 = irConstructor3;
            boolean bl12 = false;
            IrClassSymbol $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = IrTypesKt.getClassOrNull(this.superClass);
            Intrinsics.checkNotNull((Object)$i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22);
            Iterable $this$single$iv = ((IrClass)$i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22.getOwner()).getDeclarations();
            boolean $i$f$single22 = false;
            IrField single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it2 = (IrDeclaration)element$iv;
                boolean bl13 = false;
                if (!(it2 instanceof IrConstructor && ((IrConstructor)it2).isPrimary())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrConstructor superConstructor = (IrConstructor)((Object)single$iv);
            IrField $i$f$single22 = this.boundReceiverField;
            if ($i$f$single22 == null) {
                irValueParameter = null;
            } else {
                single$iv = $i$f$single22;
                found$iv = false;
                bl7 = false;
                it = single$iv;
                bl32 = false;
                IrFunction $this$addValueParameter$iv2 = $this$createConstructor_u24lambda_u2d12;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl14 = false;
                bl2 = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d26$iv = irValueParameterBuilder;
                boolean bl15 = false;
                IrValueParameterBuilder $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5 = $this$addValueParameter_u24lambda_u2d26$iv;
                boolean bl16 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5.setName(Companion.getBOUND_RECEIVER_NAME());
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5.setType(((IrField)it).getType());
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5.setIndex(0);
                if ($this$addValueParameter_u24lambda_u2d26$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d26$iv.setIndex($this$addValueParameter$iv2.getValueParameters().size());
                }
                IrValueParameter irValueParameter2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), $this$addValueParameter_u24lambda_u2d26$iv, $this$addValueParameter$iv2);
                boolean bl17 = false;
                bl = false;
                IrValueParameter valueParameter$iv = irValueParameter2;
                boolean bl18 = false;
                $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), (Object)valueParameter$iv));
                irValueParameter = irValueParameter2;
            }
            IrValueParameter boundReceiverParameter = irValueParameter;
            IrValueParameter continuation2 = null;
            if (this.isSuspendLambda) {
                superContinuation = (IrValueParameter)CollectionsKt.single(superConstructor.getValueParameters());
                IrFunction $this$addValueParameter$iv = $this$createConstructor_u24lambda_u2d12;
                boolean $i$f$addValueParameter = false;
                it = new IrValueParameterBuilder();
                bl32 = false;
                boolean $this$addValueParameter$iv2 = false;
                Object $this$addValueParameter_u24lambda_u2d26$iv = it;
                boolean bl19 = false;
                Object $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7 = $this$addValueParameter_u24lambda_u2d26$iv;
                boolean bl20 = false;
                ((IrDeclarationBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d7).setName(superContinuation.getName());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d7).setType(((IrValueDeclaration)superContinuation).getType());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d7).setIndex(boundReceiverParameter == null ? 0 : 1);
                unit = Unit.INSTANCE;
                if (((IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d26$iv).getIndex() == -1) {
                    ((IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d26$iv).setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter irValueParameter3 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d26$iv, $this$addValueParameter$iv);
                bl15 = false;
                boolean bl21 = false;
                IrValueParameter valueParameter$iv = irValueParameter3;
                boolean bl22 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
                continuation2 = irValueParameter3;
            }
            superContinuation = LowerUtilsKt.createIrBuilder$default(callableReferenceLowering2.context, $this$createConstructor_u24lambda_u2d12.getSymbol(), 0, 0, 6, null);
            int $this$addValueParameter$iv = $this$createConstructor_u24lambda_u2d12.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2d12.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder bl32 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$addValueParameter_u24lambda_u2d26$iv = this_$iv$iv;
            IrConstructor irConstructor4 = $this$createConstructor_u24lambda_u2d12;
            boolean bl23 = false;
            IrElementBase irElementBase = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11, superConstructor);
            bl2 = false;
            boolean bl24 = false;
            IrDelegatingConstructorCall bl15 = irElementBase;
            void var23_56 = $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
            boolean bl25 = false;
            IrValueParameter bl22 = continuation2;
            if (bl22 != null) {
                void $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d9;
                IrValueParameter irValueParameter4 = bl22;
                bl = false;
                boolean bl26 = false;
                IrValueParameter it3 = irValueParameter4;
                boolean bl27 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d9.putValueArgument(0, this.getValue(it3));
            }
            Unit unit2 = Unit.INSTANCE;
            var23_56.unaryPlus((IrStatement)((Object)irElementBase));
            irElementBase = boundReceiverParameter;
            if (irElementBase != null) {
                IrElementBase irElementBase2 = irElementBase;
                bl24 = false;
                boolean bl28 = false;
                IrElementBase it4 = irElementBase2;
                boolean bl29 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
                IrDeclarationBase irDeclarationBase = clazz.getThisReceiver();
                Intrinsics.checkNotNull((Object)irDeclarationBase);
                IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irDeclarationBase);
                irDeclarationBase = this.boundReceiverField;
                Intrinsics.checkNotNull((Object)irDeclarationBase);
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, irExpression, (IrField)irDeclarationBase, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11, (IrValueDeclaration)it4)));
            }
            $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.unaryPlus(new IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getStartOffset(), $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getEndOffset(), clazz.getSymbol(), $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getContext().getIrBuiltIns().getUnitType()));
            unit = Unit.INSTANCE;
            irConstructor4.setBody(this_$iv$iv.doBuild());
            return irConstructor3;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createInvokeMethod(IrClass clazz) {
            boolean bl;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List superMethods = (List)destination$iv$iv;
            Iterable $this$single$iv = superMethods;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"invoke")) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction superMethod = single$iv;
            IrClass $this$addFunction$iv = clazz;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u2d14 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange($this$createInvokeMethod_u24lambda_u2d14, this.isLambda ? (IrElement)this.function : (IrElement)this.reference);
            $this$createInvokeMethod_u24lambda_u2d14.setName(superMethod.getName());
            $this$createInvokeMethod_u24lambda_u2d14.setReturnType(this.function.getReturnType());
            $this$createInvokeMethod_u24lambda_u2d14.setSuspend(superMethod.isSuspend());
            $this$createInvokeMethod_u24lambda_u2d14.setOperator(superMethod.isOperator());
            $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d14$iv$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            Object function$iv$iv = $this$buildFun$iv$iv$iv;
            boolean bl7 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$createInvokeMethod_u24lambda_u2d15 = object;
            boolean bl10 = false;
            $this$createInvokeMethod_u24lambda_u2d15.setOverriddenSymbols(CollectionsKt.listOf((Object)superMethod.getSymbol()));
            ((IrFunction)$this$createInvokeMethod_u24lambda_u2d15).setDispatchReceiverParameter(DeclarationBuildersKt.buildReceiverParameter((IrDeclaration)$this$createInvokeMethod_u24lambda_u2d15, clazz.getOrigin(), IrUtilsKt.getDefaultType(clazz), $this$createInvokeMethod_u24lambda_u2d15.getStartOffset(), $this$createInvokeMethod_u24lambda_u2d15.getEndOffset()));
            if (this.isLambda) {
                this.createLambdaInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d15);
            } else {
                this.createFunctionReferenceInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d15);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(this.function.getAnnotations());
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.function));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int index2 = $dstr$index$param.component1();
                IrValueParameter param = (IrValueParameter)$dstr$index$param.component2();
                Pair pair = TuplesKt.to((Object)param, (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, index2, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                boolean bl2 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setValueParameters(CollectionsKt.toList((Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.function, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        @NotNull
        public final IrGetValue getValue(@NotNull IrValueDeclaration d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return new IrGetValueImpl(-1, -1, d.getType(), d.getSymbol(), Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE);
        }

        private final int countContextTypeParameters(IrConstructor $this$countContextTypeParameters) {
            return CallableReferenceBuilder.countContextTypeParameters$countImpl($this$countContextTypeParameters.getParent());
        }

        private final IrFunctionAccessExpression buildInvoke(IrSimpleFunction $this$buildInvoke) {
            IrFunctionReference funRef;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunction callee = this.function;
            IrExpression irExpression = this.reference;
            boolean bl = false;
            boolean bl2 = false;
            IrExpression $this$buildInvoke_u24lambda_u2d2322 = irExpression;
            boolean bl3 = false;
            IrFunction irFunction2 = callee;
            if (irFunction2 instanceof IrConstructor) {
                irFunctionAccessExpression = new IrConstructorCallImpl($this$buildInvoke_u24lambda_u2d2322.getStartOffset(), $this$buildInvoke_u24lambda_u2d2322.getEndOffset(), IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(callee)), ((IrConstructor)callee).getSymbol(), this.countContextTypeParameters((IrConstructor)callee), callee.getTypeParameters().size(), callee.getValueParameters().size(), Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE);
            } else if (irFunction2 instanceof IrSimpleFunction) {
                irFunctionAccessExpression = new IrCallImpl($this$buildInvoke_u24lambda_u2d2322.getStartOffset(), $this$buildInvoke_u24lambda_u2d2322.getEndOffset(), callee.getReturnType(), ((IrSimpleFunction)callee).getSymbol(), callee.getTypeParameters().size(), callee.getValueParameters().size(), Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 128, null);
            } else {
                String string2 = Intrinsics.stringPlus((String)"unknown function kind: ", (Object)RenderIrElementKt.render(callee));
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            IrFunctionAccessExpression irCall = irFunctionAccessExpression;
            IrFunctionReference irFunctionReference = funRef = (IrFunctionReference)this.reference;
            boolean $this$buildInvoke_u24lambda_u2d2322 = false;
            bl3 = false;
            IrFunctionReference $this$buildInvoke_u24lambda_u2d222 = irFunctionReference;
            boolean bl5 = false;
            IrExpression irExpression2 = $this$buildInvoke_u24lambda_u2d222.getDispatchReceiver();
            boolean boundReceiver = (irExpression2 == null ? $this$buildInvoke_u24lambda_u2d222.getExtensionReceiver() : irExpression2) != null;
            IrFunction $this$buildInvoke_u24lambda_u2d2322 = callee;
            bl3 = false;
            int $this$buildInvoke_u24lambda_u2d222 = 0;
            IrFunction $this$buildInvoke_u24lambda_u2d242 = $this$buildInvoke_u24lambda_u2d2322;
            boolean bl6 = false;
            IrValueParameter irValueParameter = $this$buildInvoke_u24lambda_u2d242.getDispatchReceiverParameter();
            boolean hasReceiver = (irValueParameter == null ? $this$buildInvoke_u24lambda_u2d242.getExtensionReceiverParameter() : irValueParameter) != null;
            irCall.setDispatchReceiver(funRef.getDispatchReceiver());
            irCall.setExtensionReceiver(funRef.getExtensionReceiver());
            int i = 0;
            List<IrValueParameter> valueParameters2 = $this$buildInvoke.getValueParameters();
            $this$buildInvoke_u24lambda_u2d222 = 0;
            int $this$buildInvoke_u24lambda_u2d242 = funRef.getTypeArgumentsCount();
            if ($this$buildInvoke_u24lambda_u2d222 < $this$buildInvoke_u24lambda_u2d242) {
                do {
                    int ti = $this$buildInvoke_u24lambda_u2d222++;
                    irCall.putTypeArgument(ti, funRef.getTypeArgument(ti));
                } while ($this$buildInvoke_u24lambda_u2d222 < $this$buildInvoke_u24lambda_u2d242);
            }
            if (hasReceiver) {
                if (!boundReceiver) {
                    if (callee.getDispatchReceiverParameter() != null) {
                        $this$buildInvoke_u24lambda_u2d222 = i;
                        i = $this$buildInvoke_u24lambda_u2d222 + 1;
                        irCall.setDispatchReceiver(this.getValue(valueParameters2.get($this$buildInvoke_u24lambda_u2d222)));
                    }
                    if (callee.getExtensionReceiverParameter() != null) {
                        $this$buildInvoke_u24lambda_u2d222 = i;
                        i = $this$buildInvoke_u24lambda_u2d222 + 1;
                        irCall.setExtensionReceiver(this.getValue(valueParameters2.get($this$buildInvoke_u24lambda_u2d222)));
                    }
                } else {
                    IrField boundReceiverField = this.boundReceiverField;
                    if (boundReceiverField != null) {
                        IrValueParameter ti = $this$buildInvoke.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)ti);
                        IrGetValue thisValue = this.getValue(ti);
                        IrGetFieldImpl value2 = new IrGetFieldImpl(-1, -1, boundReceiverField.getSymbol(), boundReceiverField.getType(), thisValue, Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 64, null);
                        if (funRef.getDispatchReceiver() != null) {
                            irCall.setDispatchReceiver(value2);
                        }
                        if (funRef.getExtensionReceiver() != null) {
                            irCall.setExtensionReceiver(value2);
                        }
                    }
                    if (callee.getDispatchReceiverParameter() != null && funRef.getDispatchReceiver() == null) {
                        int n = i;
                        i = n + 1;
                        irCall.setDispatchReceiver(this.getValue(valueParameters2.get(n)));
                    }
                    if (callee.getExtensionReceiverParameter() != null && funRef.getExtensionReceiver() == null) {
                        int n = i;
                        i = n + 1;
                        irCall.setExtensionReceiver(this.getValue(valueParameters2.get(n)));
                    }
                }
            }
            int j = 0;
            while (i < valueParameters2.size()) {
                int n = j;
                j = n + 1;
                int n2 = n;
                n = i;
                i = n + 1;
                irCall.putValueArgument(n2, this.getValue(valueParameters2.get(n)));
            }
            return irCall;
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((IrSimpleType)this.reference.getType()).getArguments();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object = ((IrTypeProjection)it).getType();
                object2.add(object);
            }
            List parameterTypes = (List)destination$iv$iv;
            List argumentTypes2 = CollectionsKt.dropLast((List)parameterTypes, (int)1);
            Iterable $i$f$map22 = argumentTypes2;
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo22 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void t;
                void i;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrType irType = (IrType)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv2;
                boolean bl2 = false;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d24$iv = irValueParameterBuilder;
                boolean bl5 = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23 = $this$buildValueParameter_u24lambda_u2d24$iv;
                boolean bl6 = false;
                Name name = Name.identifier(Intrinsics.stringPlus((String)"p", (Object)((int)i)));
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"p$i\")");
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23.setName(name);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23.setType((IrType)t);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23.setIndex((int)i);
                IrValueParameter irValueParameter = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)$this$createFunctionReferenceInvokeMethod).getFactory(), $this$buildValueParameter_u24lambda_u2d24$iv, (IrDeclarationParent)((Object)((IrDeclaration)$this$createFunctionReferenceInvokeMethod)));
                object.add(irValueParameter);
            }
            object = (List)destination$iv$iv2;
            ((IrFunction)object2).setValueParameters((List<? extends IrValueParameter>)object);
            IrExpression irExpression = this.reference;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            boolean bl = false;
            boolean bl7 = false;
            IrExpression $i$f$mapIndexedTo22 = irExpression;
            int n = this.reference.getEndOffset();
            int n3 = this.reference.getStartOffset();
            object = $this$createFunctionReferenceInvokeMethod.getFactory();
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean bl8 = false;
            IrReturnImpl irReturnImpl = new IrReturnImpl($this$createFunctionReferenceInvokeMethod_u24lambda_u2d25.getStartOffset(), $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25.getEndOffset(), callableReferenceLowering2.nothingType, $this$createFunctionReferenceInvokeMethod.getSymbol(), this.buildInvoke($this$createFunctionReferenceInvokeMethod));
            ((IrFunction)object2).setBody(object.createBlockBody(n3, n, CollectionsKt.listOf((Object)irReturnImpl)));
        }

        /*
         * WARNING - void declaration
         */
        private final void createNameProperty(IrClass clazz) {
            void $this$createNameProperty_u24lambda_u2d28;
            Object getter2;
            Object $this$addGetter$iv;
            IrProperty nameProperty;
            String $this$filterIsInstanceTo$iv$iv;
            if (!this.isKReference) {
                return;
            }
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            IrProperty superProperty = (IrProperty)CollectionsKt.single((List)((List)destination$iv$iv2));
            IrSimpleFunction $i$f$filterIsInstance22 = superProperty.getGetter();
            if ($i$f$filterIsInstance22 == null) {
                $this$filterIsInstanceTo$iv$iv = "Expected getter for KFunction.name property";
                boolean destination$iv$iv2 = false;
                throw (Throwable)new IllegalStateException($this$filterIsInstanceTo$iv$iv.toString());
            }
            IrSimpleFunction supperGetter = $i$f$filterIsInstance22;
            IrClass $this$addProperty$iv = clazz;
            boolean $i$f$addProperty22 = false;
            IrFactory $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            boolean $i$f$buildProperty = false;
            IrPropertyBuilder irPropertyBuilder = new IrPropertyBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrPropertyBuilder $this$buildProperty_u24lambda_u2d8$iv$iv = irPropertyBuilder;
            boolean bl3 = false;
            IrPropertyBuilder $this$createNameProperty_u24lambda_u2d26 = $this$buildProperty_u24lambda_u2d8$iv$iv;
            boolean bl4 = false;
            $this$createNameProperty_u24lambda_u2d26.setVisibility(superProperty.getVisibility());
            $this$createNameProperty_u24lambda_u2d26.setName(superProperty.getName());
            $this$createNameProperty_u24lambda_u2d26.setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            Object object = DeclarationBuildersKt.buildProperty($this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u2d8$iv$iv);
            $i$f$buildProperty = false;
            boolean bl5 = false;
            IrProperty property$iv22 = object;
            boolean bl6 = false;
            $this$addProperty$iv.getDeclarations().add(property$iv22);
            property$iv22.setParent($this$addProperty$iv);
            IrProperty $i$f$addProperty22 = nameProperty = object;
            object = CallableReferenceLowering.this;
            boolean $i$f$addGetter = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean property$iv22 = false;
            bl6 = false;
            Object $this$addGetter_u24lambda_u2d11$iv = irFunctionBuilder;
            boolean bl7 = false;
            Object object2 = Name.special("<get-" + $this$addGetter$iv.getName() + '>');
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"special(\"<get-${this@addGetter.name}>\")");
            ((IrDeclarationBuilder)$this$addGetter_u24lambda_u2d11$iv).setName((Name)object2);
            IrFunctionBuilder $this$createNameProperty_u24lambda_u2d27 = $this$addGetter_u24lambda_u2d11$iv;
            boolean bl8 = false;
            $this$createNameProperty_u24lambda_u2d27.setReturnType(((CallableReferenceLowering)object).stringType);
            object2 = DeclarationBuildersKt.buildFunction($this$addGetter$iv.getFactory(), (IrFunctionBuilder)$this$addGetter_u24lambda_u2d11$iv);
            boolean bl9 = false;
            boolean bl10 = false;
            Object getter$iv = object2;
            boolean bl11 = false;
            ((IrProperty)$this$addGetter$iv).setGetter((IrSimpleFunction)getter$iv);
            ((IrSimpleFunction)getter$iv).setCorrespondingPropertySymbol(((IrProperty)$this$addGetter$iv).getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            $this$addGetter$iv = getter2 = object2;
            $this$addGetter$iv.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$addGetter$iv.getOverriddenSymbols(), (Object)supperGetter.getSymbol()));
            boolean $i$f$buildValueParameter = false;
            object = new IrValueParameterBuilder();
            boolean bl12 = false;
            boolean bl13 = false;
            Object $this$buildValueParameter_u24lambda_u2d24$iv = object;
            boolean bl14 = false;
            $this$addGetter_u24lambda_u2d11$iv = $this$buildValueParameter_u24lambda_u2d24$iv;
            Object object3 = getter2;
            boolean bl15 = false;
            $this$createNameProperty_u24lambda_u2d28.setName(Companion.getTHIS_NAME());
            $this$createNameProperty_u24lambda_u2d28.setType(IrUtilsKt.getDefaultType(clazz));
            Unit unit = Unit.INSTANCE;
            ((IrFunction)object3).setDispatchReceiverParameter(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)getter2).getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u2d24$iv, (IrDeclarationParent)((Object)((IrDeclaration)getter2))));
            IrFactory irFactory = CallableReferenceLowering.this.context.getIrFactory();
            IrType irType = CallableReferenceLowering.this.nothingType;
            IrReturnTargetSymbol irReturnTargetSymbol = ((IrSimpleFunction)getter2).getSymbol();
            IrType irType2 = CallableReferenceLowering.this.stringType;
            String string2 = this.function.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
            ((IrFunction)getter2).setBody(irFactory.createBlockBody(-1, -1, CollectionsKt.listOf((Object)new IrReturnImpl(-1, -1, irType, irReturnTargetSymbol, IrConstImpl.Companion.string(-1, -1, irType2, string2)))));
            CallableReferenceLowering.this.context.getMapping().getReflectedNameAccessor().set((IrClass)((IrDeclaration)clazz), (IrSimpleFunction)getter2);
        }

        @NotNull
        public final Pair<IrClass, IrConstructor> build() {
            IrClass clazz = this.buildReferenceClass();
            IrConstructor ctor = this.createConstructor(clazz);
            this.createInvokeMethod(clazz);
            this.createNameProperty(clazz);
            return new Pair((Object)clazz, (Object)ctor);
        }

        /*
         * WARNING - void declaration
         */
        private static final int countContextTypeParameters$countImpl(IrDeclarationParent container2) {
            int n;
            IrDeclarationParent irDeclarationParent = container2;
            if (irDeclarationParent instanceof IrClass) {
                void $this$countContextTypeParameters_u24countImpl_u24lambda_u2d17;
                IrDeclarationParent irDeclarationParent2 = container2;
                boolean bl = false;
                boolean bl2 = false;
                IrClass irClass2 = (IrClass)irDeclarationParent2;
                int n2 = ((IrClass)container2).getTypeParameters().size();
                boolean bl3 = false;
                int n3 = $this$countContextTypeParameters_u24countImpl_u24lambda_u2d17.isInner() ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrClass)container2).getParent()) : 0;
                n = n2 + n3;
            } else if (irDeclarationParent instanceof IrFunction) {
                n = ((IrFunction)container2).getTypeParameters().size() + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrFunction)container2).getParent());
            } else if (irDeclarationParent instanceof IrProperty) {
                int n4;
                IrDeclarationParent irDeclarationParent3 = container2;
                boolean bl = false;
                boolean bl4 = false;
                IrElement $this$countContextTypeParameters_u24countImpl_u24lambda_u2d18 = irDeclarationParent3;
                boolean bl5 = false;
                IrSimpleFunction irSimpleFunction = ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2d18).getGetter();
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction == null ? ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2d18).getSetter() : irSimpleFunction;
                List<IrTypeParameter> list2 = irSimpleFunction2 == null ? null : irSimpleFunction2.getTypeParameters();
                n = (list2 == null ? 0 : (n4 = list2.size())) + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrProperty)((Object)container2)).getParent());
            } else {
                n = irDeclarationParent instanceof IrDeclaration ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrDeclaration)((Object)container2)).getParent()) : 0;
            }
            return n;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion;", "", "()V", "BOUND_RECEIVER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getBOUND_RECEIVER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "THIS_NAME", "getTHIS_NAME", "CALLABLE_REFERENCE_CREATE", "CALLABLE_REFERENCE_INVOKE", "FUNCTION_REFERENCE_IMPL", "GENERATED_MEMBER_IN_CALLABLE_REFERENCE", "LAMBDA_IMPL", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Name getTHIS_NAME() {
            return THIS_NAME;
        }

        @NotNull
        public final Name getBOUND_RECEIVER_NAME() {
            return BOUND_RECEIVER_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$LAMBDA_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class LAMBDA_IMPL
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final LAMBDA_IMPL INSTANCE = new LAMBDA_IMPL();

            private LAMBDA_IMPL() {
                super("LAMBDA_IMPL", false, 2, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$FUNCTION_REFERENCE_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class FUNCTION_REFERENCE_IMPL
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final FUNCTION_REFERENCE_IMPL INSTANCE = new FUNCTION_REFERENCE_IMPL();

            private FUNCTION_REFERENCE_IMPL() {
                super("FUNCTION_REFERENCE_IMPL", false, 2, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$GENERATED_MEMBER_IN_CALLABLE_REFERENCE;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class GENERATED_MEMBER_IN_CALLABLE_REFERENCE
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final GENERATED_MEMBER_IN_CALLABLE_REFERENCE INSTANCE = new GENERATED_MEMBER_IN_CALLABLE_REFERENCE();

            private GENERATED_MEMBER_IN_CALLABLE_REFERENCE() {
                super("GENERATED_MEMBER_IN_CALLABLE_REFERENCE", false, 2, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$CALLABLE_REFERENCE_CREATE;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "backend.js"})
        public static final class CALLABLE_REFERENCE_CREATE
        extends IrStatementOriginImpl {
            @NotNull
            public static final CALLABLE_REFERENCE_CREATE INSTANCE = new CALLABLE_REFERENCE_CREATE();

            private CALLABLE_REFERENCE_CREATE() {
                super("CALLABLE_REFERENCE_CREATE");
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$CALLABLE_REFERENCE_INVOKE;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "backend.js"})
        public static final class CALLABLE_REFERENCE_INVOKE
        extends IrStatementOriginImpl {
            @NotNull
            public static final CALLABLE_REFERENCE_INVOKE INSTANCE = new CALLABLE_REFERENCE_INVOKE();

            private CALLABLE_REFERENCE_INVOKE() {
                super("CALLABLE_REFERENCE_INVOKE");
            }
        }
    }
}

