/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import javaslang.collection.AbstractIterator;
import javaslang.collection.IndexedSeq;
import javaslang.collection.Iterator;

public final class Array<T>
implements Serializable,
IndexedSeq<T> {
    private static final long serialVersionUID = 1L;
    private static final Array<?> EMPTY = new Array(new Object[0]);
    private final Object[] back;

    private Array(Object[] back) {
        this.back = back;
    }

    static <T> Array<T> wrap(Object[] array2) {
        if (array2.length == 0) {
            return Array.empty();
        }
        return new Array<T>(array2);
    }

    public static <T> Array<T> empty() {
        return EMPTY;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Array.this.back.length;
            }

            @Override
            public T getNext() {
                return Array.this.back[this.index++];
            }
        };
    }

    @Override
    public T get(int index2) {
        if (index2 < 0 || index2 >= this.length()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        return (T)this.back[index2];
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head() on empty Array");
        }
        return (T)this.back[0];
    }

    @Override
    public boolean isEmpty() {
        return this.back.length == 0;
    }

    @Override
    public int length() {
        return this.back.length;
    }

    @Override
    public <U> Array<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Object[] arr = new Object[this.length()];
        for (int i = 0; i < this.back.length; ++i) {
            arr[i] = mapper.apply(this.get(i));
        }
        return Array.wrap(arr);
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    public Array<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail() on empty Array");
        }
        Object[] arr = new Object[this.back.length - 1];
        System.arraycopy(this.back, 1, arr, 0, arr.length);
        return Array.wrap(arr);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Array) {
            Object[] arr1 = this.back;
            Object[] arr2 = ((Array)o).back;
            return Objects.deepEquals(arr1, arr2);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.back);
    }

    @Override
    public String stringPrefix() {
        return "Array";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

