/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirSynchronizedAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "SYNCHRONIZED_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirSynchronizedAnnotationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirSynchronizedAnnotationChecker INSTANCE = new FirSynchronizedAnnotationChecker();
    @NotNull
    private static final FqName SYNCHRONIZED_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Synchronized");

    private FirSynchronizedAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirAnnotationCall firAnnotationCall = FirAnnotationUtilsKt.getAnnotationByFqName(declaration2, SYNCHRONIZED_ANNOTATION_FQ_NAME);
        if (firAnnotationCall == null) {
            return;
        }
        FirAnnotationCall annotation2 = firAnnotationCall;
        FirMemberDeclaration $this$isInline$iv = declaration2;
        boolean $i$f$isInline22 = false;
        if ($this$isInline$iv.getStatus().isInline()) {
            DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_ON_INLINE(), context2, null, 8, null);
            return;
        }
        FirClassLikeSymbol<?> $i$f$isInline22 = FirHelpersKt.getContainingClassSymbol(declaration2, context2.getSession());
        if ($i$f$isInline22 == null) {
            return;
        }
        FirClassLikeSymbol<?> containingClass = $i$f$isInline22;
        if (FirHelpersKt.getClassKind(containingClass) == ClassKind.INTERFACE) {
            DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_IN_INTERFACE(), context2, null, 8, null);
        } else {
            FirMemberDeclaration $this$isAbstract$iv = declaration2;
            boolean $i$f$isAbstract = false;
            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_ON_ABSTRACT(), context2, null, 8, null);
            }
        }
    }
}

