/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.fir.EnumClassUtilsKt;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirRealPsiSourceElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirRenderer;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import org.jetbrains.kotlin.fir.declarations.builder.FirConstructedClassTypeParameterRefBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirEnumEntryBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirOuterClassTypeParameterRefBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationBuildingUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.java.JavaScopeProvider;
import org.jetbrains.kotlin.fir.java.JavaSymbolProvider;
import org.jetbrains.kotlin.fir.java.JavaSymbolProviderKt;
import org.jetbrains.kotlin.fir.java.JavaTypeParameterStack;
import org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaClass;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaClassBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaConstructor;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaConstructorBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaFieldBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethodBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethodKt;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameterBuilder;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TreeResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaLoadingKt;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 y2\u00020\u0001:\u0002yzB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u000209H\u0002J@\u0010:\u001a\u00020&2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010)\u001a\u00020*2\u0006\u00108\u001a\u0002092\u0006\u0010+\u001a\u00020,2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>2\u0006\u0010@\u001a\u00020 H\u0002J(\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020 2\u0006\u0010F\u001a\u00020GH\u0002J\u0014\u0010H\u001a\u0004\u0018\u00010I2\b\u0010J\u001a\u0004\u0018\u00010KH\u0002J(\u0010L\u001a\u0002042\u0006\u00101\u001a\u0002022\u0006\u0010E\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020 2\u0006\u0010F\u001a\u00020GH\u0002J<\u0010M\u001a\u0002062\u0006\u00108\u001a\u0002092\u0006\u00107\u001a\u00020\u00102\b\u0010N\u001a\u0004\u0018\u00010\u000f2\b\u0010O\u001a\u0004\u0018\u00010\u00102\u0006\u0010E\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020 H\u0002J*\u0010P\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u0001090Q2\u0006\u0010E\u001a\u00020\u000f2\b\u0010R\u001a\u0004\u0018\u00010\u0011H\u0002J\u001c\u0010S\u001a\u0004\u0018\u0001092\u0006\u0010E\u001a\u00020\u000f2\b\u0010R\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010T\u001a\u0004\u0018\u00010\u00172\u0006\u0010U\u001a\u00020\u0017H\u0002J\u0012\u0010V\u001a\u0004\u0018\u00010\u00102\u0006\u0010E\u001a\u00020\u000fH\u0016J\u001c\u0010W\u001a\u0004\u0018\u00010\u00102\u0006\u0010E\u001a\u00020\u000f2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\u0011J\u0018\u0010X\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010Y2\u0006\u0010Z\u001a\u00020\u0017H\u0002J\u0012\u0010[\u001a\u0004\u0018\u00010\u00172\u0006\u0010U\u001a\u00020\u0017H\u0016J*\u0010\\\u001a\u00020]2\u0010\u0010^\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030`0_2\u0006\u0010Z\u001a\u00020\u00172\u0006\u0010a\u001a\u00020bH\u0017J&\u0010c\u001a\u00020]2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020d0_2\u0006\u0010Z\u001a\u00020\u00172\u0006\u0010a\u001a\u00020bH\u0017J&\u0010e\u001a\u00020]2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020f0_2\u0006\u0010Z\u001a\u00020\u00172\u0006\u0010a\u001a\u00020bH\u0017J\u0010\u0010g\u001a\u00020h2\u0006\u0010E\u001a\u00020\u000fH\u0002J\u001c\u0010i\u001a\u00020]*\u00020j2\u0006\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020 H\u0002J\f\u0010n\u001a\u00020o*\u00020,H\u0002J\u001c\u0010p\u001a\u00020]*\u0002062\u0006\u00108\u001a\u0002092\u0006\u0010@\u001a\u00020 H\u0002J \u0010q\u001a\b\u0012\u0004\u0012\u00020?0>*\b\u0012\u0004\u0012\u00020l0>2\u0006\u0010m\u001a\u00020 H\u0002J\u0014\u0010r\u001a\u00020h*\u0002092\u0006\u0010s\u001a\u00020\u000fH\u0002J\f\u0010t\u001a\u00020h*\u000209H\u0002J\u001c\u0010u\u001a\u00020?*\u00020l2\u0006\u0010v\u001a\u00020w2\u0006\u0010@\u001a\u00020 H\u0002J \u0010x\u001a\u000e\u0012\u0004\u0012\u00020w\u0012\u0004\u0012\u00020h0Q*\u00020l2\u0006\u0010@\u001a\u00020 H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020 0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "baseModuleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "searchScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/FirModuleData;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getBaseModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result$ClassFileContent;", "facade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "getFacade", "()Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "knownClassNamesInPackage", "Lorg/jetbrains/kotlin/name/FqName;", "", "", "", "packageCache", "parentClassEffectiveVisibilityCache", "", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "parentClassTypeParameterStackCache", "Lorg/jetbrains/kotlin/fir/java/JavaTypeParameterStack;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scopeProvider", "Lorg/jetbrains/kotlin/fir/java/JavaScopeProvider;", "buildConstructorForAnnotationClass", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaConstructor;", "classSource", "Lorg/jetbrains/kotlin/fir/FirFakeSourceElement;", "constructorId", "Lorg/jetbrains/kotlin/name/CallableId;", "ownerClassBuilder", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaClassBuilder;", "valueParametersForAnnotationConstructor", "Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider$ValueParametersForAnnotationConstructor;", "convertJavaAnnotationMethodToValueParameter", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaValueParameter;", "javaMethod", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "firJavaMethod", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaMethod;", "convertJavaClassToFir", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaClass;", "classSymbol", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "convertJavaConstructorToFir", "javaConstructor", "Lorg/jetbrains/kotlin/load/java/structure/JavaConstructor;", "classTypeParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "javaTypeParameterStack", "convertJavaFieldToFir", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "javaField", "Lorg/jetbrains/kotlin/load/java/structure/JavaField;", "classId", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "convertJavaInitializerToFir", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "value", "", "convertJavaMethodToFir", "createFirJavaClass", "outerClassId", "parentClassSymbol", "findAndConvertJavaClass", "Lkotlin/Pair;", "content", "findClass", "findPackage", "fqName", "getClassLikeSymbolByFqName", "getFirJavaClass", "getKnownClassNames", "", "packageFqName", "getPackage", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "hasTopLevelClassOf", "", "addBounds", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirTypeParameterBuilder;", "javaTypeParameter", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "stack", "buildSelfTypeRef", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "convertSuperTypes", "convertTypeParameters", "hasDifferentClassId", "lookupClassId", "hasMetadataAnnotation", "toFirTypeParameter", "firSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "toFirTypeParameterSymbol", "Companion", "ValueParametersForAnnotationConstructor", "java"})
public final class JavaSymbolProvider
extends FirSymbolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirModuleData baseModuleData;
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;
    @NotNull
    private final FirCache<ClassId, FirRegularClassSymbol, KotlinClassFinder.Result.ClassFileContent> classCache;
    @NotNull
    private final FirCache packageCache;
    @NotNull
    private final FirCache knownClassNamesInPackage;
    @NotNull
    private final JavaScopeProvider scopeProvider;
    @NotNull
    private final Map<FirRegularClassSymbol, JavaTypeParameterStack> parentClassTypeParameterStackCache;
    @NotNull
    private final Map<FirRegularClassSymbol, EffectiveVisibility> parentClassEffectiveVisibilityCache;
    @NotNull
    private static final Name VALUE_METHOD_NAME;

    public JavaSymbolProvider(@NotNull FirSession session2, @NotNull FirModuleData baseModuleData, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)baseModuleData, (String)"baseModuleData");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        super(session2);
        this.baseModuleData = baseModuleData;
        this.project = project;
        this.searchScope = searchScope;
        this.classCache = FirCachesFactoryKt.getFirCachesFactory(session2).createCacheWithPostCompute((Function2)new Function2<ClassId, KotlinClassFinder.Result.ClassFileContent, Pair<? extends FirRegularClassSymbol, ? extends JavaClass>>((Object)this){

            @NotNull
            public final Pair<FirRegularClassSymbol, JavaClass> invoke(@NotNull ClassId p0, @Nullable KotlinClassFinder.Result.ClassFileContent p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JavaSymbolProvider.access$findAndConvertJavaClass((JavaSymbolProvider)this.receiver, p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "findAndConvertJavaClass(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result$ClassFileContent;)Lkotlin/Pair;";
            }

            @NotNull
            public final String getName() {
                return "findAndConvertJavaClass";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaSymbolProvider.class);
            }
        }, (Function3)new Function3<ClassId, FirRegularClassSymbol, JavaClass, Unit>(this){
            final /* synthetic */ JavaSymbolProvider this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull ClassId $noName_0, @Nullable FirRegularClassSymbol classSymbol, @Nullable JavaClass javaClass) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                if (classSymbol != null && javaClass != null) {
                    JavaSymbolProvider.access$convertJavaClassToFir(this.this$0, classSymbol, javaClass);
                }
            }
        });
        FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session2);
        boolean $i$f$createCache = false;
        this.packageCache = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ JavaSymbolProvider $receiver$inlined;
            {
                this.$receiver$inlined = javaSymbolProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                FqName p0 = (FqName)key;
                boolean bl = false;
                return JavaSymbolProvider.access$findPackage(this.$receiver$inlined, p0);
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session2);
        $i$f$createCache = false;
        this.knownClassNamesInPackage = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ JavaSymbolProvider $receiver$inlined;
            {
                this.$receiver$inlined = javaSymbolProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                FqName p0 = (FqName)key;
                boolean bl = false;
                return JavaSymbolProvider.access$getKnownClassNames(this.$receiver$inlined, p0);
            }
        });
        this.scopeProvider = new JavaScopeProvider(this);
        this.parentClassTypeParameterStackCache = new LinkedHashMap();
        this.parentClassEffectiveVisibilityCache = new LinkedHashMap();
    }

    @NotNull
    public final FirModuleData getBaseModuleData() {
        return this.baseModuleData;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final KotlinJavaPsiFacade getFacade() {
        KotlinJavaPsiFacade kotlinJavaPsiFacade = KotlinJavaPsiFacade.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinJavaPsiFacade, (String)"getInstance(project)");
        return kotlinJavaPsiFacade;
    }

    private final JavaClass findClass(ClassId classId, KotlinClassFinder.Result.ClassFileContent content) {
        KotlinClassFinder.Result.ClassFileContent classFileContent;
        return this.getFacade().findClass(new JavaClassFinder.Request(classId, (classFileContent = content) == null ? null : classFileContent.getContent(), null, 4, null), this.searchScope);
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    private final Pair<FirTypeParameterSymbol, Boolean> toFirTypeParameterSymbol(JavaTypeParameter $this$toFirTypeParameterSymbol, JavaTypeParameterStack javaTypeParameterStack) {
        FirTypeParameterSymbol stored = javaTypeParameterStack.safeGet($this$toFirTypeParameterSymbol);
        if (stored != null) {
            return TuplesKt.to((Object)stored, (Object)true);
        }
        FirTypeParameterSymbol firSymbol = new FirTypeParameterSymbol();
        javaTypeParameterStack.addParameter($this$toFirTypeParameterSymbol, firSymbol);
        return TuplesKt.to((Object)firSymbol, (Object)false);
    }

    private final FirTypeParameter toFirTypeParameter(JavaTypeParameter $this$toFirTypeParameter, FirTypeParameterSymbol firSymbol, JavaTypeParameterStack javaTypeParameterStack) {
        FirTypeParameterBuilder firTypeParameterBuilder;
        FirTypeParameterBuilder $this$toFirTypeParameter_u24lambda_u2d1 = firTypeParameterBuilder = new FirTypeParameterBuilder();
        boolean bl = false;
        $this$toFirTypeParameter_u24lambda_u2d1.setModuleData(this.getBaseModuleData());
        $this$toFirTypeParameter_u24lambda_u2d1.setOrigin(FirDeclarationOrigin.Java.INSTANCE);
        $this$toFirTypeParameter_u24lambda_u2d1.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
        $this$toFirTypeParameter_u24lambda_u2d1.setName($this$toFirTypeParameter.getName());
        $this$toFirTypeParameter_u24lambda_u2d1.setSymbol(firSymbol);
        $this$toFirTypeParameter_u24lambda_u2d1.setVariance(Variance.INVARIANT);
        $this$toFirTypeParameter_u24lambda_u2d1.setReified(false);
        this.addBounds($this$toFirTypeParameter_u24lambda_u2d1, $this$toFirTypeParameter, javaTypeParameterStack);
        return firTypeParameterBuilder.build();
    }

    private final void addBounds(FirTypeParameterBuilder $this$addBounds, JavaTypeParameter javaTypeParameter, JavaTypeParameterStack stack) {
        for (JavaClassifierType upperBound : javaTypeParameter.getUpperBounds()) {
            FirTypeParameterBuilder firTypeParameterBuilder = $this$addBounds;
            ((Collection)firTypeParameterBuilder.getBounds()).add(JavaUtilsKt.toFirResolvedTypeRef(upperBound, this.getSession(), stack, false, true));
        }
        FirDeclarationBuildingUtilsKt.addDefaultBoundIfNecessary($this$addBounds, true);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeParameter> convertTypeParameters(List<? extends JavaTypeParameter> $this$convertTypeParameters, JavaTypeParameterStack stack) {
        void $this$mapIndexedTo$iv$iv;
        Object object;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$convertTypeParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JavaTypeParameter javaTypeParameter = (JavaTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = this.toFirTypeParameterSymbol((JavaTypeParameter)it, stack);
            collection.add(object);
        }
        Iterable $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void $dstr$symbol$initialized;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeParameterSymbol symbol2 = (FirTypeParameterSymbol)$dstr$symbol$initialized.component1();
            boolean initialized = (Boolean)$dstr$symbol$initialized.component2();
            object = initialized ? (FirTypeParameter)symbol2.getFir() : this.toFirTypeParameter($this$convertTypeParameters.get((int)index2), symbol2, stack);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByFqName(@NotNull ClassId classId) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        try {
            if (!this.hasTopLevelClassOf(classId)) {
                return null;
            }
            firRegularClassSymbol = JavaSymbolProvider.getFirJavaClass$default(this, classId, null, 2, null);
        }
        catch (ProcessCanceledException e) {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }

    @Nullable
    public final FirRegularClassSymbol getFirJavaClass(@NotNull ClassId classId, @Nullable KotlinClassFinder.Result.ClassFileContent content) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 != null) {
            ClassId classId3;
            ClassId it = classId3 = classId2;
            boolean bl = false;
            JavaSymbolProvider.getFirJavaClass$default(this, it, null, 2, null);
        }
        return this.classCache.getValue(classId, content);
    }

    public static /* synthetic */ FirRegularClassSymbol getFirJavaClass$default(JavaSymbolProvider javaSymbolProvider, ClassId classId, KotlinClassFinder.Result.ClassFileContent classFileContent, int n, Object object) {
        if ((n & 2) != 0) {
            classFileContent = null;
        }
        return javaSymbolProvider.getFirJavaClass(classId, classFileContent);
    }

    private final Pair<FirRegularClassSymbol, JavaClass> findAndConvertJavaClass(ClassId classId, KotlinClassFinder.Result.ClassFileContent content) {
        Pair pair;
        JavaClass foundClass = this.findClass(classId, content);
        if (foundClass == null || this.hasDifferentClassId(foundClass, classId) || this.hasMetadataAnnotation(foundClass)) {
            pair = TuplesKt.to(null, null);
        } else {
            FirRegularClassSymbol symbol2 = new FirRegularClassSymbol(classId);
            pair = TuplesKt.to((Object)symbol2, (Object)foundClass);
        }
        return pair;
    }

    private final boolean hasDifferentClassId(JavaClass $this$hasDifferentClassId, ClassId lookupClassId) {
        return !Intrinsics.areEqual((Object)JavaElementsKt.getClassId($this$hasDifferentClassId), (Object)lookupClassId);
    }

    private final boolean hasMetadataAnnotation(JavaClass $this$hasMetadataAnnotation) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasMetadataAnnotation.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JavaAnnotation it = (JavaAnnotation)element$iv;
                    boolean bl2 = false;
                    ClassId classId = it.getClassId();
                    if (!Intrinsics.areEqual((Object)(classId == null ? null : classId.asSingleFqName()), (Object)JvmAnnotationNames.METADATA_FQ_NAME)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final FirJavaClass convertJavaClassToFir(FirRegularClassSymbol classSymbol, JavaClass javaClass) {
        Object parentStack;
        FirRegularClassSymbol parentClassSymbol;
        ClassId classId = classSymbol.getClassId();
        JavaTypeParameterStack javaTypeParameterStack = new JavaTypeParameterStack();
        ClassId outerClassId = classId.getOuterClassId();
        FirRegularClassSymbol firRegularClassSymbol = parentClassSymbol = outerClassId != null ? this.getClassLikeSymbolByFqName(outerClassId) : null;
        if (parentClassSymbol != null) {
            Object object;
            JavaTypeParameterStack javaTypeParameterStack2 = this.parentClassTypeParameterStackCache.get(parentClassSymbol);
            if (javaTypeParameterStack2 == null) {
                FirJavaClass firJavaClass;
                Object e = parentClassSymbol.getFir();
                FirJavaClass firJavaClass2 = firJavaClass = e instanceof FirJavaClass ? (FirJavaClass)e : null;
                object = firJavaClass == null ? null : firJavaClass.getJavaTypeParameterStack$java();
            } else {
                object = parentStack = javaTypeParameterStack2;
            }
            if (parentStack != null) {
                javaTypeParameterStack.addStack((JavaTypeParameterStack)parentStack);
            }
        }
        parentStack = this.parentClassTypeParameterStackCache;
        parentStack.put((FirRegularClassSymbol)classSymbol, (JavaTypeParameterStack)javaTypeParameterStack);
        FirJavaClass firJavaClass = this.createFirJavaClass(javaClass, classSymbol, outerClassId, parentClassSymbol, classId, javaTypeParameterStack);
        this.parentClassTypeParameterStackCache.remove(classSymbol);
        this.parentClassEffectiveVisibilityCache.remove(classSymbol);
        this.convertSuperTypes(firJavaClass, javaClass, javaTypeParameterStack);
        JavaUtilsKt.addAnnotationsFrom(firJavaClass, this.getSession(), (JavaAnnotationOwner)javaClass, javaTypeParameterStack);
        firJavaClass.replaceDeprecation(DeprecationUtilsKt.getDeprecationInfos(firJavaClass, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).getApiVersion()));
        return firJavaClass;
    }

    /*
     * WARNING - void declaration
     */
    private final void convertSuperTypes(FirJavaClass $this$convertSuperTypes, JavaClass javaClass, JavaTypeParameterStack javaTypeParameterStack) {
        Collection<FirResolvedTypeRef> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = javaClass.getSupertypes();
        FirJavaClass firJavaClass = $this$convertSuperTypes;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void supertype2;
            JavaClassifierType javaClassifierType = (JavaClassifierType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirResolvedTypeRef firResolvedTypeRef = JavaUtilsKt.toFirResolvedTypeRef((JavaClassifierType)supertype2, this.getSession(), javaTypeParameterStack, true, false);
            collection.add(firResolvedTypeRef);
        }
        collection = (List)destination$iv$iv;
        firJavaClass.replaceSuperTypeRefs((List<? extends FirTypeRef>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final FirJavaClass createFirJavaClass(JavaClass javaClass, FirRegularClassSymbol classSymbol, ClassId outerClassId, FirRegularClassSymbol parentClassSymbol, ClassId classId, JavaTypeParameterStack javaTypeParameterStack) {
        Pair<JavaMethod, FirJavaValueParameter> $this$mapNotNullTo$iv$iv;
        FirJavaClass firJavaClass;
        JavaClassifier $this$toFirPsiSourceElement$iv;
        void $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d11;
        Object it;
        Object item$iv$iv;
        void $this$mapTo$iv$iv;
        Iterator<JavaMethod> $this$map$iv;
        Object object;
        FirOuterClassTypeParameterRefBuilder firOuterClassTypeParameterRefBuilder;
        Object object2;
        FirTypeParameterRef item$iv$iv2;
        Object object3;
        Object it2;
        EffectiveVisibility effectiveVisibility;
        Object kind$iv;
        Object $this$toFirPsiSourceElement_u24default$iv;
        Object object4;
        FirPsiSourceElement firPsiSourceElement;
        JavaElementImpl javaElementImpl;
        FirJavaClassBuilder firJavaClassBuilder;
        ValueParametersForAnnotationConstructor valueParametersForAnnotationConstructor = new ValueParametersForAnnotationConstructor();
        boolean classIsAnnotation = JavaUtilsKt.getClassKind(javaClass) == ClassKind.ANNOTATION_CLASS;
        boolean $i$f$buildJavaClass = false;
        FirJavaClassBuilder $this$createFirJavaClass_u24lambda_u2d12 = firJavaClassBuilder = new FirJavaClassBuilder();
        boolean bl = false;
        JavaElementImpl javaElementImpl2 = javaElementImpl = javaClass instanceof JavaElementImpl ? (JavaElementImpl)((Object)javaClass) : null;
        if (javaElementImpl == null) {
            firPsiSourceElement = null;
        } else {
            object4 = javaElementImpl.getPsi();
            if (object4 == null) {
                firPsiSourceElement = null;
            } else {
                $this$toFirPsiSourceElement_u24default$iv = object4;
                kind$iv = FirRealSourceElementKind.INSTANCE;
                boolean $i$f$toFirPsiSourceElement = false;
                Object object5 = kind$iv;
                if (object5 instanceof FirRealSourceElementKind) {
                    firPsiSourceElement = new FirRealPsiSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv);
                } else if (object5 instanceof FirFakeSourceElementKind) {
                    firPsiSourceElement = new FirFakeSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv, (FirFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        $this$createFirJavaClass_u24lambda_u2d12.setSource(firPsiSourceElement);
        $this$createFirJavaClass_u24lambda_u2d12.setModuleData(this.getBaseModuleData());
        $this$createFirJavaClass_u24lambda_u2d12.setSymbol(classSymbol);
        $this$createFirJavaClass_u24lambda_u2d12.setName(javaClass.getName());
        Visibility visibility2 = javaClass.getVisibility();
        $this$createFirJavaClass_u24lambda_u2d12.setVisibility(visibility2);
        $this$createFirJavaClass_u24lambda_u2d12.setClassKind(JavaUtilsKt.getClassKind(javaClass));
        $this$createFirJavaClass_u24lambda_u2d12.setModality($this$createFirJavaClass_u24lambda_u2d12.getClassKind() == ClassKind.ANNOTATION_CLASS || $this$createFirJavaClass_u24lambda_u2d12.getClassKind() == ClassKind.ENUM_CLASS ? Modality.FINAL : JavaUtilsKt.getModality(javaClass));
        $this$createFirJavaClass_u24lambda_u2d12.setTopLevel(outerClassId == null);
        $this$createFirJavaClass_u24lambda_u2d12.setStatic(javaClass.isStatic());
        $this$createFirJavaClass_u24lambda_u2d12.setJavaTypeParameterStack(javaTypeParameterStack);
        object4 = $this$createFirJavaClass_u24lambda_u2d12;
        $this$toFirPsiSourceElement_u24default$iv = ((FirJavaClassBuilder)object4).getExistingNestedClassifierNames();
        kind$iv = javaClass.getInnerClassNames();
        CollectionsKt.addAll($this$toFirPsiSourceElement_u24default$iv, (Iterable)kind$iv);
        $this$createFirJavaClass_u24lambda_u2d12.setScopeProvider(this.scopeProvider);
        $this$toFirPsiSourceElement_u24default$iv = parentClassSymbol;
        EffectiveVisibility selfEffectiveVisibility = EffectiveVisibilityUtilsKt.toEffectiveVisibility$default(visibility2, $this$toFirPsiSourceElement_u24default$iv == null ? null : ((FirClassSymbol)$this$toFirPsiSourceElement_u24default$iv).toLookupTag(), true, false, 4, null);
        kind$iv = parentClassSymbol;
        if (kind$iv == null) {
            effectiveVisibility = EffectiveVisibility.Public.INSTANCE;
        } else {
            Object $i$f$toFirPsiSourceElement;
            it2 = $i$f$toFirPsiSourceElement = kind$iv;
            boolean bl2 = false;
            EffectiveVisibility effectiveVisibility2 = this.parentClassEffectiveVisibilityCache.get(it2);
            if (effectiveVisibility2 == null) {
                FirMemberDeclaration $this$effectiveVisibility$iv = (FirMemberDeclaration)((FirBasedSymbol)it2).getFir();
                boolean bl3 = false;
                FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
                Object object5 = object3 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
                if (object3 == null) {
                    throw new IllegalStateException(("Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved").toString());
                }
                effectiveVisibility = object3.getEffectiveVisibility();
            } else {
                effectiveVisibility = effectiveVisibility2;
            }
        }
        Object parentEffectiveVisibility = effectiveVisibility;
        EffectiveVisibility effectiveVisibility3 = ((EffectiveVisibility)parentEffectiveVisibility).lowerBound(selfEffectiveVisibility, SessionUtilsKt.getTypeContext(this.getSession()));
        Map<FirRegularClassSymbol, EffectiveVisibility> $i$f$toFirPsiSourceElement = this.parentClassEffectiveVisibilityCache;
        $i$f$toFirPsiSourceElement.put(classSymbol, effectiveVisibility3);
        List<FirTypeParameter> classTypeParameters = this.convertTypeParameters(javaClass.getTypeParameters(), javaTypeParameterStack);
        it2 = $this$createFirJavaClass_u24lambda_u2d12;
        Iterable bl2 = ((FirJavaClassBuilder)it2).getTypeParameters();
        CollectionsKt.addAll((Collection)bl2, (Iterable)classTypeParameters);
        if (!$this$createFirJavaClass_u24lambda_u2d12.isStatic() && parentClassSymbol != null) {
            it2 = $this$createFirJavaClass_u24lambda_u2d12;
            bl2 = ((FirJavaClassBuilder)it2).getTypeParameters();
            Iterable $this$map$iv2 = ((FirRegularClass)parentClassSymbol.getFir()).getTypeParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void it3;
                FirTypeParameterRef firTypeParameterRef = item$iv$iv2 = iterator2.next();
                object2 = destination$iv$iv;
                boolean bl3 = false;
                boolean $i$f$buildOuterClassTypeParameterRef = false;
                FirOuterClassTypeParameterRefBuilder $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d9_u24lambda_u2d8 = firOuterClassTypeParameterRefBuilder = new FirOuterClassTypeParameterRefBuilder();
                boolean bl4 = false;
                $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d9_u24lambda_u2d8.setSymbol(it3.getSymbol());
                object = firOuterClassTypeParameterRefBuilder.build();
                object2.add(object);
            }
            $this$map$iv2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)bl2, (Iterable)$this$map$iv2);
        }
        bl2 = $this$createFirJavaClass_u24lambda_u2d12.getTypeParameters();
        object2 = classId;
        boolean $i$f$map232 = false;
        void $i$f$map = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo32 = false;
        Object $i$f$mapTo2 = $this$mapTo$iv$iv.iterator();
        while ($i$f$mapTo2.hasNext()) {
            item$iv$iv = $i$f$mapTo2.next();
            item$iv$iv2 = (FirTypeParameterRef)item$iv$iv;
            object = collection;
            boolean bl5 = false;
            FirTypeParameterSymbol firTypeParameterSymbol = it.getSymbol();
            object.add(firTypeParameterSymbol);
        }
        object = (List)collection;
        ConeClassLikeType dispatchReceiver = ScopeUtilsKt.defaultType((ClassId)object2, (List<FirTypeParameterSymbol>)object);
        Modality modality = $this$createFirJavaClass_u24lambda_u2d12.getModality();
        Intrinsics.checkNotNull((Object)((Object)modality));
        $this$map$iv = new FirResolvedDeclarationStatusImpl(visibility2, modality, effectiveVisibility3);
        FirResolvedDeclarationStatusImpl $i$f$map232 = $this$map$iv;
        object2 = $this$createFirJavaClass_u24lambda_u2d12;
        boolean bl622 = false;
        $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d11.setInner(!$this$createFirJavaClass_u24lambda_u2d12.isTopLevel() && !$this$createFirJavaClass_u24lambda_u2d12.isStatic());
        $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d11.setCompanion(false);
        $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d11.setData(false);
        $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d11.setInline(false);
        $this$createFirJavaClass_u24lambda_u2d12_u24lambda_u2d11.setFun($this$createFirJavaClass_u24lambda_u2d12.getClassKind() == ClassKind.INTERFACE);
        object = Unit.INSTANCE;
        ((FirRegularClassBuilder)object2).setStatus((FirDeclarationStatus)((Object)$this$map$iv));
        for (JavaField javaField2 : javaClass.getFields()) {
            FirJavaClassBuilder bl622 = $this$createFirJavaClass_u24lambda_u2d12;
            Collection collection2 = bl622.getDeclarations();
            FirDeclaration $i$f$mapTo32 = this.convertJavaFieldToFir(javaField2, classId, javaTypeParameterStack, dispatchReceiver);
            collection2.add($i$f$mapTo32);
        }
        for (JavaMethod javaMethod : javaClass.getMethods()) {
            if (JavaLoadingKt.isObjectMethodInInterface(javaMethod)) continue;
            FirJavaMethod firJavaMethod = this.convertJavaMethodToFir(javaMethod, classId, javaTypeParameterStack, dispatchReceiver);
            FirJavaClassBuilder firJavaClassBuilder2 = $this$createFirJavaClass_u24lambda_u2d12;
            Object $i$f$mapTo32 = firJavaClassBuilder2.getDeclarations();
            $i$f$mapTo32.add(firJavaMethod);
            if (!classIsAnnotation) continue;
            FirJavaValueParameter firJavaValueParameter = this.convertJavaAnnotationMethodToValueParameter(javaMethod, firJavaMethod);
            if (Intrinsics.areEqual((Object)javaMethod.getName(), (Object)VALUE_METHOD_NAME)) {
                valueParametersForAnnotationConstructor.setValueParameterForValue((Pair<? extends JavaMethod, FirJavaValueParameter>)TuplesKt.to((Object)javaMethod, (Object)firJavaValueParameter));
                continue;
            }
            $i$f$mapTo32 = valueParametersForAnnotationConstructor.getValueParameters();
            $i$f$mapTo32.put(javaMethod, firJavaValueParameter);
        }
        Collection<JavaConstructor> javaClassDeclaredConstructors = javaClass.getConstructors();
        Object firJavaMethod = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)firJavaMethod, (String)"classId.packageFqName");
        FqName fqName2 = firJavaMethod;
        FqName fqName3 = classId.getRelativeClassName();
        firJavaMethod = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)firJavaMethod, (String)"classId.shortClassName");
        Object constructorId = new CallableId(fqName2, fqName3, (Name)firJavaMethod, null, 8, null);
        if (javaClassDeclaredConstructors.isEmpty() && JavaUtilsKt.getClassKind(javaClass) == ClassKind.CLASS && javaClass.hasDefaultConstructor()) {
            firJavaMethod = $this$createFirJavaClass_u24lambda_u2d12;
            Collection collection3 = ((FirJavaClassBuilder)firJavaMethod).getDeclarations();
            FirJavaConstructor $i$f$mapTo32 = this.convertJavaConstructorToFir(null, (CallableId)constructorId, javaClass, $this$createFirJavaClass_u24lambda_u2d12, classTypeParameters, javaTypeParameterStack);
            collection3.add($i$f$mapTo32);
        }
        for (JavaConstructor javaConstructor : javaClassDeclaredConstructors) {
            FirJavaClassBuilder $i$f$mapTo32 = $this$createFirJavaClass_u24lambda_u2d12;
            $i$f$mapTo2 = $i$f$mapTo32.getDeclarations();
            item$iv$iv = this.convertJavaConstructorToFir(javaConstructor, (CallableId)constructorId, javaClass, $this$createFirJavaClass_u24lambda_u2d12, classTypeParameters, javaTypeParameterStack);
            $i$f$mapTo2.add(item$iv$iv);
        }
        if ($this$createFirJavaClass_u24lambda_u2d12.getClassKind() == ClassKind.ENUM_CLASS) {
            FirRegularClassBuilder firRegularClassBuilder = $this$createFirJavaClass_u24lambda_u2d12;
            FirModuleData firModuleData = this.getBaseModuleData();
            firJavaMethod = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)firJavaMethod, (String)"classId.packageFqName");
            Object object6 = firJavaMethod;
            firJavaMethod = classId.getRelativeClassName();
            Intrinsics.checkNotNullExpressionValue((Object)firJavaMethod, (String)"classId.relativeClassName");
            EnumClassUtilsKt.generateValuesFunction$default(firRegularClassBuilder, firModuleData, (FqName)object6, (FqName)firJavaMethod, false, 8, null);
            FirRegularClassBuilder firRegularClassBuilder2 = $this$createFirJavaClass_u24lambda_u2d12;
            FirModuleData firModuleData2 = this.getBaseModuleData();
            firJavaMethod = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)firJavaMethod, (String)"classId.packageFqName");
            Object object7 = firJavaMethod;
            firJavaMethod = classId.getRelativeClassName();
            Intrinsics.checkNotNullExpressionValue((Object)firJavaMethod, (String)"classId.relativeClassName");
            EnumClassUtilsKt.generateValueOfFunction$default(firRegularClassBuilder2, firModuleData2, (FqName)object7, (FqName)firJavaMethod, false, 8, null);
        }
        if (classIsAnnotation) {
            Object object8;
            firJavaMethod = $this$createFirJavaClass_u24lambda_u2d12;
            Collection collection4 = ((FirJavaClassBuilder)firJavaMethod).getDeclarations();
            Object object9 = $i$f$mapTo2 = javaClass instanceof JavaElementImpl ? (JavaElementImpl)((Object)javaClass) : null;
            if ($i$f$mapTo2 == null) {
                object8 = null;
            } else {
                item$iv$iv = ((JavaElementImpl)$i$f$mapTo2).getPsi();
                if (item$iv$iv == null) {
                    object8 = null;
                } else {
                    it = item$iv$iv;
                    FirSourceElementKind kind$iv2 = FirFakeSourceElementKind.ImplicitConstructor.INSTANCE;
                    boolean $i$f$toFirPsiSourceElement2 = false;
                    FirSourceElementKind $i$f$buildOuterClassTypeParameterRef = kind$iv2;
                    if ($i$f$buildOuterClassTypeParameterRef instanceof FirRealSourceElementKind) {
                        object8 = new FirRealPsiSourceElement((PsiElement)((Object)$this$toFirPsiSourceElement$iv));
                    } else if ($i$f$buildOuterClassTypeParameterRef instanceof FirFakeSourceElementKind) {
                        object8 = new FirFakeSourceElement((PsiElement)((Object)$this$toFirPsiSourceElement$iv), (FirFakeSourceElementKind)kind$iv2);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            FirJavaConstructor $i$f$mapTo32 = object8;
            $i$f$mapTo32 = this.buildConstructorForAnnotationClass($i$f$mapTo32 instanceof FirFakeSourceElement ? (FirFakeSourceElement)((Object)$i$f$mapTo32) : null, (CallableId)constructorId, $this$createFirJavaClass_u24lambda_u2d12, valueParametersForAnnotationConstructor);
            collection4.add($i$f$mapTo32);
        }
        FirJavaClass $this$createFirJavaClass_u24lambda_u2d17 = firJavaClass = firJavaClassBuilder.build();
        boolean bl7 = false;
        FirMemberDeclaration $this$modality$iv = $this$createFirJavaClass_u24lambda_u2d17;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.SEALED) {
            Iterable $this$mapNotNull$iv = javaClass.getPermittedTypes();
            boolean $i$f$mapNotNull = false;
            parentEffectiveVisibility = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Pair<JavaMethod, FirJavaValueParameter> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            constructorId = $this$forEach$iv$iv$iv.iterator();
            while (constructorId.hasNext()) {
                FirOuterClassTypeParameterRefBuilder firOuterClassTypeParameterRefBuilder2;
                ClassId classId2;
                Object element$iv$iv$iv;
                Object e = element$iv$iv$iv = constructorId.next();
                boolean bl8 = false;
                JavaClassifierType classifierType = (JavaClassifierType)e;
                boolean bl9 = false;
                $this$toFirPsiSourceElement$iv = classifierType.getClassifier();
                JavaClass classifier2 = $this$toFirPsiSourceElement$iv instanceof JavaClass ? (JavaClass)$this$toFirPsiSourceElement$iv : null;
                $this$toFirPsiSourceElement$iv = classifier2;
                if ($this$toFirPsiSourceElement$iv == null) {
                    classId2 = null;
                } else {
                    Object it4 = object2 = $this$toFirPsiSourceElement$iv;
                    boolean bl10 = false;
                    FqName fqName4 = it4.getFqName();
                    Intrinsics.checkNotNull((Object)fqName4);
                    classId2 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName4);
                }
                firOuterClassTypeParameterRefBuilder = classId2;
                if (firOuterClassTypeParameterRefBuilder == null) continue;
                FirOuterClassTypeParameterRefBuilder it$iv$iv = firOuterClassTypeParameterRefBuilder2 = firOuterClassTypeParameterRefBuilder;
                boolean bl11 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List inheritors = (List)destination$iv$iv2;
            SealedClassInheritorsKt.setSealedClassInheritors($this$createFirJavaClass_u24lambda_u2d17, inheritors);
        }
        if (classIsAnnotation) {
            FirJavaValueParameter firValueParameter;
            Object javaDefaultValue;
            JavaMethod javaMethod;
            Unit unit2;
            ValueParametersForAnnotationConstructor this_$iv = valueParametersForAnnotationConstructor;
            boolean $i$f$forEach = false;
            Pair<JavaMethod, FirJavaValueParameter> $i$f$mapNotNull = this_$iv.getValueParameterForValue();
            if ($i$f$mapNotNull == null) {
                unit2 = null;
            } else {
                Unit unit3;
                Pair<JavaMethod, FirJavaValueParameter> $dstr$javaMethod$firJavaValueParameter$iv = $this$mapNotNullTo$iv$iv = $i$f$mapNotNull;
                boolean bl12 = false;
                JavaMethod javaMethod$iv = (JavaMethod)$dstr$javaMethod$firJavaValueParameter$iv.component1();
                FirJavaValueParameter firJavaValueParameter$iv = (FirJavaValueParameter)$dstr$javaMethod$firJavaValueParameter$iv.component2();
                constructorId = firJavaValueParameter$iv;
                javaMethod = javaMethod$iv;
                boolean bl4 = false;
                JavaAnnotationArgument javaAnnotationArgument = javaMethod.getAnnotationParameterDefaultValue();
                if (javaAnnotationArgument == null) {
                    unit3 = null;
                } else {
                    javaDefaultValue = object3 = javaAnnotationArgument;
                    boolean bl14 = false;
                    firValueParameter.setDefaultValue(JavaUtilsKt.toFirExpression((JavaAnnotationArgument)javaDefaultValue, this.getSession(), javaTypeParameterStack, firValueParameter.getReturnTypeRef()));
                    unit3 = Unit.INSTANCE;
                }
                unit2 = Unit.INSTANCE;
            }
            Map<JavaMethod, FirJavaValueParameter> $this$forEach$iv$iv = this_$iv.getValueParameters();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<JavaMethod, FirJavaValueParameter>> iterator3 = $this$forEach$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Unit unit4;
                FirJavaValueParameter firJavaValueParameter$iv;
                Map.Entry<JavaMethod, FirJavaValueParameter> element$iv$iv;
                Map.Entry<JavaMethod, FirJavaValueParameter> $dstr$javaMethod$firJavaValueParameter$iv = element$iv$iv = iterator3.next();
                boolean bl15 = false;
                JavaMethod javaMethod$iv = $dstr$javaMethod$firJavaValueParameter$iv.getKey();
                firValueParameter = firJavaValueParameter$iv = $dstr$javaMethod$firJavaValueParameter$iv.getValue();
                javaMethod = javaMethod$iv;
                boolean bl5 = false;
                JavaAnnotationArgument javaAnnotationArgument = javaMethod.getAnnotationParameterDefaultValue();
                if (javaAnnotationArgument == null) {
                    unit4 = null;
                    continue;
                }
                javaDefaultValue = object3 = javaAnnotationArgument;
                boolean bl17 = false;
                firValueParameter.setDefaultValue(JavaUtilsKt.toFirExpression((JavaAnnotationArgument)javaDefaultValue, this.getSession(), javaTypeParameterStack, firValueParameter.getReturnTypeRef()));
                unit4 = Unit.INSTANCE;
            }
        }
        return firJavaClass;
    }

    /*
     * WARNING - void declaration
     */
    private final FirDeclaration convertJavaFieldToFir(JavaField javaField2, ClassId classId, JavaTypeParameterStack javaTypeParameterStack, ConeClassLikeType dispatchReceiver) {
        FirDeclaration firDeclaration;
        Name fieldName = javaField2.getName();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
        CallableId fieldId = new CallableId(fqName2, classId.getRelativeClassName(), fieldName, null, 8, null);
        JavaType returnType2 = javaField2.getType();
        if (javaField2.isEnumEntry()) {
            void $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18;
            Object object;
            FirPsiSourceElement firPsiSourceElement;
            Object object2;
            FirEnumEntryBuilder firEnumEntryBuilder;
            boolean $i$f$buildEnumEntry = false;
            FirEnumEntryBuilder $this$convertJavaFieldToFir_u24lambda_u2d19 = firEnumEntryBuilder = new FirEnumEntryBuilder();
            boolean bl = false;
            Object object3 = object2 = javaField2 instanceof JavaElementImpl ? (JavaElementImpl)((Object)javaField2) : null;
            if (object2 == null) {
                firPsiSourceElement = null;
            } else {
                object = ((JavaElementImpl)object2).getPsi();
                if (object == null) {
                    firPsiSourceElement = null;
                } else {
                    Object $this$toFirPsiSourceElement_u24default$iv = object;
                    FirSourceElementKind kind$iv = FirRealSourceElementKind.INSTANCE;
                    boolean $i$f$toFirPsiSourceElement = false;
                    FirSourceElementKind firSourceElementKind = kind$iv;
                    if (firSourceElementKind instanceof FirRealSourceElementKind) {
                        firPsiSourceElement = new FirRealPsiSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv);
                    } else if (firSourceElementKind instanceof FirFakeSourceElementKind) {
                        firPsiSourceElement = new FirFakeSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv, (FirFakeSourceElementKind)kind$iv);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            $this$convertJavaFieldToFir_u24lambda_u2d19.setSource(firPsiSourceElement);
            $this$convertJavaFieldToFir_u24lambda_u2d19.setModuleData(this.getBaseModuleData());
            $this$convertJavaFieldToFir_u24lambda_u2d19.setSymbol(new FirEnumEntrySymbol(fieldId));
            $this$convertJavaFieldToFir_u24lambda_u2d19.setName(fieldName);
            object2 = new FirResolvedDeclarationStatusImpl(javaField2.getVisibility(), JavaUtilsKt.getModality(javaField2), EffectiveVisibilityUtilsKt.toEffectiveVisibility$default(javaField2.getVisibility(), dispatchReceiver.getLookupTag(), false, false, 6, null));
            object = object2;
            FirEnumEntryBuilder firEnumEntryBuilder2 = $this$convertJavaFieldToFir_u24lambda_u2d19;
            boolean bl2 = false;
            $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18.setStatic(javaField2.isStatic());
            $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18.setExpect(false);
            $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18.setActual(false);
            $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18.setOverride(false);
            Unit unit2 = Unit.INSTANCE;
            firEnumEntryBuilder2.setStatus((FirDeclarationStatus)object2);
            $this$convertJavaFieldToFir_u24lambda_u2d19.setReturnTypeRef(JavaUtilsKt.toFirJavaTypeRef(returnType2, this.getSession(), javaTypeParameterStack));
            $this$convertJavaFieldToFir_u24lambda_u2d19.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            $this$convertJavaFieldToFir_u24lambda_u2d19.setOrigin(FirDeclarationOrigin.Java.INSTANCE);
            JavaUtilsKt.addAnnotationsFrom($this$convertJavaFieldToFir_u24lambda_u2d19, this.getSession(), (JavaAnnotationOwner)javaField2, javaTypeParameterStack);
            FirEnumEntry $this$convertJavaFieldToFir_u24lambda_u2d20 = $i$f$buildEnumEntry = firEnumEntryBuilder.build();
            boolean bl3 = false;
            ClassMembersKt.setContainingClassForStaticMemberAttr($this$convertJavaFieldToFir_u24lambda_u2d20, new ConeClassLikeLookupTagImpl(classId));
            firDeclaration = $i$f$buildEnumEntry;
        } else {
            FirJavaField firJavaField;
            void $this$convertJavaFieldToFir_u24lambda_u2d22_u24lambda_u2d21;
            Object $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18;
            FirPsiSourceElement firPsiSourceElement;
            Object object;
            FirJavaFieldBuilder $this$convertJavaFieldToFir_u24lambda_u2d20;
            boolean $i$f$buildJavaField = false;
            FirJavaFieldBuilder $this$convertJavaFieldToFir_u24lambda_u2d22 = $this$convertJavaFieldToFir_u24lambda_u2d20 = new FirJavaFieldBuilder();
            boolean bl = false;
            Object object4 = object = javaField2 instanceof JavaElementImpl ? (JavaElementImpl)((Object)javaField2) : null;
            if (object == null) {
                firPsiSourceElement = null;
            } else {
                $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18 = ((JavaElementImpl)object).getPsi();
                if ($this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18 == null) {
                    firPsiSourceElement = null;
                } else {
                    Object $this$toFirPsiSourceElement_u24default$iv = $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18;
                    FirSourceElementKind kind$iv = FirRealSourceElementKind.INSTANCE;
                    boolean $i$f$toFirPsiSourceElement = false;
                    FirSourceElementKind firSourceElementKind = kind$iv;
                    if (firSourceElementKind instanceof FirRealSourceElementKind) {
                        firPsiSourceElement = new FirRealPsiSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv);
                    } else if (firSourceElementKind instanceof FirFakeSourceElementKind) {
                        firPsiSourceElement = new FirFakeSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv, (FirFakeSourceElementKind)kind$iv);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            $this$convertJavaFieldToFir_u24lambda_u2d22.setSource(firPsiSourceElement);
            $this$convertJavaFieldToFir_u24lambda_u2d22.setModuleData(this.getBaseModuleData());
            $this$convertJavaFieldToFir_u24lambda_u2d22.setSymbol(new FirFieldSymbol(fieldId));
            $this$convertJavaFieldToFir_u24lambda_u2d22.setName(fieldName);
            object = new FirResolvedDeclarationStatusImpl(javaField2.getVisibility(), JavaUtilsKt.getModality(javaField2), EffectiveVisibilityUtilsKt.toEffectiveVisibility$default(javaField2.getVisibility(), dispatchReceiver.getLookupTag(), false, false, 6, null));
            $this$convertJavaFieldToFir_u24lambda_u2d19_u24lambda_u2d18 = object;
            FirJavaFieldBuilder firJavaFieldBuilder = $this$convertJavaFieldToFir_u24lambda_u2d22;
            boolean bl4 = false;
            $this$convertJavaFieldToFir_u24lambda_u2d22_u24lambda_u2d21.setStatic(javaField2.isStatic());
            $this$convertJavaFieldToFir_u24lambda_u2d22_u24lambda_u2d21.setExpect(false);
            $this$convertJavaFieldToFir_u24lambda_u2d22_u24lambda_u2d21.setActual(false);
            $this$convertJavaFieldToFir_u24lambda_u2d22_u24lambda_u2d21.setOverride(false);
            Unit unit3 = Unit.INSTANCE;
            firJavaFieldBuilder.setStatus((FirDeclarationStatus)object);
            $this$convertJavaFieldToFir_u24lambda_u2d22.setVisibility(javaField2.getVisibility());
            $this$convertJavaFieldToFir_u24lambda_u2d22.setModality(JavaUtilsKt.getModality(javaField2));
            $this$convertJavaFieldToFir_u24lambda_u2d22.setReturnTypeRef(JavaUtilsKt.toFirJavaTypeRef(returnType2, this.getSession(), javaTypeParameterStack));
            $this$convertJavaFieldToFir_u24lambda_u2d22.setVar(!javaField2.isFinal());
            $this$convertJavaFieldToFir_u24lambda_u2d22.setStatic(javaField2.isStatic());
            $this$convertJavaFieldToFir_u24lambda_u2d22.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotationCall>>)((Function0)new Function0<List<? extends FirAnnotationCall>>(javaField2, this, javaTypeParameterStack){
                final /* synthetic */ JavaField $javaField;
                final /* synthetic */ JavaSymbolProvider this$0;
                final /* synthetic */ JavaTypeParameterStack $javaTypeParameterStack;
                {
                    this.$javaField = $javaField;
                    this.this$0 = $receiver;
                    this.$javaTypeParameterStack = $javaTypeParameterStack;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<FirAnnotationCall> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$javaField.getAnnotations();
                    JavaSymbolProvider javaSymbolProvider = this.this$0;
                    JavaTypeParameterStack javaTypeParameterStack = this.$javaTypeParameterStack;
                    boolean $i$f$map = false;
                    void var5_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JavaAnnotation javaAnnotation = (JavaAnnotation)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        FirAnnotationCall firAnnotationCall = JavaUtilsKt.toFirAnnotationCall((JavaAnnotation)it, javaSymbolProvider.getSession(), javaTypeParameterStack);
                        collection.add(firAnnotationCall);
                    }
                    return (List)destination$iv$iv;
                }
            }));
            $this$convertJavaFieldToFir_u24lambda_u2d22.setInitializer(this.convertJavaInitializerToFir(javaField2.getInitializerValue()));
            if (!javaField2.isStatic()) {
                $this$convertJavaFieldToFir_u24lambda_u2d22.setDispatchReceiverType(dispatchReceiver);
            }
            FirJavaField $this$convertJavaFieldToFir_u24lambda_u2d23 = firJavaField = $this$convertJavaFieldToFir_u24lambda_u2d20.build();
            boolean bl5 = false;
            if (javaField2.isStatic()) {
                ClassMembersKt.setContainingClassForStaticMemberAttr($this$convertJavaFieldToFir_u24lambda_u2d23, new ConeClassLikeLookupTagImpl(classId));
            }
            firDeclaration = firJavaField;
        }
        return firDeclaration;
    }

    private final FirExpression convertJavaInitializerToFir(Object value2) {
        Object object = value2;
        return object == null ? null : JavaUtilsKt.createConstantIfAny(object, this.getSession());
    }

    /*
     * Unable to fully structure code
     */
    private final FirJavaMethod convertJavaMethodToFir(JavaMethod javaMethod, ClassId classId, JavaTypeParameterStack javaTypeParameterStack, ConeClassLikeType dispatchReceiver) {
        methodName = javaMethod.getName();
        var7_6 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)var7_6, (String)"classId.packageFqName");
        methodId = new CallableId(var7_6, classId.getRelativeClassName(), methodName, null, 8, null);
        methodSymbol = new FirNamedFunctionSymbol(methodId);
        returnType = javaMethod.getReturnType();
        $i$f$buildJavaMethod = false;
        $this$convertJavaMethodToFir_u24lambda_u2d25 = var10_11 = new FirJavaMethodBuilder();
        $i$a$-buildJavaMethod-JavaSymbolProvider$convertJavaMethodToFir$1 = false;
        $this$convertJavaMethodToFir_u24lambda_u2d25.setModuleData(this.getBaseModuleData());
        v0 = var13_15 = javaMethod instanceof JavaElementImpl != false ? (JavaElementImpl)javaMethod : null;
        if (var13_15 == null) {
            v1 = null;
        } else {
            var14_16 = var13_15.getPsi();
            if (var14_16 == null) {
                v1 = null;
            } else {
                $this$toFirPsiSourceElement_u24default$iv = var14_16;
                kind$iv = FirRealSourceElementKind.INSTANCE;
                $i$f$toFirPsiSourceElement = false;
                var18_25 = kind$iv;
                if (var18_25 instanceof FirRealSourceElementKind) {
                    v1 = new FirRealPsiSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv);
                } else if (var18_25 instanceof FirFakeSourceElementKind) {
                    v1 = new FirFakeSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv, (FirFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        $this$convertJavaMethodToFir_u24lambda_u2d25.setSource(v1);
        $this$convertJavaMethodToFir_u24lambda_u2d25.setSymbol(methodSymbol);
        $this$convertJavaMethodToFir_u24lambda_u2d25.setName(methodName);
        $this$convertJavaMethodToFir_u24lambda_u2d25.setReturnTypeRef(JavaUtilsKt.toFirJavaTypeRef(returnType, this.getSession(), javaTypeParameterStack));
        $this$convertJavaMethodToFir_u24lambda_u2d25.setStatic(javaMethod.isStatic());
        var13_15 = $this$convertJavaMethodToFir_u24lambda_u2d25;
        CollectionsKt.addAll((Collection)var13_15.getTypeParameters(), (Iterable)this.convertTypeParameters(javaMethod.getTypeParameters(), javaTypeParameterStack));
        var13_15 = javaMethod.getValueParameters().iterator();
        var14_17 = 0;
        while (var13_15.hasNext()) {
            index = var14_17++;
            valueParameter = var13_15.next();
            var17_24 = $this$convertJavaMethodToFir_u24lambda_u2d25;
            ((Collection)var17_24.getValueParameters()).add(JavaUtilsKt.toFirValueParameter(valueParameter, this.getSession(), $this$convertJavaMethodToFir_u24lambda_u2d25.getModuleData(), index, javaTypeParameterStack));
        }
        $this$convertJavaMethodToFir_u24lambda_u2d25.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotationCall>>)((Function0)new Function0<List<? extends FirAnnotationCall>>(javaMethod, this, javaTypeParameterStack){
            final /* synthetic */ JavaMethod $javaMethod;
            final /* synthetic */ JavaSymbolProvider this$0;
            final /* synthetic */ JavaTypeParameterStack $javaTypeParameterStack;
            {
                this.$javaMethod = $javaMethod;
                this.this$0 = $receiver;
                this.$javaTypeParameterStack = $javaTypeParameterStack;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<FirAnnotationCall> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$javaMethod.getAnnotations();
                JavaSymbolProvider javaSymbolProvider = this.this$0;
                JavaTypeParameterStack javaTypeParameterStack = this.$javaTypeParameterStack;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JavaAnnotation javaAnnotation = (JavaAnnotation)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    FirAnnotationCall firAnnotationCall = JavaUtilsKt.toFirAnnotationCall((JavaAnnotation)it, javaSymbolProvider.getSession(), javaTypeParameterStack);
                    collection.add(firAnnotationCall);
                }
                return (List)destination$iv$iv;
            }
        }));
        var14_18 = var13_15 = new FirResolvedDeclarationStatusImpl(javaMethod.getVisibility(), JavaUtilsKt.getModality(javaMethod), EffectiveVisibilityUtilsKt.toEffectiveVisibility$default(javaMethod.getVisibility(), dispatchReceiver.getLookupTag(), false, false, 6, null));
        var19_26 = $this$convertJavaMethodToFir_u24lambda_u2d25;
        $i$a$-apply-JavaSymbolProvider$convertJavaMethodToFir$1$2 = false;
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setStatic(javaMethod.isStatic());
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setExpect(false);
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setActual(false);
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setOverride(false);
        if (FirJavaMethodKt.getALL_JAVA_OPERATION_NAMES().contains($this$convertJavaMethodToFir_u24lambda_u2d25.getName())) ** GOTO lbl-1000
        var16_22 = $this$convertJavaMethodToFir_u24lambda_u2d25.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)var16_22, (String)"name.asString()");
        if (OperatorNameConventions.COMPONENT_REGEX.matches((CharSequence)var16_22)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setOperator(v2);
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setInfix(false);
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setInline(false);
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setTailRec(false);
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setExternal(false);
        $this$convertJavaMethodToFir_u24lambda_u2d25_u24lambda_u2d24.setSuspend(false);
        var20_27 = Unit.INSTANCE;
        var19_26.setStatus((FirDeclarationStatus)var13_15);
        if (!javaMethod.isStatic()) {
            $this$convertJavaMethodToFir_u24lambda_u2d25.setDispatchReceiverType(dispatchReceiver);
        }
        $this$convertJavaMethodToFir_u24lambda_u2d26 = var9_10 = var10_11.build();
        $i$a$-apply-JavaSymbolProvider$convertJavaMethodToFir$2 = false;
        if (javaMethod.isStatic()) {
            ClassMembersKt.setContainingClassForStaticMemberAttr($this$convertJavaMethodToFir_u24lambda_u2d26, new ConeClassLikeLookupTagImpl(classId));
        }
        return var9_10;
    }

    /*
     * WARNING - void declaration
     */
    private final FirJavaValueParameter convertJavaAnnotationMethodToValueParameter(JavaMethod javaMethod, FirJavaMethod firJavaMethod) {
        FirPsiSourceElement firPsiSourceElement;
        JavaElementImpl javaElementImpl;
        FirJavaValueParameterBuilder firJavaValueParameterBuilder;
        boolean $i$f$buildJavaValueParameter = false;
        FirJavaValueParameterBuilder $this$convertJavaAnnotationMethodToValueParameter_u24lambda_u2d27 = firJavaValueParameterBuilder = new FirJavaValueParameterBuilder();
        boolean bl = false;
        JavaElementImpl javaElementImpl2 = javaElementImpl = javaMethod instanceof JavaElementImpl ? (JavaElementImpl)((Object)javaMethod) : null;
        if (javaElementImpl == null) {
            firPsiSourceElement = null;
        } else {
            Object Psi = javaElementImpl.getPsi();
            if (Psi == null) {
                firPsiSourceElement = null;
            } else {
                void $this$toFirPsiSourceElement$iv;
                Object Psi2 = Psi;
                FirSourceElementKind kind$iv = FirFakeSourceElementKind.ImplicitJavaAnnotationConstructor.INSTANCE;
                boolean $i$f$toFirPsiSourceElement = false;
                FirSourceElementKind firSourceElementKind = kind$iv;
                if (firSourceElementKind instanceof FirRealSourceElementKind) {
                    firPsiSourceElement = new FirRealPsiSourceElement((PsiElement)$this$toFirPsiSourceElement$iv);
                } else if (firSourceElementKind instanceof FirFakeSourceElementKind) {
                    firPsiSourceElement = new FirFakeSourceElement((PsiElement)$this$toFirPsiSourceElement$iv, (FirFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        $this$convertJavaAnnotationMethodToValueParameter_u24lambda_u2d27.setSource(firPsiSourceElement);
        $this$convertJavaAnnotationMethodToValueParameter_u24lambda_u2d27.setModuleData(this.getBaseModuleData());
        $this$convertJavaAnnotationMethodToValueParameter_u24lambda_u2d27.setReturnTypeRef(firJavaMethod.getReturnTypeRef());
        $this$convertJavaAnnotationMethodToValueParameter_u24lambda_u2d27.setName(javaMethod.getName());
        $this$convertJavaAnnotationMethodToValueParameter_u24lambda_u2d27.setVararg(javaMethod.getReturnType() instanceof JavaArrayType && Intrinsics.areEqual((Object)javaMethod.getName(), (Object)VALUE_METHOD_NAME));
        $this$convertJavaAnnotationMethodToValueParameter_u24lambda_u2d27.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotationCall>>)((Function0)convertJavaAnnotationMethodToValueParameter.1.1.INSTANCE));
        return firJavaValueParameterBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirJavaConstructor convertJavaConstructorToFir(JavaConstructor javaConstructor, CallableId constructorId, JavaClass javaClass, FirJavaClassBuilder ownerClassBuilder, List<? extends FirTypeParameter> classTypeParameters, JavaTypeParameterStack javaTypeParameterStack) {
        FirJavaConstructor firJavaConstructor;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d29;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        void $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d28;
        Object kind$iv;
        Object $this$toFirPsiSourceElement_u24default$iv;
        FirPsiSourceElement firPsiSourceElement;
        JavaElementImpl javaElementImpl;
        FirJavaConstructorBuilder firJavaConstructorBuilder;
        FirConstructorSymbol constructorSymbol = new FirConstructorSymbol(constructorId);
        boolean $i$f$buildJavaConstructor = false;
        FirJavaConstructorBuilder $this$convertJavaConstructorToFir_u24lambda_u2d32 = firJavaConstructorBuilder = new FirJavaConstructorBuilder();
        boolean bl = false;
        JavaElementImpl javaElementImpl2 = javaElementImpl = javaConstructor instanceof JavaElementImpl ? (JavaElementImpl)((Object)javaConstructor) : null;
        if (javaElementImpl == null) {
            firPsiSourceElement = null;
        } else {
            Object Psi = javaElementImpl.getPsi();
            if (Psi == null) {
                firPsiSourceElement = null;
            } else {
                $this$toFirPsiSourceElement_u24default$iv = Psi;
                kind$iv = FirRealSourceElementKind.INSTANCE;
                boolean $i$f$toFirPsiSourceElement = false;
                Object object = kind$iv;
                if (object instanceof FirRealSourceElementKind) {
                    firPsiSourceElement = new FirRealPsiSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv);
                } else if (object instanceof FirFakeSourceElementKind) {
                    firPsiSourceElement = new FirFakeSourceElement((PsiElement)$this$toFirPsiSourceElement_u24default$iv, (FirFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        $this$convertJavaConstructorToFir_u24lambda_u2d32.setSource(firPsiSourceElement);
        $this$convertJavaConstructorToFir_u24lambda_u2d32.setModuleData(this.getBaseModuleData());
        $this$convertJavaConstructorToFir_u24lambda_u2d32.setSymbol(constructorSymbol);
        $this$convertJavaConstructorToFir_u24lambda_u2d32.setInner(javaClass.getOuterClass() != null && !javaClass.isStatic());
        boolean isThisInner = $this$convertJavaConstructorToFir_u24lambda_u2d32.isInner();
        $this$toFirPsiSourceElement_u24default$iv = javaConstructor;
        Visibility visibility2 = $this$toFirPsiSourceElement_u24default$iv == null ? ownerClassBuilder.getVisibility() : $this$toFirPsiSourceElement_u24default$iv.getVisibility();
        kind$iv = $this$toFirPsiSourceElement_u24default$iv = new FirResolvedDeclarationStatusImpl(visibility2, Modality.FINAL, EffectiveVisibilityUtilsKt.toEffectiveVisibility$default(visibility2, ownerClassBuilder.getSymbol(), false, false, 6, null));
        Object object = $this$convertJavaConstructorToFir_u24lambda_u2d32;
        boolean $i$a$-apply-JavaSymbolProvider$convertJavaConstructorToFir$1$22 = false;
        $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d28.setExpect(false);
        $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d28.setActual(false);
        $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d28.setOverride(false);
        $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d28.setInner(isThisInner);
        Object object2 = Unit.INSTANCE;
        ((FirConstructorBuilder)object).setStatus((FirDeclarationStatus)$this$toFirPsiSourceElement_u24default$iv);
        $this$convertJavaConstructorToFir_u24lambda_u2d32.setVisibility(visibility2);
        $this$convertJavaConstructorToFir_u24lambda_u2d32.setPrimary(javaConstructor == null);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $i$a$-apply-JavaSymbolProvider$convertJavaConstructorToFir$1$22 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        object = $this$convertJavaConstructorToFir_u24lambda_u2d32;
        boolean bl2 = false;
        ((FirResolvedTypeRefBuilder)((Object)$this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d29)).setType(this.buildSelfTypeRef(ownerClassBuilder));
        object2 = Unit.INSTANCE;
        ((FirConstructorBuilder)object).setReturnTypeRef(firResolvedTypeRefBuilder.build());
        Object object3 = $this$convertJavaConstructorToFir_u24lambda_u2d32;
        $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d29 = classTypeParameters;
        object = ((FirConstructorBuilder)object3).getTypeParameters();
        boolean $i$f$map = false;
        FirJavaConstructorBuilder firJavaConstructorBuilder2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirConstructedClassTypeParameterRefBuilder firConstructedClassTypeParameterRefBuilder;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl3 = false;
            boolean $i$f$buildConstructedClassTypeParameterRef = false;
            FirConstructedClassTypeParameterRefBuilder $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30 = firConstructedClassTypeParameterRefBuilder = new FirConstructedClassTypeParameterRefBuilder();
            boolean bl4 = false;
            $this$convertJavaConstructorToFir_u24lambda_u2d32_u24lambda_u2d31_u24lambda_u2d30.setSymbol(it.getSymbol());
            FirTypeParameterRef firTypeParameterRef = firConstructedClassTypeParameterRefBuilder.build();
            object2.add(firTypeParameterRef);
        }
        object2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)object, (Iterable)((Iterable)object2));
        if (javaConstructor != null) {
            object3 = $this$convertJavaConstructorToFir_u24lambda_u2d32;
            CollectionsKt.addAll((Collection)((FirConstructorBuilder)object3).getTypeParameters(), (Iterable)this.convertTypeParameters(javaConstructor.getTypeParameters(), javaTypeParameterStack));
            $this$convertJavaConstructorToFir_u24lambda_u2d32.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotationCall>>)((Function0)new Function0<List<? extends FirAnnotationCall>>(javaConstructor, this, javaTypeParameterStack){
                final /* synthetic */ JavaConstructor $javaConstructor;
                final /* synthetic */ JavaSymbolProvider this$0;
                final /* synthetic */ JavaTypeParameterStack $javaTypeParameterStack;
                {
                    this.$javaConstructor = $javaConstructor;
                    this.this$0 = $receiver;
                    this.$javaTypeParameterStack = $javaTypeParameterStack;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<FirAnnotationCall> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$javaConstructor.getAnnotations();
                    JavaSymbolProvider javaSymbolProvider = this.this$0;
                    JavaTypeParameterStack javaTypeParameterStack = this.$javaTypeParameterStack;
                    boolean $i$f$map = false;
                    void var5_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JavaAnnotation javaAnnotation = (JavaAnnotation)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        FirAnnotationCall firAnnotationCall = JavaUtilsKt.toFirAnnotationCall((JavaAnnotation)it, javaSymbolProvider.getSession(), javaTypeParameterStack);
                        collection.add(firAnnotationCall);
                    }
                    return (List)destination$iv$iv;
                }
            }));
            object3 = javaConstructor.getValueParameters().iterator();
            int n = 0;
            while (object3.hasNext()) {
                int index2 = n++;
                JavaValueParameter valueParameter2 = (JavaValueParameter)object3.next();
                firJavaConstructorBuilder2 = $this$convertJavaConstructorToFir_u24lambda_u2d32;
                ((Collection)firJavaConstructorBuilder2.getValueParameters()).add(JavaUtilsKt.toFirValueParameter(valueParameter2, this.getSession(), $this$convertJavaConstructorToFir_u24lambda_u2d32.getModuleData(), index2, javaTypeParameterStack));
            }
        } else {
            $this$convertJavaConstructorToFir_u24lambda_u2d32.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotationCall>>)((Function0)convertJavaConstructorToFir.1.5.INSTANCE));
        }
        FirJavaConstructor $this$convertJavaConstructorToFir_u24lambda_u2d33 = firJavaConstructor = firJavaConstructorBuilder.build();
        boolean bl5 = false;
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$convertJavaConstructorToFir_u24lambda_u2d33, ownerClassBuilder.getSymbol().toLookupTag());
        return firJavaConstructor;
    }

    /*
     * WARNING - void declaration
     */
    private final FirJavaConstructor buildConstructorForAnnotationClass(FirFakeSourceElement classSource, CallableId constructorId, FirJavaClassBuilder ownerClassBuilder, ValueParametersForAnnotationConstructor valueParametersForAnnotationConstructor) {
        FirJavaConstructor firJavaConstructor;
        Object object;
        Pair<JavaMethod, FirJavaValueParameter> $this$buildConstructorForAnnotationClass_u24lambda_u2d36_u24lambda_u2d34;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        FirJavaConstructorBuilder firJavaConstructorBuilder;
        boolean $i$f$buildJavaConstructor = false;
        FirJavaConstructorBuilder $this$buildConstructorForAnnotationClass_u24lambda_u2d36 = firJavaConstructorBuilder = new FirJavaConstructorBuilder();
        boolean bl = false;
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setSource(classSource);
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setModuleData(this.getBaseModuleData());
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setSymbol(new FirConstructorSymbol(constructorId));
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setStatus(new FirResolvedDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL, EffectiveVisibility.Public.INSTANCE));
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        FirJavaConstructorBuilder firJavaConstructorBuilder2 = $this$buildConstructorForAnnotationClass_u24lambda_u2d36;
        boolean bl2 = false;
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36_u24lambda_u2d34.setType(this.buildSelfTypeRef(ownerClassBuilder));
        Unit unit2 = Unit.INSTANCE;
        firJavaConstructorBuilder2.setReturnTypeRef(firResolvedTypeRefBuilder.build());
        ValueParametersForAnnotationConstructor this_$iv = valueParametersForAnnotationConstructor;
        boolean $i$f$forEach = false;
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36_u24lambda_u2d34 = this_$iv.getValueParameterForValue();
        if ($this$buildConstructorForAnnotationClass_u24lambda_u2d36_u24lambda_u2d34 != null) {
            void firValueParameter;
            FirJavaValueParameter firJavaValueParameter$iv;
            Pair<JavaMethod, FirJavaValueParameter> $dstr$javaMethod$firJavaValueParameter$iv = bl2 = $this$buildConstructorForAnnotationClass_u24lambda_u2d36_u24lambda_u2d34;
            boolean bl3 = false;
            JavaMethod javaMethod$iv = (JavaMethod)$dstr$javaMethod$firJavaValueParameter$iv.component1();
            FirJavaValueParameter firJavaValueParameter = firJavaValueParameter$iv = (FirJavaValueParameter)$dstr$javaMethod$firJavaValueParameter$iv.component2();
            JavaMethod $noName_0 = javaMethod$iv;
            boolean bl4 = false;
            FirJavaConstructorBuilder firJavaConstructorBuilder3 = $this$buildConstructorForAnnotationClass_u24lambda_u2d36;
            object = firJavaConstructorBuilder3.getValueParameters();
            object.add(firValueParameter);
        }
        Map<JavaMethod, FirJavaValueParameter> $this$forEach$iv$iv = this_$iv.getValueParameters();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<JavaMethod, FirJavaValueParameter>> iterator2 = $this$forEach$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void firValueParameter;
            FirJavaValueParameter firJavaValueParameter$iv;
            Map.Entry<JavaMethod, FirJavaValueParameter> element$iv$iv;
            Map.Entry<JavaMethod, FirJavaValueParameter> $dstr$javaMethod$firJavaValueParameter$iv = element$iv$iv = iterator2.next();
            boolean bl5 = false;
            JavaMethod javaMethod$iv = $dstr$javaMethod$firJavaValueParameter$iv.getKey();
            FirJavaValueParameter bl4 = firJavaValueParameter$iv = $dstr$javaMethod$firJavaValueParameter$iv.getValue();
            JavaMethod $noName_0 = javaMethod$iv;
            boolean $i$a$-forEach-JavaSymbolProvider$buildConstructorForAnnotationClass$1$3 = false;
            object = $this$buildConstructorForAnnotationClass_u24lambda_u2d36;
            Collection collection = ((FirConstructorBuilder)object).getValueParameters();
            collection.add(firValueParameter);
        }
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setVisibility(Visibilities.Public.INSTANCE);
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setInner(false);
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setPrimary(true);
        $this$buildConstructorForAnnotationClass_u24lambda_u2d36.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotationCall>>)((Function0)buildConstructorForAnnotationClass.1.3.INSTANCE));
        FirJavaConstructor $this$buildConstructorForAnnotationClass_u24lambda_u2d37 = firJavaConstructor = firJavaConstructorBuilder.build();
        boolean bl6 = false;
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$buildConstructorForAnnotationClass_u24lambda_u2d37, ownerClassBuilder.getSymbol().toLookupTag());
        return firJavaConstructor;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType buildSelfTypeRef(FirJavaClassBuilder $this$buildSelfTypeRef) {
        Collection<ConeTypeParameterTypeImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$buildSelfTypeRef.getTypeParameters();
        FirClassifierSymbol firClassifierSymbol = $this$buildSelfTypeRef.getSymbol();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ConeTypeParameterTypeImpl coneTypeParameterTypeImpl = new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null);
            collection.add(coneTypeParameterTypeImpl);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return TreeResolveUtilsKt.constructType$default(firClassifierSymbol, coneTypeProjectionArray, false, null, 4, null);
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirCache $this$getValue$iv = this.packageCache;
        boolean $i$f$getValue = false;
        return (FqName)$this$getValue$iv.getValue(fqName2, null);
    }

    private final FqName findPackage(FqName fqName2) {
        FqName fqName3;
        try {
            KotlinJavaPsiFacade facade = KotlinJavaPsiFacade.getInstance(this.project);
            PsiPackage psiPackage = facade.findPackage(fqName2.asString(), this.searchScope);
            if (psiPackage == null) {
                return null;
            }
            PsiPackage javaPackage = psiPackage;
            fqName3 = new FqName(javaPackage.getQualifiedName());
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        return fqName3;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTopLevelClassOf(ClassId classId) {
        void $this$getValue$iv;
        FirCache firCache = this.knownClassNamesInPackage;
        FqName key$iv = classId.getPackageFqName();
        boolean $i$f$getValue = false;
        Object object = (Set)$this$getValue$iv.getValue(key$iv, null);
        if (object == null) {
            return true;
        }
        Set knownNames = object;
        object = classId.getRelativeClassName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classId.relativeClassName");
        return knownNames.contains(JavaSymbolProviderKt.topLevelName((FqName)object));
    }

    private final Set<String> getKnownClassNames(FqName packageFqName) {
        return this.getFacade().knownClassNamesInPackage(packageFqName, this.searchScope);
    }

    public static final /* synthetic */ FqName access$findPackage(JavaSymbolProvider $this, FqName fqName2) {
        return $this.findPackage(fqName2);
    }

    public static final /* synthetic */ Set access$getKnownClassNames(JavaSymbolProvider $this, FqName packageFqName) {
        return $this.getKnownClassNames(packageFqName);
    }

    public static final /* synthetic */ Pair access$findAndConvertJavaClass(JavaSymbolProvider $this, ClassId classId, KotlinClassFinder.Result.ClassFileContent content) {
        return $this.findAndConvertJavaClass(classId, content);
    }

    public static final /* synthetic */ FirJavaClass access$convertJavaClassToFir(JavaSymbolProvider $this, FirRegularClassSymbol classSymbol, JavaClass javaClass) {
        return $this.convertJavaClassToFir(classSymbol, javaClass);
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"value\")");
        VALUE_METHOD_NAME = name;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider$Companion;", "", "()V", "VALUE_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getVALUE_METHOD_NAME$java", "()Lorg/jetbrains/kotlin/name/Name;", "java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Name getVALUE_METHOD_NAME$java() {
            return VALUE_METHOD_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0012H\u0086\b\u00f8\u0001\u0000R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider$ValueParametersForAnnotationConstructor;", "", "()V", "valueParameterForValue", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaValueParameter;", "getValueParameterForValue", "()Lkotlin/Pair;", "setValueParameterForValue", "(Lkotlin/Pair;)V", "valueParameters", "", "getValueParameters", "()Ljava/util/Map;", "forEach", "", "block", "Lkotlin/Function2;", "java"})
    private static final class ValueParametersForAnnotationConstructor {
        @NotNull
        private final Map<JavaMethod, FirJavaValueParameter> valueParameters = new LinkedHashMap();
        @Nullable
        private Pair<? extends JavaMethod, FirJavaValueParameter> valueParameterForValue;

        @NotNull
        public final Map<JavaMethod, FirJavaValueParameter> getValueParameters() {
            return this.valueParameters;
        }

        @Nullable
        public final Pair<JavaMethod, FirJavaValueParameter> getValueParameterForValue() {
            return this.valueParameterForValue;
        }

        public final void setValueParameterForValue(@Nullable Pair<? extends JavaMethod, FirJavaValueParameter> pair) {
            this.valueParameterForValue = pair;
        }

        public final void forEach(@NotNull Function2<? super JavaMethod, ? super FirJavaValueParameter, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$forEach = false;
            Pair<JavaMethod, FirJavaValueParameter> pair = this.getValueParameterForValue();
            if (pair != null) {
                Pair<JavaMethod, FirJavaValueParameter> pair2;
                Pair<JavaMethod, FirJavaValueParameter> $dstr$javaMethod$firJavaValueParameter = pair2 = pair;
                boolean bl = false;
                JavaMethod javaMethod = (JavaMethod)$dstr$javaMethod$firJavaValueParameter.component1();
                FirJavaValueParameter firJavaValueParameter = (FirJavaValueParameter)$dstr$javaMethod$firJavaValueParameter.component2();
                block.invoke((Object)javaMethod, (Object)firJavaValueParameter);
            }
            Map<JavaMethod, FirJavaValueParameter> $this$forEach$iv = this.getValueParameters();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<JavaMethod, FirJavaValueParameter>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<JavaMethod, FirJavaValueParameter> element$iv;
                Map.Entry<JavaMethod, FirJavaValueParameter> $dstr$javaMethod$firJavaValueParameter = element$iv = iterator2.next();
                boolean bl = false;
                JavaMethod javaMethod = $dstr$javaMethod$firJavaValueParameter.getKey();
                FirJavaValueParameter firJavaValueParameter = $dstr$javaMethod$firJavaValueParameter.getValue();
                block.invoke((Object)javaMethod, (Object)firJavaValueParameter);
            }
        }
    }
}

