/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/AdaptiveClassifierNamePolicy;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "ambiguousNames", "", "Lorg/jetbrains/kotlin/name/Name;", "(Ljava/util/List;)V", "renderedParameters", "", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "hasUniqueName", "", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderClassifier", "", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderAmbiguousTypeParameter", "typeParameter", "index", "", "firstOccurence", "frontend"})
final class AdaptiveClassifierNamePolicy
implements ClassifierNamePolicy {
    @NotNull
    private final List<Name> ambiguousNames;
    @NotNull
    private final Map<Name, LinkedHashSet<TypeParameterDescriptor>> renderedParameters;

    public AdaptiveClassifierNamePolicy(@NotNull List<Name> ambiguousNames) {
        Intrinsics.checkNotNullParameter(ambiguousNames, (String)"ambiguousNames");
        this.ambiguousNames = ambiguousNames;
        this.renderedParameters = new LinkedHashMap();
    }

    @Override
    @NotNull
    public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)classifier2, (String)"classifier");
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        if (this.hasUniqueName(classifier2)) {
            string2 = ClassifierNamePolicy.SHORT.INSTANCE.renderClassifier(classifier2, renderer2);
        } else if (classifier2 instanceof ClassDescriptor || classifier2 instanceof TypeAliasDescriptor) {
            string2 = ClassifierNamePolicy.FULLY_QUALIFIED.INSTANCE.renderClassifier(classifier2, renderer2);
        } else if (classifier2 instanceof TypeParameterDescriptor) {
            LinkedHashSet<TypeParameterDescriptor> linkedHashSet;
            Name name = ((TypeParameterDescriptor)classifier2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classifier.name");
            Name name2 = name;
            Map<Name, LinkedHashSet<TypeParameterDescriptor>> $this$getOrPut$iv = this.renderedParameters;
            boolean $i$f$getOrPut = false;
            LinkedHashSet<TypeParameterDescriptor> value$iv = $this$getOrPut$iv.get(name2);
            if (value$iv == null) {
                boolean bl = false;
                LinkedHashSet answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(name2, answer$iv);
                linkedHashSet = answer$iv;
            } else {
                linkedHashSet = value$iv;
            }
            LinkedHashSet<TypeParameterDescriptor> typeParametersWithSameName = linkedHashSet;
            boolean isFirstOccurence = typeParametersWithSameName.add((TypeParameterDescriptor)classifier2);
            int index2 = CollectionsKt.indexOf((Iterable)typeParametersWithSameName, (Object)classifier2);
            string2 = this.renderAmbiguousTypeParameter(renderer2, (TypeParameterDescriptor)classifier2, index2 + 1, isFirstOccurence);
        } else {
            throw new IllegalStateException(("Unexpected classifier: " + classifier2.getClass()).toString());
        }
        return string2;
    }

    private final boolean hasUniqueName(ClassifierDescriptor classifier2) {
        return !this.ambiguousNames.contains(classifier2.getName());
    }

    private final String renderAmbiguousTypeParameter(DescriptorRenderer $this$renderAmbiguousTypeParameter, TypeParameterDescriptor typeParameter, int index2, boolean firstOccurence) {
        StringBuilder stringBuilder2;
        StringBuilder $this$renderAmbiguousTypeParameter_u24lambda_u241 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$renderAmbiguousTypeParameter_u24lambda_u241.append(typeParameter.getName());
        $this$renderAmbiguousTypeParameter_u24lambda_u241.append("" + '#' + index2);
        if (firstOccurence) {
            StringBuilder stringBuilder3 = new StringBuilder().append(" (type parameter of ");
            DeclarationDescriptor declarationDescriptor = typeParameter.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"typeParameter.containingDeclaration");
            $this$renderAmbiguousTypeParameter_u24lambda_u241.append($this$renderAmbiguousTypeParameter.renderMessage(stringBuilder3.append($this$renderAmbiguousTypeParameter.renderFqName(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor))).append(')').toString()));
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }
}

