/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorWithRelation;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0018\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*JO\u0010+\u001a\u00020&\"\b\b\u0000\u0010,*\u00020-2\u001e\u0010.\u001a\u001a\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002000/2\u0006\u00102\u001a\u0002H,2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u000201H\u0002\u00a2\u0006\u0002\u00105JO\u00106\u001a\u00020&\"\b\b\u0000\u0010,*\u00020-2\u001e\u0010.\u001a\u001a\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000200072\u0006\u00102\u001a\u0002H,2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u000201H\u0002\u00a2\u0006\u0002\u00108R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkClassHeader", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkDeclarationWithVisibility", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "visibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiver", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkParameterBounds", "checkProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkSupertypes", "checkTypeAlias", "", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "reportExposure", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;", "element", "elementVisibility", "restrictingDescriptor", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "reportExposureForDeprecation", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryForDeprecation3;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryForDeprecation3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "frontend"})
public final class ExposedVisibilityChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @Nullable
    private final BindingTrace trace;

    public ExposedVisibilityChecker(@NotNull LanguageVersionSettings languageVersionSettings, @Nullable BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.trace = trace;
    }

    public /* synthetic */ ExposedVisibilityChecker(LanguageVersionSettings languageVersionSettings, BindingTrace bindingTrace, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bindingTrace = null;
        }
        this(languageVersionSettings, bindingTrace);
    }

    private final <E extends PsiElement> void reportExposure(DiagnosticFactory3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            return;
        }
        BindingTrace trace = bindingTrace;
        EffectiveVisibility restrictingVisibility = restrictingDescriptor.effectiveVisibility();
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.PrivateInFileEffectiveVisibility) && Intrinsics.areEqual((Object)elementVisibility, (Object)EffectiveVisibility.PrivateInFile.INSTANCE)) {
            trace.report(Errors.EXPOSED_FROM_PRIVATE_IN_FILE.on(element, elementVisibility, restrictingDescriptor, restrictingVisibility));
        } else {
            trace.report(diagnostic.on(element, elementVisibility, restrictingDescriptor, restrictingVisibility));
        }
    }

    private final <E extends PsiElement> void reportExposureForDeprecation(DiagnosticFactoryForDeprecation3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            return;
        }
        BindingTrace trace = bindingTrace;
        EffectiveVisibility restrictingVisibility = restrictingDescriptor.effectiveVisibility();
        trace.report(diagnostic.on(this.languageVersionSettings, element, elementVisibility, restrictingDescriptor, restrictingVisibility));
    }

    public final boolean checkClassHeader(@NotNull KtClassOrObject klass, @NotNull ClassDescriptor classDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        boolean result2 = this.checkSupertypes(klass, classDescriptor2);
        result2 &= this.checkParameterBounds(klass, classDescriptor2);
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return result2;
        }
        KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return result2;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        return result2 & ExposedVisibilityChecker.checkFunction$default(this, constructor2, constructorDescriptor, null, 4, null);
    }

    public final boolean checkDeclarationWithVisibility(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        return modifierListOwner instanceof KtFunction && descriptor2 instanceof FunctionDescriptor ? this.checkFunction((KtFunction)modifierListOwner, (FunctionDescriptor)descriptor2, visibility2) : (modifierListOwner instanceof KtProperty && descriptor2 instanceof PropertyDescriptor ? this.checkProperty((KtProperty)modifierListOwner, (PropertyDescriptor)descriptor2, visibility2) : true);
    }

    public final void checkTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        SimpleType expandedType2 = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return;
        }
        EffectiveVisibility typeAliasVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(typeAliasDescriptor, null, false, 3, null);
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(expandedType2, typeAliasVisibility);
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPEALIAS_EXPANDED_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"EXPOSED_TYPEALIAS_EXPANDED_TYPE");
            PsiElement psiElement = typeAlias.getNameIdentifier();
            if (psiElement == null) {
                psiElement = typeAlias;
            }
            this.reportExposure(diagnosticFactory3, psiElement, typeAliasVisibility, restricting);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkFunction(@NotNull KtFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        EffectiveVisibility functionVisibility = null;
        functionVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(functionDescriptor, visibility2, false, 2, null);
        if (functionDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"functionDescriptor.constructedClass");
            if (DescriptorUtilKt.isSealed(classDescriptor2) && KtPsiUtilKt.visibilityModifier(function2) == null) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean result2 = false;
        result2 = true;
        if (!(function2 instanceof KtConstructor)) {
            DescriptorWithRelation restricting;
            KotlinType kotlinType = functionDescriptor.getReturnType();
            DescriptorWithRelation descriptorWithRelation = restricting = kotlinType != null ? EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, functionVisibility) : null;
            if (restricting != null) {
                DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_FUNCTION_RETURN_TYPE;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"EXPOSED_FUNCTION_RETURN_TYPE");
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = function2;
                }
                this.reportExposure(diagnosticFactory3, psiElement, functionVisibility, restricting);
                result2 = false;
            }
        }
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"functionDescriptor.valueParameters");
        Iterable $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameterDescriptor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= function2.getValueParameters().size()) continue;
            KtParameter valueParameter2 = function2.getValueParameters().get(i);
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameterDescriptor.type");
            DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, functionVisibility);
            if (restricting != null) {
                DiagnosticFactory3<KtParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PARAMETER_TYPE;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"EXPOSED_PARAMETER_TYPE");
                this.reportExposure(diagnosticFactory3, (PsiElement)valueParameter2, functionVisibility, restricting);
                result2 = false;
                continue;
            }
            if (!(functionDescriptor instanceof ClassConstructorDescriptor) || !valueParameter2.hasValOrVar()) continue;
            BindingTrace bindingTrace = this.trace;
            PropertyDescriptor propertyDescriptor = bindingTrace != null ? (PropertyDescriptor)bindingTrace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor) : null;
            Substitutable<CallableDescriptor> substitutable = propertyDescriptor;
            if (substitutable == null) {
                ClassDescriptor classDescriptor3 = ((ClassConstructorDescriptor)functionDescriptor).getConstructedClass();
                substitutable = classDescriptor3;
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor3, (String)"functionDescriptor.constructedClass");
            }
            EffectiveVisibility propertyOrClassVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(substitutable, null, false, 3, null);
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"parameterDescriptor.type");
            DescriptorWithRelation restrictingByProperty = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType2, propertyOrClassVisibility);
            if (restrictingByProperty == null) continue;
            DiagnosticFactoryForDeprecation3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactoryForDeprecation3 = Errors.EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactoryForDeprecation3, (String)"EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR");
            PsiElement psiElement = valueParameter2.getNameIdentifier();
            if (psiElement == null) {
                psiElement = valueParameter2;
            }
            this.reportExposureForDeprecation(diagnosticFactoryForDeprecation3, psiElement, propertyOrClassVisibility, restrictingByProperty);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(function2.getReceiverTypeReference(), functionDescriptor);
    }

    public static /* synthetic */ boolean checkFunction$default(ExposedVisibilityChecker exposedVisibilityChecker, KtFunction ktFunction, FunctionDescriptor functionDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            DescriptorVisibility descriptorVisibility2 = functionDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"functionDescriptor.visibility");
            descriptorVisibility = descriptorVisibility2;
        }
        return exposedVisibilityChecker.checkFunction(ktFunction, functionDescriptor, descriptorVisibility);
    }

    public final boolean checkProperty(@NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        EffectiveVisibility propertyVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(propertyDescriptor, visibility2, false, 2, null);
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"propertyDescriptor.type");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, propertyVisibility);
        boolean result2 = true;
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PROPERTY_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"EXPOSED_PROPERTY_TYPE");
            PsiElement psiElement = property2.getNameIdentifier();
            if (psiElement == null) {
                psiElement = property2;
            }
            this.reportExposure(diagnosticFactory3, psiElement, propertyVisibility, restricting);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(property2.getReceiverTypeReference(), propertyDescriptor);
    }

    public static /* synthetic */ boolean checkProperty$default(ExposedVisibilityChecker exposedVisibilityChecker, KtProperty ktProperty, PropertyDescriptor propertyDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            DescriptorVisibility descriptorVisibility2 = propertyDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"propertyDescriptor.visibility");
            descriptorVisibility = descriptorVisibility2;
        }
        return exposedVisibilityChecker.checkProperty(ktProperty, propertyDescriptor, descriptorVisibility);
    }

    private final boolean checkMemberReceiver(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        if (typeReference == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(memberDescriptor, null, false, 3, null);
        KotlinType kotlinType = receiverParameterDescriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiverParameterDescriptor.type");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, memberVisibility);
        if (restricting != null) {
            DiagnosticFactory3<KtTypeReference, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_RECEIVER_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"EXPOSED_RECEIVER_TYPE");
            this.reportExposure(diagnosticFactory3, (PsiElement)typeReference, memberVisibility, restricting);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSupertypes(KtClassOrObject klass, ClassDescriptor classDescriptor2) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor2, false, 1, null);
        boolean isInterface = classDescriptor2.getKind() == ClassKind.INTERFACE;
        List<KtSuperTypeListEntry> delegationList = klass.getSuperTypeListEntries();
        boolean result2 = false;
        result2 = true;
        Collection<KotlinType> collection = classDescriptor2.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"classDescriptor.typeConstructor.supertypes");
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean superIsInterface;
            ClassDescriptor superDescriptor;
            void superType2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= delegationList.size()) {
                return result2;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType2) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)superDescriptor, (String)"TypeUtils.getClassDescri\u2026 ?: return@forEachIndexed");
            boolean bl2 = superIsInterface = superDescriptor.getKind() == ClassKind.INTERFACE;
            if (superIsInterface != isInterface) continue;
            Intrinsics.checkNotNullExpressionValue((Object)superType2, (String)"superType");
            DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)superType2, classVisibility);
            if (restricting == null) continue;
            DiagnosticFactory3<KtSuperTypeListEntry, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = isInterface ? Errors.EXPOSED_SUPER_INTERFACE : Errors.EXPOSED_SUPER_CLASS;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"if (isInterface) EXPOSED\u2026 else EXPOSED_SUPER_CLASS");
            this.reportExposure(diagnosticFactory3, (PsiElement)delegationList.get(i), classVisibility, restricting);
            result2 = false;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParameterBounds(KtClassOrObject klass, ClassDescriptor classDescriptor2) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor2, false, 1, null);
        List<KtTypeParameter> list2 = klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"klass.typeParameters");
        List<KtTypeParameter> typeParameterList = list2;
        boolean result2 = false;
        result2 = true;
        List<TypeParameterDescriptor> list3 = classDescriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"classDescriptor.declaredTypeParameters");
        Iterable $this$forEachIndexed$iv = list3;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block0: for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterDescriptor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= typeParameterList.size()) {
                return result2;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                Intrinsics.checkNotNullExpressionValue((Object)upperBound, (String)"upperBound");
                DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(upperBound, classVisibility);
                if (restricting == null) continue;
                DiagnosticFactory3<KtTypeParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPE_PARAMETER_BOUND;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"EXPOSED_TYPE_PARAMETER_BOUND");
                this.reportExposure(diagnosticFactory3, (PsiElement)typeParameterList.get(i), classVisibility, restricting);
                result2 = false;
                continue block0;
            }
        }
        return result2;
    }
}

