/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J2\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\nH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/CompositePrioritizedImportingScope;", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "primaryScope", "secondaryScope", "(Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;)V", "parent", "getParent", "()Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "computeImportedNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getContributedClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "name", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getContributedDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "", "changeNamesForAliased", "getContributedFunctions", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getContributedPackage", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "getContributedVariables", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "printStructure", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "resolution"})
public final class CompositePrioritizedImportingScope
implements ImportingScope {
    @NotNull
    private final ImportingScope primaryScope;
    @NotNull
    private final ImportingScope secondaryScope;

    public CompositePrioritizedImportingScope(@NotNull ImportingScope primaryScope, @NotNull ImportingScope secondaryScope) {
        Intrinsics.checkNotNullParameter((Object)primaryScope, (String)"primaryScope");
        Intrinsics.checkNotNullParameter((Object)secondaryScope, (String)"secondaryScope");
        this.primaryScope = primaryScope;
        this.secondaryScope = secondaryScope;
    }

    @Override
    @Nullable
    public ImportingScope getParent() {
        ImportingScope importingScope = this.primaryScope.getParent();
        if (importingScope == null) {
            importingScope = this.secondaryScope.getParent();
        }
        return importingScope;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getContributedPackage(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PackageViewDescriptor packageViewDescriptor = this.primaryScope.getContributedPackage(name);
        if (packageViewDescriptor == null) {
            packageViewDescriptor = this.secondaryScope.getContributedPackage(name);
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2, boolean changeNamesForAliased) {
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedDescriptors(kindFilter, nameFilter2, changeNamesForAliased), (Iterable)this.secondaryScope.getContributedDescriptors(kindFilter, nameFilter2, changeNamesForAliased));
    }

    @Override
    @Nullable
    public Set<Name> computeImportedNames() {
        Set set;
        block5: {
            Set secondaryNames;
            block4: {
                Set primaryNames = this.primaryScope.computeImportedNames();
                secondaryNames = this.secondaryScope.computeImportedNames();
                set = primaryNames;
                if (set == null) break block4;
                Iterable iterable = set;
                Set set2 = secondaryNames;
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                if ((set = CollectionsKt.union((Iterable)iterable, (Iterable)set2)) != null) break block5;
            }
            set = secondaryNames;
        }
        return set;
    }

    @Override
    public void printStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Object[] objectArray = new Object[]{this.primaryScope.getClass().getSimpleName()};
        p.println(objectArray);
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ClassifierDescriptor classifierDescriptor = this.primaryScope.getContributedClassifier(name, location);
        if (classifierDescriptor == null) {
            classifierDescriptor = this.secondaryScope.getContributedClassifier(name, location);
        }
        return classifierDescriptor;
    }

    @NotNull
    public Collection<VariableDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedVariables(name, location), (Iterable)this.secondaryScope.getContributedVariables(name, location));
    }

    @NotNull
    public Collection<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedFunctions(name, location), (Iterable)this.secondaryScope.getContributedFunctions(name, location));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        return ImportingScope.DefaultImpls.getContributedDescriptors(this, kindFilter, nameFilter2);
    }

    @Override
    public boolean definitelyDoesNotContainName(@NotNull Name name) {
        return ImportingScope.DefaultImpls.definitelyDoesNotContainName(this, name);
    }

    @Override
    @Nullable
    public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
        return ImportingScope.DefaultImpls.getContributedClassifierIncludeDeprecated(this, name, location);
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        ImportingScope.DefaultImpls.recordLookup(this, name, location);
    }
}

