/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.deserialization.AbstractFirDeserializedSymbolProvider;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.deserialization.PackagePartsCacheData;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.session.KlibBasedAnnotationDeserializer;
import org.jetbrains.kotlin.fir.session.KlibBasedSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.library.metadata.KlibMetadataClassDataFinder;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.resolver.KotlinResolvedLibrary;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0014J\u001c\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0014J\u0012\u0010/\u001a\u0004\u0018\u00010(2\u0006\u00100\u001a\u00020(H\u0016J\u0018\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00120\u00120\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001e\u001a\u0004\b!\u0010\"R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/fir/session/KlibBasedSymbolProvider;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleDataProvider", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "resolvedLibrary", "Lorg/jetbrains/kotlin/library/resolver/KotlinResolvedLibrary;", "defaultDeserializationOrigin", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Lorg/jetbrains/kotlin/library/resolver/KotlinResolvedLibrary;Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;)V", "annotationDeserializer", "Lorg/jetbrains/kotlin/fir/session/KlibBasedAnnotationDeserializer;", "cachedFragments", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "constDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "fragmentNameList", "", "kotlin.jvm.PlatformType", "getFragmentNameList", "()Ljava/util/Set;", "fragmentNameList$delegate", "Lkotlin/Lazy;", "moduleHeader", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "getModuleHeader", "()Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "moduleHeader$delegate", "computePackagePartsInfos", "", "Lorg/jetbrains/kotlin/fir/deserialization/PackagePartsCacheData;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "extractClassMetadata", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "parentContext", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "getPackage", "fqName", "getPackageFragment", "packageStringName", "packageMetadataPart", "isNewPlaceForBodyGeneration", "", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "entrypoint"})
public final class KlibBasedSymbolProvider
extends AbstractFirDeserializedSymbolProvider {
    @NotNull
    private final KotlinResolvedLibrary resolvedLibrary;
    @NotNull
    private final Lazy moduleHeader$delegate;
    @NotNull
    private final Lazy fragmentNameList$delegate;
    @NotNull
    private final KlibBasedAnnotationDeserializer annotationDeserializer;
    @NotNull
    private final FirConstDeserializer constDeserializer;
    @NotNull
    private final CompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final Map<Pair<String, String>, ProtoBuf.PackageFragment> cachedFragments;

    public KlibBasedSymbolProvider(@NotNull FirSession session2, @NotNull ModuleDataProvider moduleDataProvider, @NotNull FirKotlinScopeProvider kotlinScopeProvider, @NotNull KotlinResolvedLibrary resolvedLibrary, @NotNull FirDeclarationOrigin defaultDeserializationOrigin) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)moduleDataProvider, (String)"moduleDataProvider");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider, (String)"kotlinScopeProvider");
        Intrinsics.checkNotNullParameter((Object)resolvedLibrary, (String)"resolvedLibrary");
        Intrinsics.checkNotNullParameter((Object)defaultDeserializationOrigin, (String)"defaultDeserializationOrigin");
        super(session2, moduleDataProvider, kotlinScopeProvider, defaultDeserializationOrigin);
        this.resolvedLibrary = resolvedLibrary;
        this.moduleHeader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KlibMetadataProtoBuf.Header>(this){
            final /* synthetic */ KlibBasedSymbolProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KlibMetadataProtoBuf.Header invoke() {
                return KlibBasedSymbolProvider.access$getResolvedLibrary$p(this.this$0).loadModuleHeader(KlibBasedSymbolProvider.access$getResolvedLibrary$p(this.this$0).getLibrary());
            }
        }));
        this.fragmentNameList$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ KlibBasedSymbolProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                ProtocolStringList protocolStringList = KlibBasedSymbolProvider.access$getModuleHeader(this.this$0).getPackageFragmentNameList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"moduleHeader.packageFragmentNameList");
                return CollectionsKt.toSet((Iterable)protocolStringList);
            }
        }));
        this.annotationDeserializer = new KlibBasedAnnotationDeserializer(session2);
        this.constDeserializer = new FirConstDeserializer(session2);
        this.deserializationConfiguration = new CompilerDeserializationConfiguration(FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2));
        this.cachedFragments = new LinkedHashMap();
    }

    public /* synthetic */ KlibBasedSymbolProvider(FirSession firSession, ModuleDataProvider moduleDataProvider, FirKotlinScopeProvider firKotlinScopeProvider, KotlinResolvedLibrary kotlinResolvedLibrary, FirDeclarationOrigin firDeclarationOrigin, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            firDeclarationOrigin = FirDeclarationOrigin.Library.INSTANCE;
        }
        this(firSession, moduleDataProvider, firKotlinScopeProvider, kotlinResolvedLibrary, firDeclarationOrigin);
    }

    private final KlibMetadataProtoBuf.Header getModuleHeader() {
        Lazy lazy = this.moduleHeader$delegate;
        return (KlibMetadataProtoBuf.Header)lazy.getValue();
    }

    private final Set<String> getFragmentNameList() {
        Lazy lazy = this.fragmentNameList$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final ProtoBuf.PackageFragment getPackageFragment(String packageStringName, String packageMetadataPart) {
        Object object;
        void $this$getOrPut$iv;
        Map<Pair<String, String>, ProtoBuf.PackageFragment> map = this.cachedFragments;
        Pair key$iv = TuplesKt.to((Object)packageStringName, (Object)packageMetadataPart);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ProtoBuf.PackageFragment answer$iv = this.resolvedLibrary.loadPackageFragment(this.resolvedLibrary.getLibrary(), packageStringName, packageMetadataPart);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ProtoBuf.PackageFragment)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<PackagePartsCacheData> computePackagePartsInfos(@NotNull FqName packageFqName) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        String string2 = packageFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageFqName.asString()");
        String packageStringName = string2;
        if (!this.getFragmentNameList().contains(packageStringName)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = this.resolvedLibrary.getLibrary().packageMetadataParts(packageStringName);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PackagePartsCacheData packagePartsCacheData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            ProtoBuf.PackageFragment fragment = this.getPackageFragment(packageStringName, it);
            Path libraryPath = Paths.get(this.resolvedLibrary.getLibrary().getLibraryName(), new String[0]);
            if (this.getModuleDataProvider().getModuleData(libraryPath) == null) {
                packagePartsCacheData = null;
            } else {
                FirModuleData moduleData;
                ProtoBuf.Package packageProto = fragment.getPackage();
                ProtoBuf.StringTable stringTable2 = fragment.getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)stringTable2, (String)"fragment.strings");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = fragment.getQualifiedNames();
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"fragment.qualifiedNames");
                NameResolverImpl nameResolver2 = new NameResolverImpl(stringTable2, qualifiedNameTable);
                Intrinsics.checkNotNullExpressionValue((Object)packageProto, (String)"packageProto");
                packagePartsCacheData = new PackagePartsCacheData(packageProto, FirDeserializationContext.Companion.createForPackage(packageFqName, packageProto, nameResolver2, moduleData, this.annotationDeserializer, this.constDeserializer, null));
            }
            if (packagePartsCacheData == null) continue;
            PackagePartsCacheData it$iv$iv = packagePartsCacheData;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    protected AbstractFirDeserializedSymbolProvider.ClassMetadataFindResult extractClassMetadata(@NotNull ClassId classId, @Nullable FirDeserializationContext parentContext) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        String string2 = classId.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.packageFqName.asString()");
        String packageStringName = string2;
        if (!this.getFragmentNameList().contains(packageStringName)) {
            return null;
        }
        Iterable $this$forEach$iv = this.resolvedLibrary.getLibrary().packageMetadataParts(packageStringName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Path libraryPath = Paths.get(this.resolvedLibrary.getLibrary().getLibraryName(), new String[0]);
            ProtoBuf.PackageFragment fragment = this.getPackageFragment(packageStringName, it);
            ProtoBuf.StringTable stringTable2 = fragment.getStrings();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable2, (String)"fragment.strings");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = fragment.getQualifiedNames();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"fragment.qualifiedNames");
            NameResolverImpl nameResolver2 = new NameResolverImpl(stringTable2, qualifiedNameTable);
            KlibMetadataClassDataFinder finder = new KlibMetadataClassDataFinder(fragment, nameResolver2);
            Object object = finder.findClassData(classId);
            if (object == null || (object = ((ClassData)object).getClassProto()) == null) continue;
            Object classProto = object;
            DeserializedContainerSource source2 = new DeserializedContainerSource(this, classId){
                @Nullable
                private final IncompatibleVersionErrorData<?> incompatibility;
                private final boolean isPreReleaseInvisible;
                @NotNull
                private final DeserializedContainerAbiStability abiStability;
                @NotNull
                private final String presentableString;
                {
                    this.isPreReleaseInvisible = KlibBasedSymbolProvider.access$getDeserializationConfiguration$p($receiver).getReportErrorsOnPreReleaseDependencies() && (KlibBasedSymbolProvider.access$getModuleHeader($receiver).getFlags() & 1) != 0;
                    this.abiStability = DeserializedContainerAbiStability.STABLE;
                    this.presentableString = "Package '" + $classId.getPackageFqName() + '\'';
                }

                @Nullable
                public IncompatibleVersionErrorData<?> getIncompatibility() {
                    return this.incompatibility;
                }

                public boolean isPreReleaseInvisible() {
                    return this.isPreReleaseInvisible;
                }

                @NotNull
                public DeserializedContainerAbiStability getAbiStability() {
                    return this.abiStability;
                }

                @NotNull
                public String getPresentableString() {
                    return this.presentableString;
                }

                public SourceFile getContainingFile() {
                    return SourceFile.NO_SOURCE_FILE;
                }
            };
            return new AbstractFirDeserializedSymbolProvider.ClassMetadataFindResult.Metadata(nameResolver2, (ProtoBuf.Class)classProto, this.annotationDeserializer, this.getModuleDataProvider().getModuleData(libraryPath), source2, (Function1<? super FirRegularClassSymbol, Unit>)((Function1)extractClassMetadata.1.1.INSTANCE));
        }
        return null;
    }

    @Override
    protected boolean isNewPlaceForBodyGeneration(@NotNull ProtoBuf.Class classProto) {
        Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
        return false;
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.getFragmentNameList().contains(fqName2.toString()) ? fqName2 : (FqName)null;
    }

    public static final /* synthetic */ CompilerDeserializationConfiguration access$getDeserializationConfiguration$p(KlibBasedSymbolProvider $this) {
        return $this.deserializationConfiguration;
    }

    public static final /* synthetic */ KlibMetadataProtoBuf.Header access$getModuleHeader(KlibBasedSymbolProvider $this) {
        return $this.getModuleHeader();
    }

    public static final /* synthetic */ KotlinResolvedLibrary access$getResolvedLibrary$p(KlibBasedSymbolProvider $this) {
        return $this.resolvedLibrary;
    }
}

