/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.ir.linkage.partial

import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin

@Suppress("KDocUnresolvedReference")
enum class PartiallyLinkedDeclarationOrigin : IrDeclarationOrigin {
    /** The unresolved (missing) declaration */
    MISSING_DECLARATION,

    /** The abstract callable member that needs to be implemented in non-abstract class */
    UNIMPLEMENTED_ABSTRACT_CALLABLE_MEMBER,

    /** The callable member is not implemented and inherit several implementations from interfaces, but no implementation from class */
    AMBIGUOUS_NON_OVERRIDDEN_CALLABLE_MEMBER,

    /** Auxiliary declaration generated by [PartiallyLinkedIrTreePatcher] */
    AUXILIARY_GENERATED_DECLARATION;
}
