/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.serialization.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.XmlElement;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MapBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NestedBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Property;

final class AccessorBindingWrapper
implements MultiNodeBinding,
NestedBinding {
    private final Binding binding;
    private final MutableAccessor accessor;
    final boolean isFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean isFlat, Property.Style beanStyle) {
        if (accessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(0);
        }
        if (binding == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(1);
        }
        this.accessor = accessor;
        this.binding = binding;
        this.isFlat = isFlat;
        this.beanStyle = beanStyle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object deserializeUnsafe(Object context2, @NotNull XmlElement element) {
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(5);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element);
            return context2;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).myBeanClass == Rectangle.class) {
                String xA = element.getAttributeValue("x");
                String yA = element.getAttributeValue("y");
                String wA = element.getAttributeValue("width");
                String hA = element.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context2;
                int x = StringUtilRt.parseInt(xA, 0);
                int y = StringUtilRt.parseInt(yA, 0);
                int h = StringUtilRt.parseInt(hA, 0);
                int w = StringUtilRt.parseInt(wA, 0);
                deserializedValue = new Rectangle(x, y, w, h);
            } else {
                deserializedValue = this.binding.deserializeUnsafe(currentValue, element);
            }
            if (currentValue == deserializedValue) return context2;
            this.accessor.set(context2, deserializedValue);
        }
        return context2;
    }

    @Override
    @NotNull
    public Object deserializeList2(@NotNull Object context2, @NotNull List<XmlElement> elements) {
        if (context2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(10);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList2(this.binding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.accessor.set(context2, deserializedValue);
            }
        }
        Object object = context2;
        if (object == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Override
    public boolean isMulti() {
        return this.binding instanceof MultiNodeBinding && ((MultiNodeBinding)this.binding).isMulti();
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(13);
        }
        if (this.binding instanceof MapBinding) {
            return ((MapBinding)this.binding).isBoundToWithoutProperty(element.name);
        }
        return this.binding.isBoundTo(element);
    }

    public String toString() {
        return this.binding.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList2";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

