/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.SyntheticLocalType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001cJ\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001cJ\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u0017J\u000e\u0010+\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001fJ\u0016\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\u0017J\u000e\u00105\u001a\u00020\u00172\u0006\u00103\u001a\u00020%J\u001e\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\"2\u0006\u00108\u001a\u00020#2\u0006\u00104\u001a\u00020\u0017J\u0016\u00109\u001a\u00020\u00172\u0006\u00107\u001a\u00020\"2\u0006\u00108\u001a\u00020#J\u000e\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020\u0003J\u0006\u0010>\u001a\u00020)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!\u0012\u0004\u0012\u00020\u00170\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00170\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010-\u001a\u00020.*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u0010:\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\r\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;)V", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "bodyGen", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBodyGen", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "tagIdx", "", "getTagIdx", "()I", "wasmLocals", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "wasmSyntheticLocals", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/SyntheticLocalType;", "loopLevels", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LoopLabelType;", "nonLocalReturnLevels", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnableBlockSymbol;", "inlinedFunctionStack", "Ljava/util/LinkedList;", "defineLocal", "", "irValueDeclaration", "referenceLocal", "index", "wasmType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "getWasmType", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/SyntheticLocalType;)Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "type", "defineNonLocalReturnLevel", "block", "level", "referenceNonLocalReturnLevel", "defineLoopLevel", "irLoop", "labelType", "referenceLoopLevel", "currentFunction", "getCurrentFunction", "stepIntoInlinedFunction", "inlineFunction", "stepOutLastInlinedFunction", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmFunctionCodegenContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmFunctionCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,108:1\n1#2:109\n381#3,7:110\n*S KotlinDebug\n*F\n+ 1 WasmFunctionCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext\n*L\n69#1:110,7\n*E\n"})
public final class WasmFunctionCodegenContext {
    @NotNull
    private final IrFunction irFunction;
    @NotNull
    private final WasmFunction.Defined wasmFunction;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmModuleCodegenContext context;
    @NotNull
    private final WasmExpressionBuilder bodyGen;
    @NotNull
    private final LinkedHashMap<IrValueSymbol, WasmLocal> wasmLocals;
    @NotNull
    private final LinkedHashMap<SyntheticLocalType, WasmLocal> wasmSyntheticLocals;
    @NotNull
    private final LinkedHashMap<Pair<IrLoop, LoopLabelType>, Integer> loopLevels;
    @NotNull
    private final LinkedHashMap<IrReturnableBlockSymbol, Integer> nonLocalReturnLevels;
    @NotNull
    private final LinkedList<IrFunction> inlinedFunctionStack;

    public WasmFunctionCodegenContext(@NotNull IrFunction irFunction, @NotNull WasmFunction.Defined wasmFunction, @NotNull WasmBackendContext backendContext, @NotNull WasmModuleCodegenContext context2) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.irFunction = irFunction;
        this.wasmFunction = wasmFunction;
        this.backendContext = backendContext;
        this.context = context2;
        this.bodyGen = new WasmIrExpressionBuilder(this.wasmFunction.getInstructions());
        this.wasmLocals = new LinkedHashMap();
        this.wasmSyntheticLocals = new LinkedHashMap();
        this.loopLevels = new LinkedHashMap();
        this.nonLocalReturnLevels = new LinkedHashMap();
        this.inlinedFunctionStack = new LinkedList();
    }

    @NotNull
    public final IrFunction getIrFunction() {
        return this.irFunction;
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmExpressionBuilder getBodyGen() {
        return this.bodyGen;
    }

    public final int getTagIdx() {
        return 0;
    }

    public final void defineLocal(@NotNull IrValueSymbol irValueDeclaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)irValueDeclaration, (String)"irValueDeclaration");
        boolean bl2 = bl = !((Map)this.wasmLocals).containsKey(irValueDeclaration);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WasmFunctionCodegenContext$defineLocal$22 = false;
            String $i$a$-assert-WasmFunctionCodegenContext$defineLocal$22 = "Redefinition of local";
            throw new AssertionError((Object)$i$a$-assert-WasmFunctionCodegenContext$defineLocal$22);
        }
        IrValueDeclaration owner = irValueDeclaration.getOwner();
        int n = this.wasmFunction.getLocals().size();
        String string2 = owner.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        WasmLocal wasmLocal = new WasmLocal(n, string2, owner instanceof IrValueParameter ? this.context.transformValueParameterType((IrValueParameter)owner) : this.context.transformType(owner.getType()), irValueDeclaration instanceof IrValueParameterSymbol);
        ((Map)this.wasmLocals).put(irValueDeclaration, wasmLocal);
        ((Collection)this.wasmFunction.getLocals()).add(wasmLocal);
    }

    @NotNull
    public final WasmLocal referenceLocal(@NotNull IrValueSymbol irValueDeclaration) {
        Intrinsics.checkNotNullParameter((Object)irValueDeclaration, (String)"irValueDeclaration");
        return (WasmLocal)MapsKt.getValue((Map)this.wasmLocals, (Object)irValueDeclaration);
    }

    @NotNull
    public final WasmLocal referenceLocal(int index) {
        return this.wasmFunction.getLocals().get(index);
    }

    private final WasmType getWasmType(SyntheticLocalType $this$wasmType) {
        WasmType wasmType;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$wasmType.ordinal()]) {
            case 1: {
                wasmType = new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceGcType(this.backendContext.getIrBuiltIns().getAnyClass())));
                break;
            }
            case 2: {
                wasmType = WasmI32.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return wasmType;
    }

    @NotNull
    public final WasmLocal referenceLocal(@NotNull SyntheticLocalType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Map $this$getOrPut$iv = this.wasmSyntheticLocals;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get((Object)type2);
        if (value$iv == null) {
            WasmLocal wasmLocal;
            boolean bl = false;
            WasmLocal it = wasmLocal = new WasmLocal(this.wasmFunction.getLocals().size(), type2.name(), this.getWasmType(type2), false);
            boolean bl2 = false;
            ((Collection)this.wasmFunction.getLocals()).add(it);
            WasmLocal answer$iv = wasmLocal;
            $this$getOrPut$iv.put(type2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (WasmLocal)object;
    }

    public final void defineNonLocalReturnLevel(@NotNull IrReturnableBlockSymbol block, int level) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Integer n = level;
        ((Map)this.nonLocalReturnLevels).put(block, n);
    }

    public final int referenceNonLocalReturnLevel(@NotNull IrReturnableBlockSymbol block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return ((Number)MapsKt.getValue((Map)this.nonLocalReturnLevels, (Object)block)).intValue();
    }

    public final void defineLoopLevel(@NotNull IrLoop irLoop, @NotNull LoopLabelType labelType, int level) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)irLoop, (String)"irLoop");
        Intrinsics.checkNotNullParameter((Object)((Object)labelType), (String)"labelType");
        Pair loopKey = new Pair((Object)irLoop, (Object)labelType);
        boolean bl2 = bl = !((Map)this.loopLevels).containsKey(loopKey);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Redefinition of loop";
            throw new AssertionError((Object)string2);
        }
        Integer n = level;
        ((Map)this.loopLevels).put(loopKey, n);
    }

    public final int referenceLoopLevel(@NotNull IrLoop irLoop, @NotNull LoopLabelType labelType) {
        Intrinsics.checkNotNullParameter((Object)irLoop, (String)"irLoop");
        Intrinsics.checkNotNullParameter((Object)((Object)labelType), (String)"labelType");
        return ((Number)MapsKt.getValue((Map)this.loopLevels, (Object)new Pair((Object)irLoop, (Object)labelType))).intValue();
    }

    @NotNull
    public final IrFunction getCurrentFunction() {
        IrFunction irFunction = (IrFunction)CollectionsKt.lastOrNull((List)this.inlinedFunctionStack);
        if (irFunction == null) {
            irFunction = this.irFunction;
        }
        return irFunction;
    }

    public final void stepIntoInlinedFunction(@NotNull IrFunction inlineFunction2) {
        Intrinsics.checkNotNullParameter((Object)inlineFunction2, (String)"inlineFunction");
        this.inlinedFunctionStack.push(inlineFunction2);
    }

    public final void stepOutLastInlinedFunction() {
        this.inlinedFunctionStack.pop();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyntheticLocalType.values().length];
            try {
                nArray[SyntheticLocalType.IS_INTERFACE_PARAMETER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntheticLocalType.TABLE_SWITCH_SELECTOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

