/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderers;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\bj\u0002`\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ-\u0010\n\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\bj\u0002`\u00072\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u000f\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\bj\u0002`\u00072\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/MultiplatformDiagnosticRenderingMode;", "", "<init>", "()V", "newLine", "", "sb", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "renderList", "elements", "", "Lkotlin/Function0;", "(Ljava/lang/StringBuilder;Ljava/util/List;)V", "renderSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "indent", "", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/lang/String;)V", "checkers"})
public class MultiplatformDiagnosticRenderingMode {
    public void newLine(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
    }

    public void renderList(@NotNull StringBuilder sb, @NotNull List<? extends Function0<Unit>> elements) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        for (Function0<Unit> function0 : elements) {
            function0.invoke();
        }
    }

    public void renderSymbol(@NotNull StringBuilder sb, @NotNull FirBasedSymbol<?> symbol, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        sb.append(indent);
        sb.append("    ");
        StringBuilder stringBuilder = sb.append(FirDiagnosticRenderers.INSTANCE.getSYMBOL().render(symbol));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
    }
}

