/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureFactory;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0012\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\bH\u0014J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J$\u0010\"\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u0019J\u001e\u0010$\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001cJ\u0016\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010(\u001a\u00020\tR0\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "globalTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;)V", "table", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/HashMap;", "getTable", "()Ljava/util/HashMap;", "globalDeclarationTable", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "inFile", "R", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isLocalDeclaration", "", "compatibleMode", "isExportedDeclaration", "declaration", "tryComputeBackendSpecificSignature", "allocateIndexedSignature", "privateDeclarationSignature", "builder", "signatureByDeclaration", "recordInSignatureClashDetector", "assumeDeclarationSignature", "", "signature", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n381#2,7:101\n381#2,7:108\n1#3:115\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n*L\n74#1:101,7\n79#1:108,7\n*E\n"})
public class DeclarationTable {
    @NotNull
    private final HashMap<IrDeclaration, IdSignature> table;
    @NotNull
    private final GlobalDeclarationTable globalDeclarationTable;
    @NotNull
    private final IdSignatureFactory signaturer;

    public DeclarationTable(@NotNull GlobalDeclarationTable globalTable) {
        Intrinsics.checkNotNullParameter((Object)globalTable, (String)"globalTable");
        this.table = new HashMap();
        this.globalDeclarationTable = globalTable;
        this.signaturer = new IdSignatureFactory(globalTable.getPublicIdSignatureComputer(), this);
    }

    @NotNull
    protected final HashMap<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    @NotNull
    protected GlobalDeclarationTable getGlobalDeclarationTable() {
        return this.globalDeclarationTable;
    }

    @NotNull
    public IdSignatureFactory getSignaturer() {
        return this.signaturer;
    }

    public final <R> R inFile(@Nullable IrFile file2, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        IrFile irFile = file2;
        return this.getSignaturer().inFile(irFile != null ? irFile.getSymbol() : null, block);
    }

    private final boolean isLocalDeclaration(IrDeclaration $this$isLocalDeclaration, boolean compatibleMode) {
        return !this.isExportedDeclaration($this$isLocalDeclaration, compatibleMode);
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.getGlobalDeclarationTable().isExportedDeclaration(declaration, compatibleMode);
    }

    @Nullable
    protected IdSignature tryComputeBackendSpecificSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return null;
    }

    private final IdSignature allocateIndexedSignature(IrDeclaration declaration, boolean compatibleMode) {
        Object object;
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature answer$iv = this.getSignaturer().composeFileLocalIdSignature(declaration, compatibleMode);
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    @NotNull
    public final IdSignature privateDeclarationSignature(@NotNull IrDeclaration declaration, boolean compatibleMode, @NotNull Function0<? extends IdSignature> builder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        boolean bl = this.isLocalDeclaration(declaration, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl2 = false;
            IdSignature answer$iv = (IdSignature)builder.invoke();
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    @NotNull
    public final IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode, boolean recordInSignatureClashDetector) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature idSignature = this.tryComputeBackendSpecificSignature(declaration);
        if (idSignature != null) {
            IdSignature it = idSignature;
            boolean bl = false;
            return it;
        }
        return this.isLocalDeclaration(declaration, compatibleMode) ? this.allocateIndexedSignature(declaration, compatibleMode) : this.getGlobalDeclarationTable().computeSignatureByDeclaration(declaration, compatibleMode, recordInSignatureClashDetector);
    }

    public final void assumeDeclarationSignature(@NotNull IrDeclaration declaration, @NotNull IdSignature signature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        boolean bl2 = bl = this.table.get(declaration) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Declaration table already has signature for " + RenderIrElementKt.render$default(declaration, null, 1, null);
            throw new AssertionError((Object)string2);
        }
        this.table.put(declaration, signature);
    }
}

