/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.LoweredStatementOrigins;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmSyntheticAccessorGenerator;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0082\b\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020\b*\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u0016*\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\"\u0010'\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u001fH\u0002J\u001e\u0010)\u001a\u00020\u0016*\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u001a\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\"H\u0002J\u0016\u0010.\u001a\u00020\u0016*\u00020/2\b\u0010-\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u0010%\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020$2\u0006\u0010%\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u0010%\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020$2\u0006\u0010%\u001a\u00020>H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "pendingAccessorsToAdd", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Ljava/util/Set;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getPendingAccessorsToAdd", "()Ljava/util/Set;", "accessorGenerator", "Lorg/jetbrains/kotlin/backend/jvm/JvmSyntheticAccessorGenerator;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "processingIrInlinedFun", "", "withinIrInlinedFun", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "save", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isAccessible", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "withSuper", "thisObjReference", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "shouldGenerateSpecialAccessWithoutSyntheticAccessor", "symbol", "isDirectlyAccessible", "handleLambdaMetafactoryIntrinsic", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "thisSymbol", "isAccessibleFromSyntheticProxy", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitInlinedFunctionBlock", "inlinedBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nSyntheticAccessorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorTransformer\n+ 2 IrElementTransformerVoidWithContext.kt\norg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext\n*L\n1#1,374:1\n128#1,4:375\n133#1:387\n128#1,6:388\n47#2,2:379\n47#2,4:381\n49#2,2:385\n*S KotlinDebug\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorTransformer\n*L\n343#1:375,4\n343#1:387\n356#1:388,6\n344#1:379,2\n345#1:381,4\n344#1:385,2\n*E\n"})
final class SyntheticAccessorTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final Set<IrFunction> pendingAccessorsToAdd;
    @NotNull
    private final JvmSyntheticAccessorGenerator accessorGenerator;
    @NotNull
    private final IrInlineScopeResolver inlineScopeResolver;
    private boolean processingIrInlinedFun;

    public SyntheticAccessorTransformer(@NotNull JvmBackendContext context, @NotNull IrFile irFile, @NotNull Set<IrFunction> pendingAccessorsToAdd) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter(pendingAccessorsToAdd, (String)"pendingAccessorsToAdd");
        this.context = context;
        this.irFile = irFile;
        this.pendingAccessorsToAdd = pendingAccessorsToAdd;
        this.accessorGenerator = new JvmSyntheticAccessorGenerator(this.context);
        this.inlineScopeResolver = IrInlineReferenceLocatorKt.findInlineCallSites(this.irFile, this.context);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final Set<IrFunction> getPendingAccessorsToAdd() {
        return this.pendingAccessorsToAdd;
    }

    private final <T extends IrFunction> T save(T $this$save) {
        boolean bl;
        boolean bl2 = bl = Intrinsics.areEqual((Object)IrUtilsKt.getFileOrNull($this$save), (Object)this.irFile) || this.processingIrInlinedFun;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "SyntheticAccessorLowering should not attempt to modify other files!\nWhile lowering this file: " + RenderIrElementKt.render$default(this.irFile, null, 1, null) + "\nTrying to add this accessor: " + RenderIrElementKt.render$default($this$save, null, 1, null);
            throw new AssertionError((Object)string2);
        }
        if (Intrinsics.areEqual((Object)IrUtilsKt.getFileOrNull($this$save), (Object)this.irFile)) {
            ((Collection)this.pendingAccessorsToAdd).add($this$save);
        }
        return $this$save;
    }

    private final boolean isAccessible(IrSymbol $this$isAccessible, boolean withSuper, IrClassSymbol thisObjReference) {
        SyntheticAccessorLowering.Companion $this$isAccessible_u24lambda_u241 = SyntheticAccessorLowering.Companion;
        boolean bl = false;
        return SyntheticAccessorLowering.Companion.isAccessible$default($this$isAccessible_u24lambda_u241, $this$isAccessible, this.context, this.getCurrentScope(), this.inlineScopeResolver, withSuper, thisObjReference, false, 32, null);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrFunction irFunction;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (IrUtilsKt.usesDefaultArguments(expression2)) {
            return super.visitFunctionAccess(expression2);
        }
        IrFunction callee = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        boolean withSuper = (irCall != null ? irCall.getSuperQualifierSymbol() : null) != null;
        Object object = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        IrClassifierSymbol irClassifierSymbol = object != null && (object = ((IrMemberAccessExpression)object).getDispatchReceiver()) != null && (object = ((IrExpression)object).getType()) != null ? IrTypesKt.getClassifierOrNull((IrType)object) : null;
        IrClassSymbol thisSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        boolean generateSpecialAccessWithoutSyntheticAccessor = this.shouldGenerateSpecialAccessWithoutSyntheticAccessor(expression2, withSuper, thisSymbol);
        if (expression2 instanceof IrCall && Intrinsics.areEqual((Object)callee.getSymbol(), (Object)this.context.getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic())) {
            return super.visitExpression(this.handleLambdaMetafactoryIntrinsic((IrCall)expression2, thisSymbol));
        }
        if (generateSpecialAccessWithoutSyntheticAccessor) {
            return super.visitFunctionAccess(expression2);
        }
        if (callee instanceof IrConstructor && this.accessorGenerator.isOrShouldBeHiddenAsSealedClassConstructor((IrConstructor)callee)) {
            irFunction = this.accessorGenerator.getSyntheticConstructorOfSealedClass((IrConstructor)callee);
        } else if (callee instanceof IrConstructor && this.accessorGenerator.isOrShouldBeHiddenSinceHasMangledParams((IrConstructor)callee)) {
            irFunction = this.accessorGenerator.getSyntheticConstructorWithMangledParams((IrConstructor)callee);
        } else if (!this.isAccessible((IrSymbol)expression2.getSymbol(), withSuper, thisSymbol)) {
            irFunction = this.save(this.accessorGenerator.getSyntheticFunctionAccessor(expression2, this.getAllScopes()));
        } else {
            return super.visitFunctionAccess(expression2);
        }
        IrFunction accessor = irFunction;
        return super.visitExpression(this.accessorGenerator.modifyFunctionAccessExpression(expression2, accessor.getSymbol()));
    }

    private final boolean shouldGenerateSpecialAccessWithoutSyntheticAccessor(IrFunctionAccessExpression expression2, boolean withSuper, IrClassSymbol thisObjReference) {
        boolean bl;
        if (this.context.getEvaluatorData() == null) {
            bl = false;
        } else if (expression2 instanceof IrCall) {
            ScopeWithIr scopeWithIr = this.getCurrentFunction();
            IrElement irElement = scopeWithIr != null ? scopeWithIr.getIrElement() : null;
            IrFunction irFunction = irElement instanceof IrFunction ? (IrFunction)irElement : null;
            boolean inJvmStaticWrapper = Intrinsics.areEqual((Object)(irFunction != null ? irFunction.getOrigin() : null), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getJVM_STATIC_WRAPPER());
            bl = !inJvmStaticWrapper && !this.isDirectlyAccessible(((IrCall)expression2).getSymbol(), withSuper, thisObjReference);
        } else {
            bl = expression2 instanceof IrConstructorCall ? !this.isDirectlyAccessible(((IrConstructorCall)expression2).getSymbol(), false, thisObjReference) : false;
        }
        return bl;
    }

    private final boolean shouldGenerateSpecialAccessWithoutSyntheticAccessor(IrSymbol symbol) {
        return this.context.getEvaluatorData() != null && !this.isDirectlyAccessible(symbol, false, null);
    }

    private final boolean isDirectlyAccessible(IrSymbol $this$isDirectlyAccessible, boolean withSuper, IrClassSymbol thisObjReference) {
        return SyntheticAccessorLowering.Companion.isAccessible($this$isDirectlyAccessible, this.context, this.getCurrentScope(), this.inlineScopeResolver, withSuper, thisObjReference, true);
    }

    private final IrExpression handleLambdaMetafactoryIntrinsic(IrCall call2, IrClassSymbol thisSymbol) {
        IrExpression irExpression = call2.getValueArgument(1);
        IrFunctionReference irFunctionReference = irExpression instanceof IrFunctionReference ? (IrFunctionReference)irExpression : null;
        if (irFunctionReference == null) {
            throw new AssertionError((Object)("'implMethodReference' is expected to be 'IrFunctionReference': " + DumpIrTreeKt.dump$default(call2, null, 1, null)));
        }
        IrFunctionReference implFunRef = irFunctionReference;
        IrFunctionSymbol implFunSymbol = (IrFunctionSymbol)implFunRef.getSymbol();
        if (this.isAccessibleFromSyntheticProxy(implFunSymbol, thisSymbol)) {
            return call2;
        }
        IrFunction accessor = this.save(this.accessorGenerator.getSyntheticFunctionAccessor(implFunRef, this.getAllScopes()));
        IrFunctionReferenceImpl accessorRef = BuildersKt.IrFunctionReferenceImpl(implFunRef.getStartOffset(), implFunRef.getEndOffset(), implFunRef.getType(), accessor.getSymbol(), accessor.getTypeParameters().size(), implFunRef.getReflectionTarget(), implFunRef.getOrigin());
        IrExpressionsKt.copyTypeArgumentsFrom$default(accessorRef, implFunRef, 0, 2, null);
        IrFunction implFun = implFunSymbol.getOwner();
        int accessorArgIndex = 0;
        if (implFun.getDispatchReceiverParameter() != null) {
            accessorRef.putValueArgument(accessorArgIndex++, implFunRef.getDispatchReceiver());
        }
        if (implFun.getExtensionReceiverParameter() != null) {
            accessorRef.putValueArgument(accessorArgIndex++, implFunRef.getExtensionReceiver());
        }
        int n = implFunRef.getValueArgumentsCount();
        for (int implArgIndex = 0; implArgIndex < n; ++implArgIndex) {
            accessorRef.putValueArgument(accessorArgIndex++, implFunRef.getValueArgument(implArgIndex));
        }
        if (accessor instanceof IrConstructor) {
            accessorRef.putValueArgument(accessorArgIndex, this.accessorGenerator.createAccessorMarkerArgument());
        }
        call2.putValueArgument(1, accessorRef);
        return call2;
    }

    private final boolean isAccessibleFromSyntheticProxy(IrFunctionSymbol $this$isAccessibleFromSyntheticProxy, IrClassSymbol thisSymbol) {
        if (!this.isAccessible($this$isAccessibleFromSyntheticProxy, false, thisSymbol)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$isAccessibleFromSyntheticProxy.getOwner().getVisibility(), (Object)DescriptorVisibilities.PROTECTED) && !Intrinsics.areEqual((Object)$this$isAccessibleFromSyntheticProxy.getOwner().getVisibility(), (Object)JavaDescriptorVisibilities.PROTECTED_STATIC_VISIBILITY)) {
            return true;
        }
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return Intrinsics.areEqual((Object)this.inlineScopeResolver.findContainer(scopeWithIr.getIrElement()), (Object)IrUtilsKt.getParentAsClass($this$isAccessibleFromSyntheticProxy.getOwner()));
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        IrClassSymbol dispatchReceiverClassSymbol;
        IrType dispatchReceiverType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrExpression irExpression = expression2.getReceiver();
        IrType irType = dispatchReceiverType = irExpression != null ? irExpression.getType() : null;
        IrClassifierSymbol irClassifierSymbol = irType != null ? IrTypesKt.getClassifierOrNull(irType) : null;
        IrClassSymbol irClassSymbol = dispatchReceiverClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (this.isAccessible(expression2.getSymbol(), false, dispatchReceiverClassSymbol)) {
            return super.visitExpression(expression2);
        }
        if (this.shouldGenerateSpecialAccessWithoutSyntheticAccessor(expression2.getSymbol())) {
            return super.visitExpression(expression2);
        }
        return super.visitExpression(this.accessorGenerator.modifyGetterExpression(expression2, ((IrSimpleFunction)this.save((IrFunction)this.accessorGenerator.getSyntheticGetter(expression2, this.getAllScopes()))).getSymbol()));
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        IrClassSymbol dispatchReceiverClassSymbol;
        IrType dispatchReceiverType;
        IrProperty correspondingProperty;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        IrProperty irProperty = correspondingProperty = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
        if (correspondingProperty != null && !correspondingProperty.isVar()) {
            return super.visitExpression(expression2);
        }
        if (this.shouldGenerateSpecialAccessWithoutSyntheticAccessor(expression2.getSymbol())) {
            return super.visitExpression(expression2);
        }
        IrExpression irExpression = expression2.getReceiver();
        IrType irType = dispatchReceiverType = irExpression != null ? irExpression.getType() : null;
        IrClassifierSymbol irClassifierSymbol = irType != null ? IrTypesKt.getClassifierOrNull(irType) : null;
        IrClassSymbol irClassSymbol = dispatchReceiverClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (this.isAccessible(expression2.getSymbol(), false, dispatchReceiverClassSymbol)) {
            return super.visitExpression(expression2);
        }
        return super.visitExpression(this.accessorGenerator.modifySetterExpression(expression2, ((IrSimpleFunction)this.save((IrFunction)this.accessorGenerator.getSyntheticSetter(expression2, this.getAllScopes()))).getSymbol()));
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.accessorGenerator.isOrShouldBeHiddenSinceHasMangledParams(declaration)) {
            this.save((IrFunction)this.accessorGenerator.getSyntheticConstructorWithMangledParams(declaration));
            declaration.setVisibility(DescriptorVisibilities.PRIVATE);
        } else if (this.accessorGenerator.isOrShouldBeHiddenAsSealedClassConstructor(declaration)) {
            this.save((IrFunction)this.accessorGenerator.getSyntheticConstructorOfSealedClass(declaration));
            declaration.setVisibility(DescriptorVisibilities.PRIVATE);
        }
        return super.visitConstructor(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        if (!IrUtilsKt.isLambda(expression2.getOrigin()) && function2 instanceof IrConstructor) {
            IrConstructor irConstructor;
            if (this.accessorGenerator.isOrShouldBeHiddenSinceHasMangledParams((IrConstructor)function2)) {
                irConstructor = this.accessorGenerator.getSyntheticConstructorWithMangledParams((IrConstructor)function2);
            } else if (this.accessorGenerator.isOrShouldBeHiddenAsSealedClassConstructor((IrConstructor)function2)) {
                irConstructor = this.accessorGenerator.getSyntheticConstructorOfSealedClass((IrConstructor)function2);
            } else {
                return super.visitFunctionReference(expression2);
            }
            IrConstructor generatedAccessor = irConstructor;
            this.transformChildrenVoid(expression2);
            return BuildersKt.IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), generatedAccessor.getSymbol(), generatedAccessor.getTypeParameters().size(), generatedAccessor.getSymbol(), expression2.getOrigin());
        }
        return super.visitFunctionReference(expression2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
        Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
        if (IrInlineUtilsKt.isFunctionInlining(inlinedBlock)) {
            IrExpression irExpression;
            IrDeclaration callee = JvmIrInlineUtilsKt.getInlineDeclaration(inlinedBlock);
            IrClass irClass = IrUtilsKt.getParentClassOrNull(callee);
            if (irClass == null) {
                return super.visitInlinedFunctionBlock(inlinedBlock);
            }
            IrClass parentClass = irClass;
            SyntheticAccessorTransformer this_$iv = this;
            boolean $i$f$withinIrInlinedFun = false;
            boolean oldProcessingInline$iv = this_$iv.processingIrInlinedFun;
            try {
                this_$iv.processingIrInlinedFun = true;
                boolean bl = false;
                IrElementTransformerVoidWithContext this_$iv2 = this;
                boolean $i$f$withinScope = false;
                IrElementTransformerVoidWithContext.access$unsafeEnterScope(this_$iv2, parentClass);
                boolean bl2 = false;
                IrElementTransformerVoidWithContext this_$iv3 = this;
                boolean $i$f$withinScope2 = false;
                IrElementTransformerVoidWithContext.access$unsafeEnterScope(this_$iv3, callee);
                boolean bl3 = false;
                IrExpression result$iv = super.visitInlinedFunctionBlock(inlinedBlock);
                IrElementTransformerVoidWithContext.access$unsafeLeaveScope(this_$iv3);
                IrExpression result$iv2 = result$iv;
                IrElementTransformerVoidWithContext.access$unsafeLeaveScope(this_$iv2);
                irExpression = result$iv2;
            }
            finally {
                this_$iv.processingIrInlinedFun = oldProcessingInline$iv;
            }
            return irExpression;
        }
        return super.visitInlinedFunctionBlock(inlinedBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)LoweredStatementOrigins.INSTANCE.getINLINE_ARGS_CONTAINER())) {
            IrExpression irExpression;
            SyntheticAccessorTransformer this_$iv = this;
            boolean $i$f$withinIrInlinedFun = false;
            boolean oldProcessingInline$iv = this_$iv.processingIrInlinedFun;
            try {
                this_$iv.processingIrInlinedFun = true;
                boolean bl = false;
                irExpression = super.visitBlock(expression2);
            }
            finally {
                this_$iv.processingIrInlinedFun = oldProcessingInline$iv;
            }
            return irExpression;
        }
        return super.visitBlock(expression2);
    }
}

