/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallableKt;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/BinaryOp;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethod;", "opcode", "", "<init>", "(I)V", "shift", "", "toCallable", "Lorg/jetbrains/kotlin/codegen/Callable;", "method", "Lorg/jetbrains/kotlin/codegen/CallableMethod;", "backend"})
public final class BinaryOp
extends IntrinsicMethod {
    private final int opcode;

    public BinaryOp(int opcode) {
        this.opcode = opcode;
    }

    private final boolean shift() {
        return this.opcode == 120 || this.opcode == 122 || this.opcode == 124;
    }

    @Override
    @NotNull
    protected Callable toCallable(@NotNull CallableMethod method) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Type returnType = method.getReturnType();
        boolean bl2 = bl = method.getValueParameters().size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Type arg0Type = null;
        Type arg1Type = null;
        Type intermediateResultType = null;
        if (!Intrinsics.areEqual((Object)method.getOwner(), (Object)Type.CHAR_TYPE)) {
            Type type2;
            arg0Type = intermediateResultType = AsmUtil.numberFunctionOperandType(returnType);
            if (this.shift()) {
                Type type3 = Type.INT_TYPE;
                type2 = type3;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"INT_TYPE");
            } else {
                type2 = arg0Type;
            }
            arg1Type = type2;
        } else {
            arg0Type = Type.CHAR_TYPE;
            arg1Type = method.getValueParameters().get(0).getAsmType();
            intermediateResultType = AsmUtil.numberFunctionOperandType(returnType);
        }
        return IntrinsicCallableKt.createBinaryIntrinsicCallable$default(returnType, arg1Type, arg0Type, null, (arg_0, arg_1) -> BinaryOp.toCallable$lambda$0(returnType, this, intermediateResultType, arg_0, arg_1), 8, null);
    }

    private static final Unit toCallable$lambda$0(Type $returnType, BinaryOp this$0, Type $intermediateResultType, IntrinsicCallable $this$createBinaryIntrinsicCallable, InstructionAdapter v) {
        Intrinsics.checkNotNullParameter((Object)$this$createBinaryIntrinsicCallable, (String)"$this$createBinaryIntrinsicCallable");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v.visitInsn($returnType.getOpcode(this$0.opcode));
        StackValue.coerce($intermediateResultType, $returnType, v);
        return Unit.INSTANCE;
    }
}

