/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiQualifiedNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;

public abstract class MethodSignatureBase
implements MethodSignature {
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    private volatile PsiType[] myErasedParameterTypes;
    final PsiTypeParameter[] myTypeParameters;
    private transient int myHash;

    MethodSignatureBase(@NotNull PsiSubstitutor substitutor2, PsiType @NotNull [] parameterTypes, PsiTypeParameter @NotNull [] typeParameters2) {
        if (substitutor2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(0);
        }
        if (parameterTypes == null) {
            MethodSignatureBase.$$$reportNull$$$0(1);
        }
        if (typeParameters2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(2);
        }
        this.mySubstitutor = substitutor2;
        assert (substitutor2.isValid());
        this.myParameterTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type2 = parameterTypes[i];
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            this.myParameterTypes[i] = substitutor2.substitute(type2);
        }
        this.myTypeParameters = typeParameters2;
    }

    MethodSignatureBase(@NotNull PsiSubstitutor substitutor2, @Nullable PsiParameterList parameterList2, @Nullable PsiTypeParameterList typeParameterList) {
        if (substitutor2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(3);
        }
        this.mySubstitutor = substitutor2;
        if (parameterList2 == null) {
            this.myParameterTypes = PsiType.EMPTY_ARRAY;
        } else {
            PsiParameter[] parameters = parameterList2.getParameters();
            this.myParameterTypes = PsiType.createArray(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                PsiType type2 = parameters[i].getType();
                if (type2 instanceof PsiEllipsisType) {
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                }
                this.myParameterTypes[i] = substitutor2.substitute(type2);
            }
        }
        this.myTypeParameters = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @Override
    public PsiType @NotNull [] getParameterTypes() {
        if (this.myParameterTypes == null) {
            MethodSignatureBase.$$$reportNull$$$0(4);
        }
        return this.myParameterTypes;
    }

    @Override
    public PsiTypeParameter @NotNull [] getTypeParameters() {
        if (this.myTypeParameters == null) {
            MethodSignatureBase.$$$reportNull$$$0(5);
        }
        return this.myTypeParameters;
    }

    public PsiType @NotNull [] getErasedParameterTypes() {
        PsiType[] result2 = this.myErasedParameterTypes;
        if (result2 == null) {
            result2 = MethodSignatureUtil.calcErasedParameterTypes(this);
            this.myErasedParameterTypes = result2;
        }
        if (result2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(6);
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)o;
        return MethodSignatureUtil.areSignaturesEqual(methodSignature, this);
    }

    public int hashCode() {
        int hash = this.myHash;
        if (hash == 0) {
            hash = this.getName().hashCode();
            PsiType[] parameterTypes = this.getErasedParameterTypes();
            hash = 31 * hash + parameterTypes.length;
            int length = Math.min(3, parameterTypes.length);
            for (int i = 0; i < length; ++i) {
                PsiType type2 = parameterTypes[i];
                if (type2 == null) continue;
                hash = 31 * hash + type2.hashCode();
            }
            this.myHash = hash;
        }
        return hash;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + ": ";
        PsiTypeParameter[] typeParameters2 = this.getTypeParameters();
        if (typeParameters2.length != 0) {
            s = s + Arrays.stream(typeParameters2).map(PsiQualifiedNamedElement::getName).collect(Collectors.joining(", ", "<", ">"));
        }
        s = s + this.getName() + "(" + Arrays.asList(this.getParameterTypes()) + ")";
        return s;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            MethodSignatureBase.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErasedParameterTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

