/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class PsiTypesUtil {
    private static final Logger LOG = Logger.getInstance(PsiTypesUtil.class);
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new HashMap<String, String>();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new HashMap<String, String>();

    private PsiTypesUtil() {
    }

    public static Object getDefaultValue(PsiType type2) {
        if (!(type2 instanceof PsiPrimitiveType)) {
            return null;
        }
        switch (type2.getCanonicalText()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type2) {
        return PsiTypesUtil.getDefaultValueOfType(type2, false);
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type2, boolean customDefaultValues) {
        if (type2 instanceof PsiArrayType) {
            PsiClassType classType;
            int count = type2.getArrayDimensions() - 1;
            PsiType componentType = type2.getDeepComponentType();
            if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                return "null";
            }
            PsiType erasedComponentType = TypeConversionUtil.erasure(componentType);
            StringBuilder buffer = new StringBuilder();
            buffer.append("new");
            buffer.append(" ");
            buffer.append(erasedComponentType.getCanonicalText());
            buffer.append("[0]");
            for (int i = 0; i < count; ++i) {
                buffer.append("[]");
            }
            String string2 = buffer.toString();
            if (string2 == null) {
                PsiTypesUtil.$$$reportNull$$$0(0);
            }
            return string2;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return PsiTypes.booleanType().equals(type2) ? "false" : "0";
        }
        if (customDefaultValues) {
            PsiClassType rawType;
            PsiClassType psiClassType = rawType = type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : null;
            if (rawType != null && rawType.equalsToText("java.util.Optional")) {
                return "java.util.Optional.empty()";
            }
        }
        return "null";
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    @NonNls
    public static String unboxIfPossible(@Nullable @NonNls String type2) {
        if (type2 == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type2);
        return s == null ? type2 : s;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String boxIfPossible(@Nullable String type2) {
        if (type2 == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type2);
        return s == null ? type2 : s;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    @NotNull
    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiTypesUtil.$$$reportNull$$$0(1);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
        if (psiClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(2);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type2) {
        PsiType lub;
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(3);
        }
        if ((lub = type2.getLeastUpperBound()) instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiMethodReferenceExpression methodExpression, @NotNull PsiMethod method) {
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(4);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(5);
        }
        if (PsiTypesUtil.isGetClass(method)) {
            PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(methodExpression);
            return qualifierType != null ? PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true) : null;
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call2, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @NotNull Condition<? super IElementType> condition, @NotNull LanguageLevel languageLevel) {
        if (call2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(6);
        }
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(7);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(8);
        }
        if (condition == null) {
            PsiTypesUtil.$$$reportNull$$$0(9);
        }
        if (languageLevel == null) {
            PsiTypesUtil.$$$reportNull$$$0(10);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && PsiTypesUtil.isGetClass(method)) {
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call2.getProject();
            if (qualifier != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier.getType());
            } else {
                PsiElement parent2;
                for (parent2 = call2.getContext(); parent2 != null && condition.value(parent2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parent2).getElementType() : parent2.getNode().getElementType()); parent2 = parent2.getContext()) {
                }
                if (parent2 != null) {
                    qualifierType = JavaPsiFacade.getElementFactory(project).createType((PsiClass)parent2);
                }
            }
            if (PsiTypes.nullType().equals(qualifierType)) {
                LOG.error("Unexpected null qualifier", new Attachment("expression.txt", call2.getText()));
            }
            return PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true);
        }
        return null;
    }

    public static boolean isGetClass(@NotNull PsiMethod method) {
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(11);
        }
        if ("getClass".equals(method.getName())) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "java.lang.Object".equals(aClass.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@NotNull PsiElement context, @Nullable PsiType qualifierType, boolean captureTopLevelWildcards) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(12);
        }
        if (qualifierType != null) {
            PsiUtil.ensureValidType(qualifierType);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(context.getProject());
            PsiClass javaLangClass = facade.findClass("java.lang.Class", context.getResolveScope());
            if (javaLangClass != null && javaLangClass.getTypeParameters().length == 1) {
                PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(context.getManager(), qualifierType));
                PsiClassType classType = facade.getElementFactory().createType(javaLangClass, substitutor2, PsiUtil.getLanguageLevel(context));
                return captureTopLevelWildcards ? PsiUtil.captureToplevelWildcards(classType, context) : classType;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getExpectedTypeByParent(@NotNull PsiElement element) {
        PsiElement parent2;
        if (element == null) {
            PsiTypesUtil.$$$reportNull$$$0(13);
        }
        if ((parent2 = PsiUtil.skipParenthesizedExprUp(element.getParent())) instanceof PsiVariable) {
            if (PsiUtil.checkSameExpression(element, ((PsiVariable)parent2).getInitializer())) {
                PsiTypeElement typeElement = ((PsiVariable)parent2).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return null;
                }
                return ((PsiVariable)parent2).getType();
            }
        } else if (parent2 instanceof PsiAssignmentExpression) {
            if (((PsiAssignmentExpression)parent2).getOperationSign().getTokenType() == JavaTokenType.EQ && PsiUtil.checkSameExpression(element, ((PsiAssignmentExpression)parent2).getRExpression())) {
                PsiType type2 = ((PsiAssignmentExpression)parent2).getLExpression().getType();
                return !PsiTypes.nullType().equals(type2) ? type2 : null;
            }
        } else if (parent2 instanceof PsiReturnStatement) {
            Object psiElement = PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, PsiMethod.class);
            if (psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else {
            if (PsiUtil.isCondition(element, parent2)) {
                return PsiTypes.booleanType();
            }
            if (parent2 instanceof PsiArrayInitializerExpression) {
                PsiElement gParent = parent2.getParent();
                if (gParent instanceof PsiNewExpression) {
                    PsiType type3 = ((PsiNewExpression)gParent).getType();
                    if (type3 instanceof PsiArrayType) {
                        return ((PsiArrayType)type3).getComponentType();
                    }
                } else if (gParent instanceof PsiVariable) {
                    PsiType type4 = ((PsiVariable)gParent).getType();
                    if (type4 instanceof PsiArrayType) {
                        return ((PsiArrayType)type4).getComponentType();
                    }
                } else if (gParent instanceof PsiArrayInitializerExpression) {
                    PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(parent2);
                    return expectedTypeByParent instanceof PsiArrayType ? ((PsiArrayType)expectedTypeByParent).getComponentType() : null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getMethodReturnType(@NotNull PsiElement element) {
        Object methodOrLambda;
        if (element == null) {
            PsiTypesUtil.$$$reportNull$$$0(14);
        }
        return (methodOrLambda = PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiLambdaExpression.class)) instanceof PsiMethod ? ((PsiMethod)methodOrLambda).getReturnType() : (methodOrLambda instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)methodOrLambda) : null);
    }

    public static boolean compareTypes(PsiType leftType, PsiType rightType, boolean ignoreEllipsis) {
        if (ignoreEllipsis) {
            if (leftType instanceof PsiEllipsisType) {
                leftType = ((PsiEllipsisType)leftType).toArrayType();
            }
            if (rightType instanceof PsiEllipsisType) {
                rightType = ((PsiEllipsisType)rightType).toArrayType();
            }
        }
        return Comparing.equal(leftType, rightType);
    }

    public static boolean isDenotableType(@Nullable PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(15);
        }
        if (type2 == null || type2 instanceof PsiWildcardType) {
            return false;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(context.getProject());
        try {
            PsiType typeAfterReplacement = elementFactory.createTypeElementFromText(type2.getCanonicalText(), context).getType();
            return type2.equals(typeAfterReplacement);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public static boolean hasTypeAnnotation(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(16);
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return type2.getAnnotations().length > 0;
            }

            @Override
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                if (classType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (((Boolean)super.visitClassType(classType)).booleanValue()) {
                    return true;
                }
                for (PsiType t1 : classType.getParameters()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (Boolean)super.visitArrayType(arrayType) != false || arrayType.getComponentType().accept(this) != false;
            }

            @Override
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                if (wildcardType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return (Boolean)super.visitWildcardType(wildcardType) != false || wildcardType.getBound() != null && wildcardType.getBound().accept(this) != false;
            }

            @Override
            public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                if (intersectionType == null) {
                    1.$$$reportNull$$$0(4);
                }
                for (PsiType t1 : intersectionType.getConjuncts()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
                if (disjunctionType == null) {
                    1.$$$reportNull$$$0(5);
                }
                for (PsiType t1 : disjunctionType.getDisjunctions()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intersectionType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "disjunctionType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIntersectionType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDisjunctionType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean hasUnresolvedComponents(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(17);
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiClass psiClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((psiClass = (resolveResult = classType.resolveGenerics()).getElement()) == null) {
                    return true;
                }
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                for (PsiTypeParameter param : PsiUtil.typeParametersIterable(psiClass)) {
                    PsiType psiType = substitutor2.substitute(param);
                    if (psiType == null || !psiType.accept(this).booleanValue()) continue;
                    return true;
                }
                return (Boolean)super.visitClassType(classType);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    2.$$$reportNull$$$0(1);
                }
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @NotNull
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    2.$$$reportNull$$$0(2);
                }
                Boolean bl = (bound = wildcardType.getBound()) != null && bound.accept(this) != false;
                if (bl == null) {
                    2.$$$reportNull$$$0(3);
                }
                return bl;
            }

            @Override
            public Boolean visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitWildcardType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitClassType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitArrayType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitWildcardType";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitType";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    public static PsiType getParameterType(PsiParameter @NotNull [] parameters, int i, boolean varargs) {
        PsiParameter parameter;
        PsiType parameterType;
        if (parameters == null) {
            PsiTypesUtil.$$$reportNull$$$0(18);
        }
        if ((parameterType = (parameter = parameters[i < parameters.length ? i : parameters.length - 1]).getType()) instanceof PsiEllipsisType) {
            parameterType = varargs ? ((PsiEllipsisType)parameterType).getComponentType() : ((PsiEllipsisType)parameterType).toArrayType();
        }
        if (!parameterType.isValid()) {
            PsiUtil.ensureValidType(parameterType, "Invalid type of parameter " + parameter + " of " + parameter.getClass());
        }
        PsiType psiType = parameterType;
        if (psiType == null) {
            PsiTypesUtil.$$$reportNull$$$0(19);
        }
        return psiType;
    }

    public static PsiTypeParameter @NotNull [] filterUnusedTypeParameters(PsiTypeParameter @NotNull [] typeParameters2, PsiType ... types2) {
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(20);
        }
        if (types2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(21);
        }
        if (typeParameters2.length == 0) {
            if (PsiTypeParameter.EMPTY_ARRAY == null) {
                PsiTypesUtil.$$$reportNull$$$0(22);
            }
            return PsiTypeParameter.EMPTY_ARRAY;
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        for (PsiType type2 : types2) {
            type2.accept(searcher);
        }
        PsiTypeParameter[] psiTypeParameterArray = searcher.getTypeParameters().toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiTypesUtil.$$$reportNull$$$0(23);
        }
        return psiTypeParameterArray;
    }

    public static PsiTypeParameter @NotNull [] filterUnusedTypeParameters(@NotNull PsiType superReturnTypeInBaseClassType, PsiTypeParameter @NotNull [] typeParameters2) {
        if (superReturnTypeInBaseClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(24);
        }
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(25);
        }
        return PsiTypesUtil.filterUnusedTypeParameters(typeParameters2, superReturnTypeInBaseClassType);
    }

    private static boolean isAccessibleAt(@NotNull PsiTypeParameter parameter, @NotNull PsiElement context) {
        PsiTypeParameterListOwner owner;
        if (parameter == null) {
            PsiTypesUtil.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(27);
        }
        if ((owner = parameter.getOwner()) instanceof PsiMethod) {
            return PsiTreeUtil.isAncestor(owner, context, false);
        }
        if (owner instanceof PsiClass) {
            return PsiTreeUtil.isAncestor(owner, context, false) && InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)owner, context, false, false);
        }
        return false;
    }

    public static boolean allTypeParametersResolved(@NotNull PsiElement context, @NotNull PsiType targetType) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(28);
        }
        if (targetType == null) {
            PsiTypesUtil.$$$reportNull$$$0(29);
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        targetType.accept(searcher);
        Set<PsiTypeParameter> parameters = searcher.getTypeParameters();
        return ContainerUtil.and(parameters, parameter -> PsiTypesUtil.isAccessibleAt(parameter, context));
    }

    @NotNull
    public static PsiType createArrayType(@NotNull PsiType newType, int arrayDim) {
        if (newType == null) {
            PsiTypesUtil.$$$reportNull$$$0(30);
        }
        for (int i = 0; i < arrayDim; ++i) {
            newType = newType.createArrayType();
        }
        PsiType psiType = newType;
        if (psiType == null) {
            PsiTypesUtil.$$$reportNull$$$0(31);
        }
        return psiType;
    }

    @Nullable
    public static PsiTypeElement replaceWithExplicitType(PsiTypeElement typeElement) {
        PsiType type2 = typeElement.getType();
        if (!PsiTypesUtil.isDenotableType(type2, typeElement)) {
            return null;
        }
        Project project = typeElement.getProject();
        PsiTypeElement typeElementByExplicitType = JavaPsiFacade.getElementFactory(project).createTypeElement(type2);
        PsiElement explicitTypeElement = typeElement.replace(typeElementByExplicitType);
        explicitTypeElement = JavaCodeStyleManager.getInstance(project).shortenClassReferences(explicitTypeElement);
        return (PsiTypeElement)CodeStyleManager.getInstance(project).reformat(explicitTypeElement);
    }

    public static PsiType getTypeByMethod(@NotNull PsiElement context, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor2, boolean inferParent) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(32);
        }
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length && !inferParent) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            PsiType parameterType = substitutor2 != null ? substitutor2.substitute(PsiTypesUtil.getParameterType(parameters, i, varargs)) : null;
            boolean isRaw = substitutor2 != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor2);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public static boolean mentionsTypeParameters(@Nullable PsiType type2, @NotNull Set<? extends PsiTypeParameter> typeParameters2) {
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(33);
        }
        return PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(type2, typeParameters2::contains);
    }

    public static boolean mentionsTypeParameters(@Nullable PsiType type2, @NotNull Predicate<? super PsiTypeParameter> wantedTypeParameter) {
        if (wantedTypeParameter == null) {
            PsiTypesUtil.$$$reportNull$$$0(34);
        }
        return PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(type2, wantedTypeParameter);
    }

    public static boolean isUncheckedCall(JavaResolveResult resolveResult) {
        PsiSubstitutor substitutor2;
        PsiMethod method;
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && PsiUtil.isRawSubstitutor(method = (PsiMethod)element, substitutor2 = resolveResult.getSubstitutor())) {
            for (PsiParameter t : method.getParameterList().getParameters()) {
                PsiClass aClass;
                PsiType type2 = t.getType().getDeepComponentType();
                if (!(type2 instanceof PsiClassType) || !((aClass = ((PsiClassType)type2).resolveGenerics().getElement()) instanceof PsiTypeParameter) && (aClass == null || !PsiUtil.typeParametersIterator(aClass).hasNext() || ((PsiClassType)type2).isRaw())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean mentionsTypeParametersOrUnboundedWildcard(@Nullable PsiType type2, final Predicate<? super PsiTypeParameter> wantedTypeParameter) {
        if (type2 == null) {
            return false;
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    3.$$$reportNull$$$0(1);
                }
                return (bound = wildcardType.getBound()) != null ? bound.accept(this) : Boolean.valueOf(false);
            }

            @Override
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                PsiClassType.ClassResolveResult result2;
                PsiClass psiClass;
                if (classType == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((psiClass = (result2 = classType.resolveGenerics()).getElement()) != null) {
                    PsiSubstitutor substitutor2 = result2.getSubstitutor();
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(psiClass)) {
                        PsiType type2 = substitutor2.substitute(parameter);
                        if (type2 == null || !type2.accept(this).booleanValue()) continue;
                        return true;
                    }
                }
                return psiClass instanceof PsiTypeParameter && wantedTypeParameter.test((PsiTypeParameter)psiClass);
            }

            @Override
            public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                if (intersectionType == null) {
                    3.$$$reportNull$$$0(3);
                }
                for (PsiType conjunct : intersectionType.getConjuncts()) {
                    if (!conjunct.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitMethodReferenceType(@NotNull PsiMethodReferenceType methodReferenceType) {
                if (methodReferenceType == null) {
                    3.$$$reportNull$$$0(4);
                }
                return false;
            }

            @Override
            public Boolean visitLambdaExpressionType(@NotNull PsiLambdaExpressionType lambdaExpressionType) {
                if (lambdaExpressionType == null) {
                    3.$$$reportNull$$$0(5);
                }
                return false;
            }

            @Override
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    3.$$$reportNull$$$0(6);
                }
                return arrayType.getComponentType().accept(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intersectionType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodReferenceType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lambdaExpressionType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIntersectionType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpressionType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Contract(value="null, _ -> false")
    public static boolean classNameEquals(@Nullable PsiType type2, @NotNull String qualifiedClassName) {
        if (qualifiedClassName == null) {
            PsiTypesUtil.$$$reportNull$$$0(35);
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type2;
        String className = classType.getClassName();
        if (className == null || !qualifiedClassName.endsWith(className)) {
            return false;
        }
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return false;
        }
        return qualifiedClassName.equals(psiClass.getQualifiedName());
    }

    @NotNull
    public static List<? extends PsiClassType> getClassTypeComponents(PsiType type2) {
        if (type2 instanceof PsiClassType) {
            List<PsiClassType> list = Collections.singletonList((PsiClassType)type2);
            if (list == null) {
                PsiTypesUtil.$$$reportNull$$$0(36);
            }
            return list;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return PsiTypesUtil.getClassTypeComponents(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        if (type2 instanceof PsiIntersectionType) {
            ArrayList<? extends PsiClassType> classTypes = new ArrayList<PsiClassType>();
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                classTypes.addAll(PsiTypesUtil.getClassTypeComponents(conjunct));
            }
            ArrayList<? extends PsiClassType> arrayList = classTypes;
            if (arrayList == null) {
                PsiTypesUtil.$$$reportNull$$$0(37);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PsiTypesUtil.$$$reportNull$$$0(38);
        }
        return list;
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 12: 
            case 15: 
            case 27: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 20: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReturnTypeInBaseClassType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wantedTypeParameter";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueOfType";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnusedTypeParameters";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypeComponents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLowestUpperBoundClassType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchMethodGetClassReturnType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGetClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createJavaLangClassType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeByParent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReturnType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDenotableType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedComponents";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterUnusedTypeParameters";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleAt";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "allTypeParametersResolved";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByMethod";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mentionsTypeParameters";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "classNameEquals";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeParameterSearcher
    extends PsiTypeVisitor<Boolean> {
        private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

        @NotNull
        public Set<PsiTypeParameter> getTypeParameters() {
            Set<PsiTypeParameter> set = this.myTypeParams;
            if (set == null) {
                TypeParameterSearcher.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        public Boolean visitType(@NotNull PsiType type2) {
            if (type2 == null) {
                TypeParameterSearcher.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
            if (arrayType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(2);
            }
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (classType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(3);
            }
            if ((aClass = (resolveResult = classType.resolveGenerics()).getElement()) instanceof PsiTypeParameter) {
                this.myTypeParams.add((PsiTypeParameter)aClass);
            }
            if (aClass != null) {
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType psiType = substitutor2.substitute(parameter);
                    if (psiType == null) continue;
                    psiType.accept(this);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
            PsiType bound;
            if (wildcardType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(4);
            }
            if ((bound = wildcardType.getBound()) != null) {
                bound.accept(this);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil$TypeParameterSearcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wildcardType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeParameters";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiTypesUtil$TypeParameterSearcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayType";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassType";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWildcardType";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

