/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.JvmFileFacadeClassKt;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializerImpl;
import org.jetbrains.kotlin.backend.jvm.JvmIrSpecialAnnotationSymbolProvider;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.DescriptorSymbolTableExtension;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.sam.JavaSingleAbstractMethodUtils;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.descriptors.IrExpressionBuildersKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0002DEB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u001aH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0016\u001a\u00020/H\u0016J\"\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u0010\u0016\u001a\u00020/2\u0006\u00104\u001a\u000205H\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u000209H\u0016J\b\u0010;\u001a\u000209H\u0016J\b\u0010<\u001a\u000209H\u0016J \u0010=\u001a\u0012\u0012\u0004\u0012\u00020?\u0012\u0006\u0012\u0004\u0018\u00010?\u0018\u00010>2\u0006\u0010\u0016\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u00106\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u000bR\u0014\u0010@\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u000bR\u0014\u0010B\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u000b\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "generateFacades", "", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Z)V", "irDeserializationEnabled", "getIrDeserializationEnabled", "()Z", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getCachedFields", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "samConversion", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "getSamConversion", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "getContainerSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "computeFieldVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "computeExternalDeclarationOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "generateFacadeClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "deserializedSource", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "deserializeClass", "irClass", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "isPropertyWithPlatformField", "enhancedNullability", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "getEnhancedNullability", "()Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "getParentClassStaticScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createCustomSuperConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "ktPureClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "shouldPreventDeprecatedIntegerValueTypeLiteralConversion", "getShouldPreventDeprecatedIntegerValueTypeLiteralConversion", "generateFlexibleNullabilityAnnotationCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "generateFlexibleMutabilityAnnotationCall", "generateEnhancedNullabilityAnnotationCall", "generateRawTypeAnnotationCall", "unwrapSyntheticJavaProperty", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parametersAreAssignable", "getParametersAreAssignable", "debugInfoOnlyOnVariablesInDestructuringDeclarations", "getDebugInfoOnlyOnVariablesInDestructuringDeclarations", "JvmSamConversion", "JvmEnhancedNullability", "backend.jvm.entrypoint"})
public class JvmGeneratorExtensionsImpl
extends GeneratorExtensions
implements JvmGeneratorExtensions {
    @NotNull
    private final CompilerConfiguration configuration;
    private final boolean generateFacades;
    private final boolean irDeserializationEnabled;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;
    @NotNull
    private final GeneratorExtensions.SamConversion samConversion;

    public JvmGeneratorExtensionsImpl(@NotNull CompilerConfiguration configuration, boolean generateFacades) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.generateFacades = generateFacades;
        this.irDeserializationEnabled = this.configuration.get(JVMConfigurationKeys.SERIALIZE_IR) != JvmSerializeIrMode.NONE;
        this.cachedFields = new CachedFieldsForObjectInstances(IrFactoryImpl.INSTANCE, CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration));
        this.samConversion = new JvmSamConversion();
    }

    public /* synthetic */ JvmGeneratorExtensionsImpl(CompilerConfiguration compilerConfiguration, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(compilerConfiguration, bl);
    }

    @Override
    public boolean getIrDeserializationEnabled() {
        return this.irDeserializationEnabled;
    }

    @Override
    @NotNull
    public CachedFieldsForObjectInstances getCachedFields() {
        return this.cachedFields;
    }

    @Override
    @NotNull
    public GeneratorExtensions.SamConversion getSamConversion() {
        return this.samConversion;
    }

    @Override
    @Nullable
    public DeserializedContainerSource getContainerSource(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        DescriptorWithContainerSource descriptorWithContainerSource = descriptor instanceof DescriptorWithContainerSource ? (DescriptorWithContainerSource)descriptor : null;
        return descriptorWithContainerSource != null ? descriptorWithContainerSource.getContainerSource() : null;
    }

    @Override
    @Nullable
    public DescriptorVisibility computeFieldVisibility(@NotNull PropertyDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor) || descriptor instanceof JavaCallableMemberDescriptor ? descriptor.getVisibility() : null;
    }

    @Override
    @Nullable
    public IrDeclarationOrigin computeExternalDeclarationOrigin(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return descriptor instanceof JavaCallableMemberDescriptor || descriptor instanceof JavaClassDescriptor ? (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB() : (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getIR_EXTERNAL_DECLARATION_STUB();
    }

    @Override
    @Nullable
    public IrClass generateFacadeClass(@NotNull IrFactory irFactory, @NotNull DeserializedContainerSource deserializedSource, @NotNull DeclarationStubGenerator stubGenerator) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)deserializedSource, (String)"deserializedSource");
        Intrinsics.checkNotNullParameter((Object)stubGenerator, (String)"stubGenerator");
        if (!this.generateFacades || !(deserializedSource instanceof FacadeClassSource)) {
            return null;
        }
        JvmClassName jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName();
        if (jvmClassName == null) {
            jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getClassName();
        }
        JvmClassName facadeName = jvmClassName;
        IrClass it = irClass = JvmFileFacadeClassKt.createJvmFileFacadeClass(((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName() != null ? IrDeclarationOrigin.Companion.getJVM_MULTIFILE_CLASS() : IrDeclarationOrigin.Companion.getFILE_CLASS(), facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName(), deserializedSource, (Function1<? super IrClass, Boolean>)((Function1)arg_0 -> JvmGeneratorExtensionsImpl.generateFacadeClass$lambda$0(this, stubGenerator, arg_0)));
        boolean bl = false;
        IrUtilsKt.createThisReceiverParameter(it);
        JvmIrAttributesKt.setClassNameOverride(it, facadeName);
        return irClass;
    }

    @Override
    public boolean deserializeClass(@NotNull IrClass irClass, @NotNull DeclarationStubGenerator stubGenerator, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)stubGenerator, (String)"stubGenerator");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        return new JvmIrDeserializerImpl().deserializeTopLevelClass(irClass, stubGenerator.getIrBuiltIns(), stubGenerator.getSymbolTable(), CollectionsKt.listOf((Object)stubGenerator), this);
    }

    @Override
    public boolean isPropertyWithPlatformField(@NotNull PropertyDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor);
    }

    @Override
    @NotNull
    public StubGeneratorExtensions.EnhancedNullability getEnhancedNullability() {
        return JvmEnhancedNullability.Instance;
    }

    @Override
    @Nullable
    public MemberScope getParentClassStaticScope(@NotNull ClassDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return UtilKt.getParentJavaStaticClassScope(descriptor);
    }

    @Override
    @Nullable
    public IrDelegatingConstructorCall createCustomSuperConstructorCall(@NotNull KtPureClassOrObject ktPureClassOrObject, @NotNull ClassDescriptor descriptor, @NotNull GeneratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)ktPureClassOrObject, (String)"ktPureClassOrObject");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!JvmAnnotationUtilKt.isJvmRecord(descriptor)) {
            return null;
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.resolveTopLevelClass(DescriptorUtilsKt.getModule(descriptor), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FROM_BACKEND);
        if (classDescriptor == null) {
            throw new IllegalStateException(("Class not found: " + JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME()).toString());
        }
        ClassDescriptor recordClass = classDescriptor;
        Collection<ClassConstructorDescriptor> collection = recordClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getConstructors(...)");
        ClassConstructorDescriptor recordConstructor = (ClassConstructorDescriptor)CollectionsKt.single((Iterable)collection);
        int n2 = PsiUtilsKt.getPureStartOffset(ktPureClassOrObject);
        int n3 = PsiUtilsKt.getPureEndOffset(ktPureClassOrObject);
        IrType irType = context2.getIrBuiltIns().getUnitType();
        DescriptorSymbolTableExtension descriptorSymbolTableExtension = context2.getSymbolTable().getDescriptorExtension();
        Intrinsics.checkNotNull((Object)recordConstructor);
        return IrExpressionBuildersKt.fromSymbolDescriptor(IrDelegatingConstructorCallImpl.Companion, n2, n3, irType, descriptorSymbolTableExtension.referenceConstructor(recordConstructor));
    }

    @Override
    public boolean getShouldPreventDeprecatedIntegerValueTypeLiteralConversion() {
        return true;
    }

    @Override
    @NotNull
    public IrConstructorCall generateFlexibleNullabilityAnnotationCall() {
        return JvmIrSpecialAnnotationSymbolProvider.INSTANCE.generateFlexibleNullabilityAnnotationCall();
    }

    @Override
    @NotNull
    public IrConstructorCall generateFlexibleMutabilityAnnotationCall() {
        return JvmIrSpecialAnnotationSymbolProvider.INSTANCE.generateFlexibleMutabilityAnnotationCall();
    }

    @Override
    @NotNull
    public IrConstructorCall generateEnhancedNullabilityAnnotationCall() {
        return JvmIrSpecialAnnotationSymbolProvider.INSTANCE.generateEnhancedNullabilityAnnotationCall();
    }

    @Override
    @NotNull
    public IrConstructorCall generateRawTypeAnnotationCall() {
        return JvmIrSpecialAnnotationSymbolProvider.INSTANCE.generateRawTypeAnnotationCall();
    }

    @Override
    @Nullable
    public Pair<FunctionDescriptor, FunctionDescriptor> unwrapSyntheticJavaProperty(@NotNull PropertyDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor instanceof SyntheticJavaPropertyDescriptor) {
            return TuplesKt.to((Object)((SyntheticJavaPropertyDescriptor)descriptor).getGetMethod(), (Object)((SyntheticJavaPropertyDescriptor)descriptor).getSetMethod());
        }
        return null;
    }

    @Override
    public boolean getParametersAreAssignable() {
        return true;
    }

    @Override
    public boolean getDebugInfoOnlyOnVariablesInDestructuringDeclarations() {
        return true;
    }

    private static final boolean generateFacadeClass$lambda$0(JvmGeneratorExtensionsImpl this$0, DeclarationStubGenerator $stubGenerator, IrClass facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        return this$0.deserializeClass(facade, $stubGenerator, facade.getParent());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability;", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "<init>", "()V", "hasEnhancedNullability", "", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "stripEnhancedNullability", "Instance", "backend.jvm.entrypoint"})
    public static class JvmEnhancedNullability
    extends StubGeneratorExtensions.EnhancedNullability {
        @NotNull
        public static final Instance Instance = new Instance(null);

        @Override
        public boolean hasEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType);
        }

        @Override
        @NotNull
        public KotlinType stripEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType) ? TypeUtilsKt.replaceAnnotations(kotlinType, new FilteredAnnotations(kotlinType.getAnnotations(), true, (Function1<? super FqName, Boolean>)((Function1)JvmEnhancedNullability::stripEnhancedNullability$lambda$0))) : kotlinType;
        }

        private static final boolean stripEnhancedNullability$lambda$0(FqName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)it, (Object)JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability$Instance;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability;", "<init>", "()V", "backend.jvm.entrypoint"})
        public static final class Instance
        extends JvmEnhancedNullability {
            private Instance() {
            }

            public /* synthetic */ Instance(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmSamConversion;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl;)V", "isPlatformSamType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isCarefulApproximationOfContravariantProjection", "backend.jvm.entrypoint"})
    public final class JvmSamConversion
    extends GeneratorExtensions.SamConversion {
        @Override
        public boolean isPlatformSamType(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return JavaSingleAbstractMethodUtils.isSamType(type);
        }

        @Override
        public boolean isCarefulApproximationOfContravariantProjection() {
            return JvmGeneratorExtensionsImpl.this.configuration.get(JVMConfigurationKeys.SAM_CONVERSIONS) != JvmClosureGenerationScheme.CLASS;
        }
    }
}

