/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.kotlin.io.vavr.Value;
import org.jetbrains.kotlin.io.vavr.collection.AbstractIterator;
import org.jetbrains.kotlin.io.vavr.collection.CharSeq;
import org.jetbrains.kotlin.io.vavr.collection.Comparators;
import org.jetbrains.kotlin.io.vavr.collection.Foldable;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.TraversableModule;
import org.jetbrains.kotlin.io.vavr.control.Option;

public interface Traversable<T>
extends Value<T>,
Foldable<T> {
    default public Option<Double> average() {
        try {
            double[] sum = TraversableModule.neumaierSum(this, t2 -> ((Number)t2).doubleValue());
            double count = sum[1];
            return count == 0.0 ? Option.none() : Option.some(sum[0] / count);
        }
        catch (ClassCastException x2) {
            throw new UnsupportedOperationException("not numeric", x2);
        }
    }

    default public boolean containsAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        for (T element : elements) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    public Traversable<T> filter(Predicate<? super T> var1);

    default public Option<T> find(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (Object a2 : this) {
            if (!predicate.test(a2)) continue;
            return Option.some(a2);
        }
        return Option.none();
    }

    default public <U> U foldLeft(U zero, BiFunction<? super U, ? super T, ? extends U> f2) {
        Objects.requireNonNull(f2, "f is null");
        U xs = zero;
        for (Object x2 : this) {
            xs = f2.apply(xs, x2);
        }
        return xs;
    }

    @Override
    default public T get() {
        return this.head();
    }

    public boolean hasDefiniteSize();

    public T head();

    default public boolean isDistinct() {
        return false;
    }

    @Override
    default public boolean isEmpty() {
        return this.length() == 0;
    }

    default public boolean isOrdered() {
        return false;
    }

    default public boolean isSequential() {
        return false;
    }

    @Override
    default public boolean isSingleValued() {
        return false;
    }

    public boolean isTraversableAgain();

    @Override
    default public Iterator<T> iterator() {
        final Traversable that = this;
        return new AbstractIterator<T>(){
            Traversable<T> traversable;
            {
                this.traversable = that;
            }

            @Override
            public boolean hasNext() {
                return !this.traversable.isEmpty();
            }

            @Override
            public T getNext() {
                Object result2 = this.traversable.head();
                this.traversable = this.traversable.tail();
                return result2;
            }
        };
    }

    public T last();

    public int length();

    default public Option<T> max() {
        return this.maxBy(Comparators.naturalComparator());
    }

    default public Option<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (this.isEmpty()) {
            return Option.none();
        }
        Object value2 = this.reduce((t1, t2) -> comparator.compare(t1, t2) >= 0 ? t1 : t2);
        return Option.some(value2);
    }

    default public CharSeq mkCharSeq() {
        return this.mkCharSeq("", "", "");
    }

    default public CharSeq mkCharSeq(CharSequence delimiter) {
        return this.mkCharSeq("", delimiter, "");
    }

    default public CharSeq mkCharSeq(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return CharSeq.of(this.mkString(prefix, delimiter, suffix));
    }

    default public String mkString() {
        return this.mkString("", "", "");
    }

    default public String mkString(CharSequence delimiter) {
        return this.mkString("", delimiter, "");
    }

    default public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        StringBuilder builder = new StringBuilder(prefix);
        this.iterator().map(String::valueOf).intersperse(String.valueOf(delimiter)).forEach(builder::append);
        return builder.append(suffix).toString();
    }

    default public boolean nonEmpty() {
        return !this.isEmpty();
    }

    default public Number product() {
        if (this.isEmpty()) {
            return 1;
        }
        try {
            java.util.Iterator iter = this.iterator();
            Object o2 = iter.next();
            if (o2 instanceof Integer || o2 instanceof Long || o2 instanceof Byte || o2 instanceof Short) {
                return iter.foldLeft(((Number)o2).longValue(), (product, number) -> product * number.longValue());
            }
            if (o2 instanceof BigInteger) {
                return iter.foldLeft((BigInteger)o2, BigInteger::multiply);
            }
            if (o2 instanceof BigDecimal) {
                return iter.foldLeft((BigDecimal)o2, BigDecimal::multiply);
            }
            return iter.toJavaStream().mapToDouble(Number::doubleValue).reduce(((Number)o2).doubleValue(), (d1, d2) -> d1 * d2);
        }
        catch (ClassCastException x2) {
            throw new UnsupportedOperationException("not numeric", x2);
        }
    }

    @Override
    default public T reduceLeft(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        return this.iterator().reduceLeft(op);
    }

    default public int size() {
        return this.length();
    }

    @Override
    default public Spliterator<T> spliterator() {
        int characteristics = 1024;
        if (this.isDistinct()) {
            characteristics |= 1;
        }
        if (this.isOrdered()) {
            characteristics |= 0x14;
        }
        if (this.isSequential()) {
            characteristics |= 0x10;
        }
        if (this.hasDefiniteSize()) {
            return Spliterators.spliterator(this.iterator(), (long)this.length(), characteristics |= 0x4040);
        }
        return Spliterators.spliteratorUnknownSize(this.iterator(), characteristics);
    }

    default public Number sum() {
        if (this.isEmpty()) {
            return 0;
        }
        try {
            java.util.Iterator iter = this.iterator();
            Object o2 = iter.next();
            if (o2 instanceof Integer || o2 instanceof Long || o2 instanceof Byte || o2 instanceof Short) {
                return iter.foldLeft(((Number)o2).longValue(), (sum, number) -> sum + number.longValue());
            }
            if (o2 instanceof BigInteger) {
                return iter.foldLeft((BigInteger)o2, BigInteger::add);
            }
            if (o2 instanceof BigDecimal) {
                return iter.foldLeft((BigDecimal)o2, BigDecimal::add);
            }
            return TraversableModule.neumaierSum(Iterator.of(o2).concat(iter), t2 -> ((Number)t2).doubleValue())[0];
        }
        catch (ClassCastException x2) {
            throw new UnsupportedOperationException("not numeric", x2);
        }
    }

    public Traversable<T> tail();
}

