/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0013\u001a\u00020\u0010H\u0096\u0080\u0004J\u0006\u0010\u0014\u001a\u00020\u0005J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/ImportPath;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "isAllUnder", "", "alias", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;ZLorg/jetbrains/kotlin/name/Name;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "()Z", "getAlias", "()Lorg/jetbrains/kotlin/name/Name;", "pathStr", "", "getPathStr", "()Ljava/lang/String;", "toString", "hasAlias", "importedName", "getImportedName", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "Companion", "frontend.common"})
public final class ImportPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName fqName;
    private final boolean isAllUnder;
    @Nullable
    private final Name alias;

    @JvmOverloads
    public ImportPath(@NotNull FqName fqName, boolean isAllUnder, @Nullable Name alias) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        this.fqName = fqName;
        this.isAllUnder = isAllUnder;
        this.alias = alias;
    }

    public /* synthetic */ ImportPath(FqName fqName, boolean bl, Name name2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            name2 = null;
        }
        this(fqName, bl, name2);
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    public final boolean isAllUnder() {
        return this.isAllUnder;
    }

    @Nullable
    public final Name getAlias() {
        return this.alias;
    }

    @NotNull
    public final String getPathStr() {
        return RenderingUtilsKt.render(this.fqName.toUnsafe()) + (this.isAllUnder ? ".*" : "");
    }

    @NotNull
    public String toString() {
        return this.getPathStr() + (this.alias != null ? " as " + this.alias.asString() : "");
    }

    public final boolean hasAlias() {
        return this.alias != null;
    }

    @Nullable
    public final Name getImportedName() {
        if (!this.isAllUnder) {
            Name name2 = this.alias;
            if (name2 == null) {
                name2 = this.fqName.shortName();
            }
            return name2;
        }
        return null;
    }

    @NotNull
    public final FqName component1() {
        return this.fqName;
    }

    public final boolean component2() {
        return this.isAllUnder;
    }

    @Nullable
    public final Name component3() {
        return this.alias;
    }

    @NotNull
    public final ImportPath copy(@NotNull FqName fqName, boolean isAllUnder, @Nullable Name alias) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return new ImportPath(fqName, isAllUnder, alias);
    }

    public static /* synthetic */ ImportPath copy$default(ImportPath importPath, FqName fqName, boolean bl, Name name2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            fqName = importPath.fqName;
        }
        if ((n2 & 2) != 0) {
            bl = importPath.isAllUnder;
        }
        if ((n2 & 4) != 0) {
            name2 = importPath.alias;
        }
        return importPath.copy(fqName, bl, name2);
    }

    public int hashCode() {
        int result2 = this.fqName.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isAllUnder);
        result2 = result2 * 31 + (this.alias == null ? 0 : this.alias.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImportPath)) {
            return false;
        }
        ImportPath importPath = (ImportPath)other;
        if (!Intrinsics.areEqual((Object)this.fqName, (Object)importPath.fqName)) {
            return false;
        }
        if (this.isAllUnder != importPath.isAllUnder) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.alias, (Object)importPath.alias);
    }

    @JvmOverloads
    public ImportPath(@NotNull FqName fqName, boolean isAllUnder) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        this(fqName, isAllUnder, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final ImportPath fromString(@NotNull String pathStr) {
        return Companion.fromString(pathStr);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/ImportPath$Companion;", "", "<init>", "()V", "fromString", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "pathStr", "", "frontend.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ImportPath fromString(@NotNull String pathStr) {
            ImportPath importPath;
            Intrinsics.checkNotNullParameter((Object)pathStr, (String)"pathStr");
            if (StringsKt.endsWith$default((String)pathStr, (String)".*", (boolean)false, (int)2, null)) {
                String string = pathStr.substring(0, pathStr.length() - 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                importPath = new ImportPath(new FqName(string), true, null, 4, null);
            } else {
                importPath = new ImportPath(new FqName(pathStr), false, null, 4, null);
            }
            return importPath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

