/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stub;

import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStubImplUtil {
    public static int getMethodStubIndex(PsiMethod method) {
        if (!(method instanceof PsiMethodImpl)) {
            return -1;
        }
        PsiFileImpl file2 = (PsiFileImpl)method.getContainingFile();
        StubbedSpine spine = file2.getStubbedSpine();
        int result2 = 0;
        for (int i = 0; i < spine.getStubCount(); ++i) {
            if (spine.getStubType(i) != JavaElementType.METHOD) continue;
            if (spine.getStubPsi(i) == method) {
                return result2;
            }
            ++result2;
        }
        return -1;
    }

    public static <T extends PsiMember & PsiJavaDocumentedElement> boolean isMemberDeprecated(@NotNull T member, @Nullable PsiMemberStub<?> stub) {
        if (member == null) {
            JavaStubImplUtil.$$$reportNull$$$0(0);
        }
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(member);
        }
        return PsiImplUtil.isDeprecatedByDocTag(member) || PsiImplUtil.isDeprecatedByAnnotation(member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/stub/JavaStubImplUtil", "isMemberDeprecated"));
    }
}

