/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.js;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedFieldDescriptor;
import org.jetbrains.kotlin.backend.common.ir.DeclarationFactory;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0007H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/js/JsDeclarationFactory;", "Lorg/jetbrains/kotlin/backend/common/ir/DeclarationFactory;", "()V", "innerClassConstructors", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "outerThisFieldSymbols", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "singletonFieldDescriptors", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "createObjectInstanceFieldDescriptor", "singleton", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createPropertyWithBackingField", "name", "Lorg/jetbrains/kotlin/name/Name;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "parent", "fieldType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getFieldForEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "entryType", "getFieldForObjectInstance", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getOuterThisField", "innerClass", "backend.js"})
public final class JsDeclarationFactory
implements DeclarationFactory {
    private final HashMap<IrClass, IrField> singletonFieldDescriptors = new HashMap();
    private final HashMap<IrClass, IrField> outerThisFieldSymbols = new HashMap();
    private final HashMap<IrConstructor, IrConstructor> innerClassConstructors = new HashMap();

    @Override
    @NotNull
    public IrField getFieldForEnumEntry(@NotNull IrEnumEntry enumEntry, @NotNull IrType entryType) {
        Intrinsics.checkParameterIsNotNull((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkParameterIsNotNull((Object)entryType, (String)"entryType");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            throw (Throwable)((Object)new AssertionError((Object)("Class is not inner: " + DumpIrTreeKt.dump(innerClass))));
        }
        Map $this$getOrPut$iv = this.outerThisFieldSymbols;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(innerClass);
        if (value$iv == null) {
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = innerClass.getParent();
            if (!(irDeclarationParent instanceof IrClass)) {
                irDeclarationParent = null;
            }
            IrClass irClass = (IrClass)irDeclarationParent;
            if (irClass == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No containing class for inner class " + DumpIrTreeKt.dump(innerClass))));
            }
            IrClass outerClass2 = irClass;
            Name name = Name.identifier("$this");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"\\$this\")");
            Name name2 = name;
            IrSimpleType fieldType = IrUtilsKt.getDefaultType(outerClass2);
            Visibility visibility = Visibilities.PROTECTED;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PROTECTED");
            Visibility visibility2 = visibility;
            IrField answer$iv = this.createPropertyWithBackingField(name2, visibility2, innerClass, fieldType, DeclarationFactory.FIELD_FOR_OUTER_THIS.INSTANCE);
            $this$getOrPut$iv.put(innerClass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IrField)object;
    }

    private final IrField createPropertyWithBackingField(Name name, Visibility visibility, IrClass parent2, IrType fieldType, IrDeclarationOrigin origin) {
        WrappedFieldDescriptor descriptor2 = new WrappedFieldDescriptor(null, null, 3, null);
        IrFieldSymbolImpl symbol2 = new IrFieldSymbolImpl(descriptor2);
        IrFieldImpl irFieldImpl = new IrFieldImpl(-1, -1, origin, symbol2, name, fieldType, visibility, true, false, false);
        boolean bl = false;
        boolean bl2 = false;
        IrFieldImpl it = irFieldImpl;
        boolean bl3 = false;
        descriptor2.bind((IrDeclaration)it);
        it.setParent(parent2);
        return irFieldImpl;
    }

    @Override
    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        if (irDeclarationParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JsDeclarationFactory$getInnerClassConstructorWithOuterThisParameter$22 = false;
            String $i$a$-assert-JsDeclarationFactory$getInnerClassConstructorWithOuterThisParameter$22 = "Class is not inner: " + innerClass;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JsDeclarationFactory$getInnerClassConstructorWithOuterThisParameter$22));
        }
        Map $this$getOrPut$iv = this.innerClassConstructors;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(innerClassConstructor);
        if (value$iv == null) {
            boolean bl3 = false;
            IrConstructor answer$iv = this.createInnerClassConstructorWithOuterThisParameter(innerClassConstructor);
            $this$getOrPut$iv.put(innerClassConstructor, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IrConstructor)object;
    }

    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        IrDeclarationParent irDeclarationParent = oldConstructor.getParent();
        if (irDeclarationParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass irClass = (IrClass)irDeclarationParent;
        IrDeclarationParent irDeclarationParent2 = irClass.getParent();
        if (irDeclarationParent2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrSimpleType outerThisType = IrUtilsKt.getDefaultType((IrClass)irDeclarationParent2);
        Annotations annotations2 = oldConstructor.getDescriptor().getAnnotations();
        SourceElement sourceElement = oldConstructor.getDescriptor().getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"oldConstructor.descriptor.source");
        WrappedClassConstructorDescriptor descriptor2 = new WrappedClassConstructorDescriptor(annotations2, sourceElement);
        IrConstructorSymbolImpl symbol2 = new IrConstructorSymbolImpl(descriptor2);
        IrConstructorImpl irConstructorImpl = new IrConstructorImpl(oldConstructor.getStartOffset(), oldConstructor.getEndOffset(), oldConstructor.getOrigin(), symbol2, oldConstructor.getName(), oldConstructor.getVisibility(), oldConstructor.getReturnType(), oldConstructor.isInline(), oldConstructor.isExternal(), oldConstructor.isPrimary());
        boolean bl = false;
        boolean bl2 = false;
        IrConstructorImpl it = irConstructorImpl;
        boolean bl3 = false;
        descriptor2.bind((IrDeclaration)it);
        it.setParent(oldConstructor.getParent());
        IrConstructorImpl newConstructor = irConstructorImpl;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default(newConstructor, oldConstructor, null, 2, null);
        IrValueParameter irValueParameter = JsIrBuilder.INSTANCE.buildValueParameter(Namer.INSTANCE.getOUTER_NAME(), 0, outerThisType);
        bl2 = false;
        boolean bl4 = false;
        IrValueParameter it2 = irValueParameter;
        boolean bl5 = false;
        it2.setParent(newConstructor);
        IrValueParameter outerThisValueParameter = irValueParameter;
        List newValueParameters = CollectionsKt.mutableListOf((Object[])new IrValueParameter[]{outerThisValueParameter});
        for (IrValueParameter p : oldConstructor.getValueParameters()) {
            Collection collection = newValueParameters;
            IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(p, newConstructor, null, p.getIndex() + 1, 0, 0, null, null, null, null, false, false, 2042, null);
            boolean bl6 = false;
            collection.add(irValueParameter2);
        }
        Collection collection = newConstructor.getValueParameters();
        boolean bl7 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)newValueParameters);
        return newConstructor;
    }

    @Override
    @NotNull
    public IrField getFieldForObjectInstance(@NotNull IrClass singleton) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)singleton, (String)"singleton");
        Map $this$getOrPut$iv = this.singletonFieldDescriptors;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(singleton);
        if (value$iv == null) {
            boolean bl = false;
            IrField answer$iv = this.createObjectInstanceFieldDescriptor(singleton, JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE);
            $this$getOrPut$iv.put(singleton, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IrField)object;
    }

    private final IrField createObjectInstanceFieldDescriptor(IrClass singleton, IrDeclarationOrigin origin) {
        boolean bl = singleton.getKind() == ClassKind.OBJECT;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Should be an object: " + singleton;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Name name = Name.identifier("INSTANCE");
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"INSTANCE\")");
        Name name2 = name;
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PUBLIC");
        return this.createPropertyWithBackingField(name2, visibility, singleton, IrUtilsKt.getDefaultType(singleton), origin);
    }
}

