/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.openapi.util.Couple;
import com.intellij.serialization.FieldAccessor;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.PropertyAccessor;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PropertyCollector {
    private final ConcurrentMap<Class<?>, List<MutableAccessor>> classToOwnFields = new ConcurrentHashMap();
    private final boolean collectAccessors;
    private final boolean collectPrivateFields;
    private final boolean collectFinalFields;

    public PropertyCollector(byte flags) {
        this.collectAccessors = BitUtil.isSet(flags, (byte)1);
        this.collectPrivateFields = BitUtil.isSet(flags, (byte)2);
        this.collectFinalFields = BitUtil.isSet(flags, (byte)4);
    }

    @NotNull
    public List<MutableAccessor> collect(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PropertyCollector.$$$reportNull$$$0(0);
        }
        ArrayList<MutableAccessor> accessors = new ArrayList<MutableAccessor>();
        Map<Object, Object> nameToAccessors = !this.collectAccessors || aClass == Rectangle.class ? Collections.emptyMap() : this.collectPropertyAccessors(aClass, accessors);
        int propertyAccessorCount = accessors.size();
        this.collectFieldAccessors(aClass, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = ((MutableAccessor)accessors.get(j)).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!((MutableAccessor)accessors.get(i)).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        ArrayList<MutableAccessor> arrayList = accessors;
        if (arrayList == null) {
            PropertyCollector.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private void collectFieldAccessors(@NotNull Class<?> originalClass, @NotNull List<? super MutableAccessor> totalProperties) {
        if (originalClass == null) {
            PropertyCollector.$$$reportNull$$$0(2);
        }
        if (totalProperties == null) {
            PropertyCollector.$$$reportNull$$$0(3);
        }
        Class<?> currentClass = originalClass;
        do {
            ArrayList<FieldAccessor> ownFields;
            if ((ownFields = (ArrayList<FieldAccessor>)this.classToOwnFields.get(currentClass)) != null) {
                if (ownFields.isEmpty()) continue;
                totalProperties.addAll((Collection<? super MutableAccessor>)ownFields);
                continue;
            }
            for (Field field2 : currentClass.getDeclaredFields()) {
                Class<?> fieldType;
                int modifiers2 = field2.getModifiers();
                if (Modifier.isStatic(modifiers2) || Modifier.isTransient(modifiers2) || !this.hasStoreAnnotations(field2) && (!this.collectPrivateFields && !Modifier.isPublic(modifiers2) || !this.collectFinalFields && Modifier.isFinal(modifiers2) && !Collection.class.isAssignableFrom(fieldType = field2.getType()) && !Map.class.isAssignableFrom(fieldType) || this.isAnnotatedAsTransient(field2))) continue;
                if (ownFields == null) {
                    ownFields = new ArrayList<FieldAccessor>();
                }
                ownFields.add(new FieldAccessor(field2));
            }
            this.classToOwnFields.putIfAbsent(currentClass, ContainerUtil.notNullize(ownFields));
            if (ownFields == null) continue;
            totalProperties.addAll((Collection<? super MutableAccessor>)ownFields);
        } while ((currentClass = currentClass.getSuperclass()) != null && !this.isAnnotatedAsTransient(currentClass) && currentClass != Object.class);
    }

    @NotNull
    private Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<? super MutableAccessor> accessors) {
        if (aClass == null) {
            PropertyCollector.$$$reportNull$$$0(4);
        }
        if (accessors == null) {
            PropertyCollector.$$$reportNull$$$0(5);
        }
        TreeMap<String, Couple<Method>> candidates2 = new TreeMap<String, Couple<Method>>();
        for (Method method : aClass.getMethods()) {
            NameAndIsSetter propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = PropertyCollector.getPropertyData(method.getName())) == null || method.getParameterCount() != (propertyData.isSetter ? 1 : 0) || propertyData.name.equals("class")) continue;
            Couple<Object> candidate2 = (Couple)candidates2.get(propertyData.name);
            if (candidate2 == null) {
                candidate2 = Couple.getEmpty();
            }
            if ((propertyData.isSetter ? (Method)candidate2.second : (Method)candidate2.first) != null) continue;
            candidate2 = new Couple<Method>(propertyData.isSetter ? (Method)candidate2.first : method, propertyData.isSetter ? method : (Method)candidate2.second);
            candidates2.put(propertyData.name, candidate2);
        }
        Iterator iterator2 = candidates2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry candidate3 = iterator2.next();
            Couple methods2 = (Couple)candidate3.getValue();
            Method getter2 = (Method)methods2.first;
            Method setter2 = (Method)methods2.second;
            if (this.isAcceptableProperty(getter2, setter2)) {
                accessors.add(new PropertyAccessor((String)candidate3.getKey(), getter2.getReturnType(), getter2, setter2));
                continue;
            }
            iterator2.remove();
        }
        TreeMap<String, Couple<Method>> treeMap = candidates2;
        if (treeMap == null) {
            PropertyCollector.$$$reportNull$$$0(6);
        }
        return treeMap;
    }

    @Nullable
    private static NameAndIsSetter getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            PropertyCollector.$$$reportNull$$$0(7);
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2);
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3);
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            if (part.endsWith("$annotations")) {
                return null;
            }
            part = part.substring(0, suffixIndex);
        }
        return new NameAndIsSetter(PropertyCollector.decapitalize(part), isSetter);
    }

    @NotNull
    private static String decapitalize(@NotNull String name) {
        if (name == null) {
            PropertyCollector.$$$reportNull$$$0(8);
        }
        if (name.isEmpty() || name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            String string2 = name;
            if (string2 == null) {
                PropertyCollector.$$$reportNull$$$0(9);
            }
            return string2;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(name.charAt(0));
        return new String(chars);
    }

    private boolean isAcceptableProperty(@Nullable Method getter2, @Nullable Method setter2) {
        if (getter2 == null || this.isAnnotatedAsTransient(getter2)) {
            return false;
        }
        if (setter2 == null) {
            return (Collection.class.isAssignableFrom(getter2.getReturnType()) || Map.class.isAssignableFrom(getter2.getReturnType())) && this.hasStoreAnnotations(getter2);
        }
        return !this.isAnnotatedAsTransient(setter2) && getter2.getReturnType().equals(setter2.getParameterTypes()[0]);
    }

    protected boolean isAnnotatedAsTransient(@NotNull AnnotatedElement element) {
        if (element == null) {
            PropertyCollector.$$$reportNull$$$0(10);
        }
        return false;
    }

    protected boolean hasStoreAnnotations(@NotNull AccessibleObject element) {
        if (element == null) {
            PropertyCollector.$$$reportNull$$$0(11);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/serialization/PropertyCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "totalProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/serialization/PropertyCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertyAccessors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldAccessors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertyAccessors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedAsTransient";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasStoreAnnotations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NameAndIsSetter {
        final String name;
        final boolean isSetter;

        NameAndIsSetter(String name, boolean isSetter) {
            this.name = name;
            this.isSetter = isSetter;
        }
    }
}

