/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.FirOuterClassManager;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "outerClassManager", "Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;)V", "resolvedFunctionType", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "samConstructor", "buildSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firRegularClass", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamConstructor", "resolveFunctionTypeIfSamInterface", "shouldRunSamConversionForFunction", "", "firFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "resolve"})
public final class FirSamResolverImpl
extends FirSamResolver {
    @NotNull
    private final FirSession firSession;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final FirOuterClassManager outerClassManager;
    @NotNull
    private final Map<FirRegularClass, Object> resolvedFunctionType;
    @NotNull
    private final Map<FirRegularClass, Object> samConstructor;

    public FirSamResolverImpl(@NotNull FirSession firSession, @NotNull ScopeSession scopeSession, @Nullable FirOuterClassManager outerClassManager) {
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.firSession = firSession;
        this.scopeSession = scopeSession;
        this.outerClassManager = outerClassManager;
        this.resolvedFunctionType = new LinkedHashMap();
        this.samConstructor = new LinkedHashMap();
    }

    public /* synthetic */ FirSamResolverImpl(FirSession firSession, ScopeSession scopeSession, FirOuterClassManager firOuterClassManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firOuterClassManager = null;
        }
        this(firSession, scopeSession, firOuterClassManager);
    }

    @Override
    @Nullable
    public ConeKotlinType getFunctionTypeForPossibleSamType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType2 = type2;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.getFunctionTypeForPossibleSamType(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, this.firSession, null, 2, null));
        } else if (coneKotlinType2 instanceof ConeFlexibleType) {
            ConeKotlinType coneKotlinType3 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getLowerBound());
            if (coneKotlinType3 == null) {
                return null;
            }
            ConeKotlinType coneKotlinType4 = coneKotlinType3;
            coneKotlinType3 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getUpperBound());
            if (coneKotlinType3 == null) {
                return null;
            }
            coneKotlinType = new ConeFlexibleType(coneKotlinType4, coneKotlinType3);
        } else if (coneKotlinType2 instanceof ConeClassErrorType ? true : coneKotlinType2 instanceof ConeStubType) {
            coneKotlinType = null;
        } else if (((((coneKotlinType2 instanceof ConeTypeParameterType ? true : coneKotlinType2 instanceof ConeTypeVariableType) ? true : coneKotlinType2 instanceof ConeCapturedType) ? true : coneKotlinType2 instanceof ConeDefinitelyNotNullType) ? true : coneKotlinType2 instanceof ConeIntersectionType) ? true : coneKotlinType2 instanceof ConeIntegerLiteralType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
            coneKotlinType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type2) {
        FirTypeParameterSymbol firTypeParameterSymbol;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        FirRegularClass firRegularClass = LookupTagUtilsKt.toFirRegularClass(type2.getLookupTag(), this.firSession);
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        ConeLookupTagBasedType coneLookupTagBasedType = this.resolveFunctionTypeIfSamInterface(firRegularClass2);
        if (coneLookupTagBasedType == null) {
            return null;
        }
        ConeLookupTagBasedType unsubstitutedFunctionType = coneLookupTagBasedType;
        if (firRegularClass2.getTypeParameters().isEmpty()) {
            return (ConeLookupTagBasedType)TypeUtilsKt.withNullability$default(unsubstitutedFunctionType, ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), SessionUtilsKt.getTypeContext(this.firSession), null, 4, null);
        }
        Iterable iterable = firRegularClass2.getTypeParameters();
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            firTypeParameterSymbol = it.getSymbol();
            collection.add(firTypeParameterSymbol);
        }
        $this$map$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Object[])type2.getTypeArguments());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConeKotlinType coneKotlinType;
            ConeKotlinTypeProjection coneKotlinTypeProjection;
            void $dstr$parameterSymbol$projection;
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeParameterSymbol parameterSymbol = (FirTypeParameterSymbol)$dstr$parameterSymbol$projection.component1();
            ConeTypeProjection projection = (ConeTypeProjection)$dstr$parameterSymbol$projection.component2();
            ConeKotlinTypeProjection coneKotlinTypeProjection2 = coneKotlinTypeProjection = projection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)projection : null;
            if (coneKotlinTypeProjection == null) {
                ConeKotlinType coneKotlinType2;
                ConeKotlinType coneKotlinType3;
                FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.firstOrNull(((FirTypeParameter)parameterSymbol.getFir()).getBounds());
                if (firTypeRef == null) {
                    coneKotlinType3 = null;
                } else {
                    FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                    if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                        coneKotlinType3 = coneKotlinType2 = null;
                    }
                }
                coneKotlinType = coneKotlinType2 == null ? (ConeKotlinType)this.firSession.getBuiltinTypes().getNullableAnyType().getType() : coneKotlinType2;
            } else {
                coneKotlinType = coneKotlinTypeProjection.getType();
            }
            ConeKotlinType typeArgument = coneKotlinType;
            firTypeParameterSymbol = new Pair((Object)parameterSymbol, (Object)typeArgument);
            collection.add(firTypeParameterSymbol);
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)((List)destination$iv$iv)), this.firSession);
        ConeKotlinType result2 = TypeUtilsKt.withNullability$default(substitutor2.substituteOrSelf(unsubstitutedFunctionType), ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), SessionUtilsKt.getTypeContext(this.firSession), null, 4, null);
        boolean bl = result2 instanceof ConeLookupTagBasedType;
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(result2.getClass()) + " was found";
            throw new IllegalArgumentException(string2.toString());
        }
        return (ConeLookupTagBasedType)result2;
    }

    @Override
    @Nullable
    public FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firRegularClass) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)firRegularClass, (String)"firRegularClass");
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.samConstructor;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            boolean bl = false;
            FirSimpleFunction firSimpleFunction = this.buildSamConstructor(firRegularClass);
            Object answer$iv = firSimpleFunction == null ? SamResolutionKt.access$getNULL_STUB$p() : firSimpleFunction;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        return (object = object2) instanceof FirSimpleFunction ? (FirSimpleFunction)object : null;
    }

    /*
     * WARNING - void declaration
     */
    private final FirSimpleFunction buildSamConstructor(FirRegularClass firRegularClass) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        FirSimpleFunction firSimpleFunction;
        void $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        void $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15;
        FirValueParameterBuilder firValueParameterBuilder;
        void $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d13;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11;
        FirSimpleFunctionBuilder $i$f$map42;
        void $this$mapTo$iv$iv2;
        Iterator $this$map$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        Object object;
        FirTypeParameterBuilder $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5;
        Collection collection;
        void $this$mapTo$iv$iv4;
        void it;
        ConeLookupTagBasedType coneLookupTagBasedType = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (coneLookupTagBasedType == null) {
            return null;
        }
        ConeLookupTagBasedType functionType = coneLookupTagBasedType;
        ClassId classId = FirDeclarationUtilKt.getClassId(firRegularClass);
        Object object2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"classId.packageFqName");
        FqName fqName2 = object2;
        object2 = classId.getRelativeClassName().parent();
        FqName fqName3 = object2;
        FqName fqName4 = fqName2;
        boolean bl = false;
        boolean bl2 = !it.isRoot();
        Object object3 = bl2 ? object2 : null;
        object2 = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"classId.shortClassName");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        FqName fqName5 = null;
        Object object4 = object2;
        FqName fqName6 = object3;
        FqName fqName7 = fqName4;
        CallableId callableId = new CallableId(fqName7, fqName6, (Name)object4, fqName5, n, defaultConstructorMarker);
        FirSyntheticFunctionSymbol symbol2 = new FirSyntheticFunctionSymbol(callableId);
        Iterable $this$map$iv4 = firRegularClass.getTypeParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv4;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            FirTypeParameterBuilder firTypeParameterBuilder;
            void typeParameter;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            FirTypeParameter declaredTypeParameter = (FirTypeParameter)typeParameter.getSymbol().getFir();
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5 = firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl4 = false;
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setSource(declaredTypeParameter.getSource());
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setModuleData(FirModuleDataKt.getModuleData(this.firSession));
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setResolvePhase(FirResolvePhase.Companion.getDECLARATIONS());
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setName(declaredTypeParameter.getName());
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setSymbol(new FirTypeParameterSymbol());
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setVariance(Variance.INVARIANT);
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5.setReified(false);
            FirTypeParameterBuilder firTypeParameterBuilder2 = $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5;
            CollectionsKt.addAll((Collection)firTypeParameterBuilder2.getAnnotations(), (Iterable)declaredTypeParameter.getAnnotations());
            object = firTypeParameterBuilder;
            collection.add(object);
        }
        List newTypeParameters = (List)destination$iv$iv;
        Iterable $i$f$map22 = newTypeParameters;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it2;
            FirTypeParameterBuilder bl3 = (FirTypeParameterBuilder)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            object = new ConeTypeParameterTypeImpl(it2.getSymbol().toLookupTag(), false, null, 4, null);
            collection.add(object);
        }
        List newTypeParameterTypes = (List)destination$iv$iv2;
        Iterable $i$f$map32 = firRegularClass.getTypeParameters();
        boolean $i$f$map42 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv2), (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            FirTypeParameterRef bl5 = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl6 = false;
            object = it3.getSymbol();
            collection.add(object);
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv3), (Iterable)newTypeParameterTypes)), this.firSession);
        for (Pair $i$f$map42 : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapTo$iv$iv5;
            void $this$map$iv5;
            Object item$iv$iv;
            FirTypeParameterBuilder newTypeParameter = (FirTypeParameterBuilder)$i$f$map42.component1();
            FirTypeParameterRef oldTypeParameter = (FirTypeParameterRef)$i$f$map42.component2();
            FirTypeParameter declared = (FirTypeParameter)oldTypeParameter.getSymbol().getFir();
            item$iv$iv = newTypeParameter;
            Iterable it3 = declared.getBounds();
            collection = ((FirTypeParameterBuilder)item$iv$iv).getBounds();
            boolean $i$f$map5 = false;
            $this$buildSamConstructor_u24lambda_u2d6_u24lambda_u2d5 = $this$map$iv5;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
                Iterator typeRef;
                FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2;
                FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv2;
                object = destination$iv$iv4;
                boolean bl7 = false;
                boolean $i$f$buildResolvedTypeRef = false;
                FirResolvedTypeRefBuilder $this$buildSamConstructor_u24lambda_u2d10_u24lambda_u2d9 = firResolvedTypeRefBuilder2 = new FirResolvedTypeRefBuilder();
                boolean bl8 = false;
                $this$buildSamConstructor_u24lambda_u2d10_u24lambda_u2d9.setSource(((FirTypeRef)((Object)typeRef)).getSource());
                $this$buildSamConstructor_u24lambda_u2d10_u24lambda_u2d9.setType(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType((FirTypeRef)((Object)typeRef))));
                FirResolvedTypeRef firResolvedTypeRef = firResolvedTypeRefBuilder2.build();
                object.add(firResolvedTypeRef);
            }
            object = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)object));
        }
        boolean $i$f$buildSimpleFunction = false;
        FirSimpleFunctionBuilder $this$buildSamConstructor_u24lambda_u2d16 = $i$f$map42 = new FirSimpleFunctionBuilder();
        boolean bl9 = false;
        $this$buildSamConstructor_u24lambda_u2d16.setModuleData(FirModuleDataKt.getModuleData(this.firSession));
        $this$buildSamConstructor_u24lambda_u2d16.setSource(firRegularClass.getSource());
        Name declared = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)declared, (String)"classId.shortClassName");
        $this$buildSamConstructor_u24lambda_u2d16.setName(declared);
        $this$buildSamConstructor_u24lambda_u2d16.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        Object $this$visibility$iv = firRegularClass;
        boolean $i$f$getVisibility22 = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = new FirResolvedDeclarationStatusImpl(visibility2, Modality.FINAL, EffectiveVisibility.Local.INSTANCE);
        FirElement $i$f$getVisibility22 = $this$visibility$iv;
        Object object5 = $this$buildSamConstructor_u24lambda_u2d16;
        boolean $i$a$-apply-FirSamResolverImpl$buildSamConstructor$2$22 = false;
        FirMemberDeclaration $this$isExpect$iv = firRegularClass;
        boolean $i$f$isExpect = false;
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setExpect($this$isExpect$iv.getStatus().isExpect());
        FirMemberDeclaration $this$isActual$iv = firRegularClass;
        boolean $i$f$isActual22 = false;
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setActual($this$isActual$iv.getStatus().isActual());
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setOverride(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setOperator(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setInfix(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setExternal(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setInline(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setSuspend(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d11.setTailRec(false);
        Object object6 = Unit.INSTANCE;
        ((FirSimpleFunctionBuilder)object5).setStatus((FirDeclarationStatus)$this$visibility$iv);
        $this$buildSamConstructor_u24lambda_u2d16.setSymbol(symbol2);
        $this$visibility$iv = $this$buildSamConstructor_u24lambda_u2d16;
        Iterable $i$a$-apply-FirSamResolverImpl$buildSamConstructor$2$22 = newTypeParameters;
        object5 = ((FirSimpleFunctionBuilder)$this$visibility$iv).getTypeParameters();
        boolean $i$f$map6 = false;
        void $i$f$isActual22 = $this$map$iv;
        ConeTypeParameterTypeImpl[] destination$iv$iv5 = (ConeTypeParameterTypeImpl[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            FirTypeParameterBuilder $i$f$buildResolvedTypeRef = (FirTypeParameterBuilder)item$iv$iv;
            object6 = destination$iv$iv5;
            boolean bl10 = false;
            FirTypeParameter firTypeParameter = it4.build();
            object6.add(firTypeParameter);
        }
        object6 = (List)destination$iv$iv5;
        CollectionsKt.addAll((Collection)object5, (Iterable)((Iterable)object6));
        ConeKotlinType substitutedFunctionType = substitutor2.substituteOrSelf(functionType);
        Collection $this$toTypedArray$iv = newTypeParameterTypes;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        destination$iv$iv5 = thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]);
        if (destination$iv$iv5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(firRegularClass.getSymbol().toLookupTag(), destination$iv$iv5, false, null, 8, null);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder3 = new FirResolvedTypeRefBuilder();
        thisCollection$iv = firResolvedTypeRefBuilder3;
        object5 = $this$buildSamConstructor_u24lambda_u2d16;
        boolean bl11 = false;
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d13.setSource(null);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d13.setType(substitutedReturnType);
        object6 = Unit.INSTANCE;
        ((FirSimpleFunctionBuilder)object5).setReturnTypeRef(firResolvedTypeRefBuilder3.build());
        FirSimpleFunctionBuilder firSimpleFunctionBuilder = $this$buildSamConstructor_u24lambda_u2d16;
        boolean $i$f$buildValueParameter = false;
        FirValueParameterBuilder $i$f$mapTo222 = firValueParameterBuilder = new FirValueParameterBuilder();
        object5 = firSimpleFunctionBuilder.getValueParameters();
        boolean bl12 = false;
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15.setModuleData(FirModuleDataKt.getModuleData(this.firSession));
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        boolean $i$f$buildResolvedTypeRef2 = false;
        FirResolvedTypeRefBuilder bl10 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        void var27_89 = $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15;
        boolean bl13 = false;
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.setSource(firRegularClass.getSource());
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.setType(substitutedFunctionType);
        Unit unit2 = Unit.INSTANCE;
        var27_89.setReturnTypeRef(firResolvedTypeRefBuilder.build());
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15.setName(SamResolutionKt.getSAM_PARAMETER_NAME());
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15.setSymbol(new FirValueParameterSymbol(SamResolutionKt.getSAM_PARAMETER_NAME()));
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15.setCrossinline(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15.setNoinline(false);
        $this$buildSamConstructor_u24lambda_u2d16_u24lambda_u2d15.setVararg(false);
        object6 = Unit.INSTANCE;
        object5.add(firValueParameterBuilder.build());
        $this$buildSamConstructor_u24lambda_u2d16.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirSimpleFunction $this$buildSamConstructor_u24lambda_u2d17 = firSimpleFunction = $i$f$map42.build();
        boolean bl14 = false;
        FirOuterClassManager firOuterClassManager = this.outerClassManager;
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$buildSamConstructor_u24lambda_u2d17, firOuterClassManager == null ? null : ((firClassLikeSymbol = firOuterClassManager.outerClass(firRegularClass.getSymbol())) == null ? null : firClassLikeSymbol.toLookupTag()));
        return firSimpleFunction;
    }

    private final ConeLookupTagBasedType resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        Object object;
        Object object2;
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.resolvedFunctionType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            Object object3;
            boolean bl = false;
            if (!firRegularClass.getStatus().isFun()) {
                object3 = SamResolutionKt.access$getNULL_STUB$p();
            } else {
                FirSimpleFunction firSimpleFunction = SamResolutionKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.firSession, this.scopeSession);
                if (firSimpleFunction == null) {
                    object3 = SamResolutionKt.access$getNULL_STUB$p();
                } else {
                    FirSimpleFunction abstractMethod = firSimpleFunction;
                    object3 = SamResolutionKt.access$getFunctionTypeForAbstractMethod(abstractMethod);
                }
            }
            Object answer$iv = object3;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        return (object = object2) instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)object : null;
    }

    @Override
    public boolean shouldRunSamConversionForFunction(@NotNull FirFunction firFunction) {
        Intrinsics.checkNotNullParameter((Object)firFunction, (String)"firFunction");
        return true;
    }
}

