/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshot;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.snapshots.SimpleFileSnapshotProviderImpl;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "compareAndUpdate", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "newFiles", "", "dumpValue", "", "value", "incremental-compilation-impl"})
public final class FileSnapshotMap
extends BasicStringMap<FileSnapshot> {
    @NotNull
    private final FileToPathConverter pathConverter;

    public FileSnapshotMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(storageFile, PathStringDescriptor.INSTANCE, (DataExternalizer)FileSnapshotExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull FileSnapshot value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return value2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized ChangedFiles.Known compareAndUpdate(@NotNull Iterable<? extends File> newFiles) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(newFiles, (String)"newFiles");
        SimpleFileSnapshotProviderImpl snapshotProvider = new SimpleFileSnapshotProviderImpl();
        ArrayList<File> newOrModified = new ArrayList<File>();
        ArrayList<File> removed2 = new ArrayList<File>();
        Iterator iterator2 = newFiles;
        Collection collection = new HashSet();
        FileToPathConverter fileToPathConverter = this.pathConverter;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            File file2 = (File)item$iv;
            void var14_14 = destination$iv;
            boolean bl = false;
            String string2 = fileToPathConverter.toPath((File)p0);
            var14_14.add(string2);
        }
        HashSet newPaths = (HashSet)destination$iv;
        for (String oldPath : this.getStorage().getKeys()) {
            if (newPaths.contains(oldPath)) continue;
            this.getStorage().remove(oldPath);
            removed2.add(this.pathConverter.toFile(oldPath));
        }
        for (String path2 : newPaths) {
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            File file3 = this.pathConverter.toFile(path2);
            FileSnapshot oldSnapshot = (FileSnapshot)this.getStorage().get(path2);
            FileSnapshot newSnapshot = snapshotProvider.get(file3);
            if (oldSnapshot != null && Intrinsics.areEqual((Object)oldSnapshot, (Object)newSnapshot)) continue;
            newOrModified.add(file3);
            this.getStorage().set(path2, newSnapshot);
        }
        return new ChangedFiles.Known((List<? extends File>)newOrModified, (List<? extends File>)removed2);
    }
}

