/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnderscoreUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallElement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkSimpleNameUsage", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isUnderscoreOnlyName", "", "", "frontend"})
public final class UnderscoreUsageChecker
implements CallChecker {
    @NotNull
    public static final UnderscoreUsageChecker INSTANCE = new UnderscoreUsageChecker();

    private UnderscoreUsageChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        ConstructorDescriptor constructorDescriptor = descriptor2 instanceof ConstructorDescriptor ? (ConstructorDescriptor)descriptor2 : null;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = constructorDescriptor != null ? constructorDescriptor.getContainingDeclaration() : null;
        if (classifierDescriptorWithTypeParameters == null) {
            Intrinsics.checkNotNullExpressionValue(descriptor2, (String)"descriptor");
            declarationDescriptor = (DeclarationDescriptor)descriptor2;
        } else {
            declarationDescriptor = classifierDescriptorWithTypeParameters;
        }
        DeclarationDescriptor namedDescriptor = declarationDescriptor;
        String string2 = namedDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"namedDescriptor.name.asString()");
        if (!this.isUnderscoreOnlyName(string2)) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
        this.checkCallElement(ktElement, context);
    }

    private final void checkCallElement(KtElement ktElement, CallCheckerContext context) {
        block2: {
            KtElement ktElement2;
            block1: {
                ktElement2 = ktElement;
                if (!(ktElement2 instanceof KtSimpleNameExpression)) break block1;
                this.checkSimpleNameUsage((KtSimpleNameExpression)ktElement, context.getTrace());
                break block2;
            }
            if (!(ktElement2 instanceof KtCallExpression)) break block2;
            KtExpression ktExpression = ((KtCallExpression)ktElement).getCalleeExpression();
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                INSTANCE.checkCallElement(it, context);
            }
        }
    }

    private final void checkSimpleNameUsage(KtSimpleNameExpression ktName, BindingTrace trace) {
        String string2 = ktName.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ktName.text");
        if (this.isUnderscoreOnlyName(string2)) {
            trace.report(Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.on(ktName));
        }
    }

    public final void checkSimpleNameUsage(@NotNull DeclarationDescriptor descriptor2, @NotNull KtSimpleNameExpression ktName, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)ktName, (String)"ktName");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        String string2 = descriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.name.asString()");
        if (this.isUnderscoreOnlyName(string2)) {
            this.checkSimpleNameUsage(ktName, trace);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnderscoreOnlyName(String $this$isUnderscoreOnlyName) {
        if (((CharSequence)$this$isUnderscoreOnlyName).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = $this$isUnderscoreOnlyName;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl2 = false;
            if (it != '_') return false;
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

