/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\b\u001a\u00020\u0005*\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u00020\u0005*\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"getKotlinOrJsQualifier", "Lorg/jetbrains/kotlin/name/FqName;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "shouldIncludePackage", "", "getFqNameWithJsNameWhenAvailable", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "isExportedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isExportedInterface", "isExportedMember", "isTheLastReturnStatementIn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnableBlockSymbol;", "backend.js"})
public final class IrJsUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedMember(@NotNull IrDeclaration $this$isExportedMember, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isExportedMember, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!($this$isExportedMember instanceof IrDeclarationWithVisibility)) return false;
        if (!((IrDeclarationWithVisibility)$this$isExportedMember).getVisibility().isPublicAPI()) return false;
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$isExportedMember);
        if (irClass2 == null) return false;
        if (!ExportModelGeneratorKt.isExported(irClass2, context)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedClass(@Nullable IrDeclaration $this$isExportedClass, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!($this$isExportedClass instanceof IrClass)) return false;
        ClassKind $this$isClass$iv = ((IrClass)$this$isExportedClass).getKind();
        boolean $i$f$isClass = false;
        if ($this$isClass$iv != ClassKind.CLASS) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!ExportModelGeneratorKt.isExported($this$isExportedClass, context)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedInterface(@Nullable IrDeclaration $this$isExportedInterface, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!($this$isExportedInterface instanceof IrClass)) return false;
        ClassKind $this$isInterface$iv = ((IrClass)$this$isExportedInterface).getKind();
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!ExportModelGeneratorKt.isExported($this$isExportedInterface, context)) return false;
        return true;
    }

    public static final boolean isTheLastReturnStatementIn(@NotNull IrReturn $this$isTheLastReturnStatementIn, @NotNull IrReturnableBlockSymbol target) {
        Intrinsics.checkNotNullParameter((Object)$this$isTheLastReturnStatementIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return CollectionsKt.lastOrNull(((IrReturnableBlock)target.getOwner()).getStatements()) == $this$isTheLastReturnStatementIn;
    }

    @NotNull
    public static final FqName getFqNameWithJsNameWhenAvailable(@NotNull IrDeclarationWithName $this$getFqNameWithJsNameWhenAvailable, boolean shouldIncludePackage) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithJsNameWhenAvailable, (String)"<this>");
        Name name = AnnotationUtilsKt.getJsNameOrKotlinName($this$getFqNameWithJsNameWhenAvailable);
        IrDeclarationParent parent2 = $this$getFqNameWithJsNameWhenAvailable.getParent();
        if (parent2 instanceof IrDeclarationWithName) {
            FqName fqName3 = IrJsUtilsKt.getFqNameWithJsNameWhenAvailable((IrDeclarationWithName)((Object)parent2), shouldIncludePackage).child(name);
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"parent.getFqNameWithJsNa\u2026cludePackage).child(name)");
        } else if (parent2 instanceof IrPackageFragment) {
            fqName2 = IrJsUtilsKt.getKotlinOrJsQualifier((IrPackageFragment)parent2, shouldIncludePackage);
            if (fqName2 == null || (fqName2 = fqName2.child(name)) == null) {
                fqName2 = new FqName(name.getIdentifier());
            }
        } else {
            fqName2 = new FqName(name.getIdentifier());
        }
        return fqName2;
    }

    private static final FqName getKotlinOrJsQualifier(IrPackageFragment parent2, boolean shouldIncludePackage) {
        FqName fqName2;
        Object object = parent2 instanceof IrFile ? (IrFile)parent2 : null;
        if (object != null && (object = AnnotationUtilsKt.getJsQualifier((IrAnnotationContainer)object)) != null) {
            Object it = object;
            boolean bl = false;
            fqName2 = new FqName((String)it);
        } else {
            FqName fqName3;
            FqName it = fqName3 = parent2.getFqName();
            boolean bl = false;
            fqName2 = shouldIncludePackage ? fqName3 : null;
        }
        return fqName2;
    }
}

