/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.lexer;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.kdoc.lexer.KDocLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocToken;
import org.jetbrains.kotlin.kdoc.parser.KDocLinkParser;
import org.jetbrains.kotlin.kdoc.parser.KDocParser;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocImpl;

public interface KDocTokens {
    public static final ILazyParseableElementType KDOC = new ILazyParseableElementType("KDoc", KotlinLanguage.INSTANCE){

        @Override
        public ASTNode parseContents(ASTNode chameleon) {
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)new KDocLexer(), this.getLanguage(), (CharSequence)chameleon.getText());
            KDocParser parser = new KDocParser();
            return parser.parse(this, builder2).getFirstChildNode();
        }

        @Override
        @Nullable
        public ASTNode createNode(CharSequence text2) {
            return new KDocImpl(text2);
        }
    };
    public static final int START_Id = 0;
    public static final int END_Id = 1;
    public static final int LEADING_ASTERISK_Id = 2;
    public static final int TEXT_Id = 3;
    public static final int CODE_BLOCK_TEXT_Id = 4;
    public static final int TAG_NAME_Id = 5;
    public static final int MARKDOWN_ESCAPED_CHAR_Id = 6;
    public static final int MARKDOWN_INLINE_LINK_Id = 7;
    public static final KDocToken START = new KDocToken("KDOC_START", 0);
    public static final KDocToken END = new KDocToken("KDOC_END", 1);
    public static final KDocToken LEADING_ASTERISK = new KDocToken("KDOC_LEADING_ASTERISK", 2);
    public static final KDocToken TEXT = new KDocToken("KDOC_TEXT", 3);
    public static final KDocToken CODE_BLOCK_TEXT = new KDocToken("KDOC_CODE_BLOCK_TEXT", 4);
    public static final KDocToken TAG_NAME = new KDocToken("KDOC_TAG_NAME", 5);
    public static final ILazyParseableElementType MARKDOWN_LINK = new ILazyParseableElementType("KDOC_MARKDOWN_LINK", KotlinLanguage.INSTANCE){

        @Override
        public ASTNode parseContents(ASTNode chameleon) {
            return KDocLinkParser.parseMarkdownLink(this, chameleon);
        }
    };
    public static final KDocToken MARKDOWN_ESCAPED_CHAR = new KDocToken("KDOC_MARKDOWN_ESCAPED_CHAR", 6);
    public static final KDocToken MARKDOWN_INLINE_LINK = new KDocToken("KDOC_MARKDOWN_INLINE_LINK", 7);
    public static final TokenSet KDOC_HIGHLIGHT_TOKENS = TokenSet.create(START, END, LEADING_ASTERISK, TEXT, CODE_BLOCK_TEXT, MARKDOWN_LINK, MARKDOWN_ESCAPED_CHAR, MARKDOWN_INLINE_LINK);
    public static final TokenSet CONTENT_TOKENS = TokenSet.create(TEXT, CODE_BLOCK_TEXT, TAG_NAME, MARKDOWN_LINK, MARKDOWN_ESCAPED_CHAR, MARKDOWN_INLINE_LINK);
}

