/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.DeclarationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ExceptionWrappingKtVisitorVoid;
import org.jetbrains.kotlin.resolve.FilePreprocessor;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.OverloadResolver;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.VarianceChecker;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.ImportForceResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0093\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u0012\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010%J2\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\b\b\u0002\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100J\u001e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020'2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J2\u00107\u001a\u0002022\u0006\u00103\u001a\u00020'2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;092\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=05H\u0002J2\u0010>\u001a\u0002022\u0006\u00103\u001a\u00020'2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;092\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@05H\u0002J2\u0010A\u001a\u0002022\u0006\u00103\u001a\u00020'2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;092\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C05H\u0002J,\u0010D\u001a\u0002022\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;092\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u0002022\u0006\u00103\u001a\u00020'H\u0002J\u0010\u0010J\u001a\u0002022\u0006\u00103\u001a\u00020'H\u0002J\u000e\u0010K\u001a\u0002022\u0006\u0010L\u001a\u00020MR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "declarationResolver", "Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "overrideResolver", "Lorg/jetbrains/kotlin/resolve/OverrideResolver;", "overloadResolver", "Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "varianceChecker", "Lorg/jetbrains/kotlin/resolve/VarianceChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "lazyDeclarationResolver", "Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;", "bodyResolver", "Lorg/jetbrains/kotlin/resolve/BodyResolver;", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "fileScopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "declarationScopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "classifierUsageCheckers", "", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "filePreprocessor", "Lorg/jetbrains/kotlin/resolve/FilePreprocessor;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DeclarationResolver;Lorg/jetbrains/kotlin/resolve/OverrideResolver;Lorg/jetbrains/kotlin/resolve/OverloadResolver;Lorg/jetbrains/kotlin/resolve/VarianceChecker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;Lorg/jetbrains/kotlin/resolve/BodyResolver;Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/resolve/FilePreprocessor;)V", "analyzeDeclarations", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "topDownAnalysisMode", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisMode;", "declarations", "", "Lcom/intellij/psi/PsiElement;", "outerDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "localContext", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "createFunctionDescriptors", "", "c", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "createPropertiesFromDestructuringDeclarations", "topLevelFqNames", "Lcom/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "destructuringDeclarations", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "createPropertyDescriptors", "properties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "createTypeAliasDescriptors", "typeAliases", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "registerTopLevelFqName", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolveAllHeadersInClasses", "resolveImportsInAllFiles", "resolveImportsInFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "frontend"})
@SourceDebugExtension(value={"SMAP\nLazyTopDownAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyTopDownAnalyzer.kt\norg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n1549#2:323\n1620#2,3:324\n*S KotlinDebug\n*F\n+ 1 LazyTopDownAnalyzer.kt\norg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer\n*L\n246#1:323\n246#1:324,3\n*E\n"})
public final class LazyTopDownAnalyzer {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final DeclarationResolver declarationResolver;
    @NotNull
    private final OverrideResolver overrideResolver;
    @NotNull
    private final OverloadResolver overloadResolver;
    @NotNull
    private final VarianceChecker varianceChecker;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final LazyDeclarationResolver lazyDeclarationResolver;
    @NotNull
    private final BodyResolver bodyResolver;
    @NotNull
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    @NotNull
    private final FileScopeProvider fileScopeProvider;
    @NotNull
    private final DeclarationScopeProvider declarationScopeProvider;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final Iterable<ClassifierUsageChecker> classifierUsageCheckers;
    @NotNull
    private final FilePreprocessor filePreprocessor;

    public LazyTopDownAnalyzer(@NotNull BindingTrace trace, @NotNull DeclarationResolver declarationResolver, @NotNull OverrideResolver overrideResolver, @NotNull OverloadResolver overloadResolver, @NotNull VarianceChecker varianceChecker, @NotNull ModuleDescriptor moduleDescriptor, @NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull BodyResolver bodyResolver, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull FileScopeProvider fileScopeProvider, @NotNull DeclarationScopeProvider declarationScopeProvider, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull IdentifierChecker identifierChecker, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull DeprecationResolver deprecationResolver, @NotNull Iterable<? extends ClassifierUsageChecker> classifierUsageCheckers, @NotNull FilePreprocessor filePreprocessor) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)declarationResolver, (String)"declarationResolver");
        Intrinsics.checkNotNullParameter((Object)overrideResolver, (String)"overrideResolver");
        Intrinsics.checkNotNullParameter((Object)overloadResolver, (String)"overloadResolver");
        Intrinsics.checkNotNullParameter((Object)varianceChecker, (String)"varianceChecker");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)lazyDeclarationResolver, (String)"lazyDeclarationResolver");
        Intrinsics.checkNotNullParameter((Object)bodyResolver, (String)"bodyResolver");
        Intrinsics.checkNotNullParameter((Object)topLevelDescriptorProvider, (String)"topLevelDescriptorProvider");
        Intrinsics.checkNotNullParameter((Object)fileScopeProvider, (String)"fileScopeProvider");
        Intrinsics.checkNotNullParameter((Object)declarationScopeProvider, (String)"declarationScopeProvider");
        Intrinsics.checkNotNullParameter((Object)qualifiedExpressionResolver, (String)"qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)deprecationResolver, (String)"deprecationResolver");
        Intrinsics.checkNotNullParameter(classifierUsageCheckers, (String)"classifierUsageCheckers");
        Intrinsics.checkNotNullParameter((Object)filePreprocessor, (String)"filePreprocessor");
        this.trace = trace;
        this.declarationResolver = declarationResolver;
        this.overrideResolver = overrideResolver;
        this.overloadResolver = overloadResolver;
        this.varianceChecker = varianceChecker;
        this.moduleDescriptor = moduleDescriptor;
        this.lazyDeclarationResolver = lazyDeclarationResolver;
        this.bodyResolver = bodyResolver;
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        this.fileScopeProvider = fileScopeProvider;
        this.declarationScopeProvider = declarationScopeProvider;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.identifierChecker = identifierChecker;
        this.languageVersionSettings = languageVersionSettings2;
        this.deprecationResolver = deprecationResolver;
        this.classifierUsageCheckers = classifierUsageCheckers;
        this.filePreprocessor = filePreprocessor;
    }

    @NotNull
    public final TopDownAnalysisContext analyzeDeclarations(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<? extends PsiElement> declarations2, @NotNull DataFlowInfo outerDataFlowInfo, @Nullable ExpressionTypingContext localContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)topDownAnalysisMode), (String)"topDownAnalysisMode");
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        Intrinsics.checkNotNullParameter((Object)outerDataFlowInfo, (String)"outerDataFlowInfo");
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisMode, outerDataFlowInfo, this.declarationScopeProvider, localContext);
        HashMultimap<FqName, KtElement> topLevelFqNames = HashMultimap.create();
        ArrayList<KtProperty> properties2 = new ArrayList<KtProperty>();
        ArrayList<KtNamedFunction> functions2 = new ArrayList<KtNamedFunction>();
        ArrayList<KtTypeAlias> typeAliases = new ArrayList<KtTypeAlias>();
        ArrayList<KtDestructuringDeclaration> destructuringDeclarations = new ArrayList<KtDestructuringDeclaration>();
        for (PsiElement psiElement : declarations2) {
            Ref.ObjectRef visitor2 = new Ref.ObjectRef();
            visitor2.element = new ExceptionWrappingKtVisitorVoid(new KtVisitorVoid((Ref.ObjectRef<KtVisitorVoid>)visitor2, c, this, topLevelFqNames, destructuringDeclarations, functions2, properties2, typeAliases){
                final /* synthetic */ Ref.ObjectRef<KtVisitorVoid> $visitor;
                final /* synthetic */ TopDownAnalysisContext $c;
                final /* synthetic */ LazyTopDownAnalyzer this$0;
                final /* synthetic */ HashMultimap<FqName, KtElement> $topLevelFqNames;
                final /* synthetic */ ArrayList<KtDestructuringDeclaration> $destructuringDeclarations;
                final /* synthetic */ ArrayList<KtNamedFunction> $functions;
                final /* synthetic */ ArrayList<KtProperty> $properties;
                final /* synthetic */ ArrayList<KtTypeAlias> $typeAliases;
                {
                    this.$visitor = $visitor;
                    this.$c = $c;
                    this.this$0 = $receiver;
                    this.$topLevelFqNames = $topLevelFqNames;
                    this.$destructuringDeclarations = $destructuringDeclarations;
                    this.$functions = $functions;
                    this.$properties = $properties;
                    this.$typeAliases = $typeAliases;
                }

                private final void registerDeclarations(List<? extends KtDeclaration> declarations2) {
                    for (KtDeclaration ktDeclaration : declarations2) {
                        Object object = this.$visitor.element;
                        Intrinsics.checkNotNull((Object)object);
                        ktDeclaration.accept((PsiElementVisitor)object);
                    }
                }

                public void visitDeclaration(@NotNull KtDeclaration dcl) {
                    Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                    throw new IllegalArgumentException("Unsupported declaration: " + dcl + ' ' + dcl.getText());
                }

                public void visitScript(@NotNull KtScript script) {
                    Intrinsics.checkNotNullParameter((Object)script, (String)"script");
                    this.$c.getScripts().put(script, LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).getScriptDescriptor(script, new KotlinLookupLocation(script)));
                    List<KtDeclaration> list2 = script.getDeclarations();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getDeclarations(...)");
                    this.registerDeclarations(list2);
                }

                public void visitKtFile(@NotNull KtFile file2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    LazyTopDownAnalyzer.access$getFilePreprocessor$p(this.this$0).preprocessFile(file2);
                    this.registerDeclarations(file2.getDeclarations());
                    KtPackageDirective packageDirective = file2.getPackageDirective();
                    boolean bl2 = bl = file2.isScript() || packageDirective != null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = "No package in a non-script file: " + file2;
                        throw new AssertionError((Object)string2);
                    }
                    KtPackageDirective ktPackageDirective = packageDirective;
                    if (ktPackageDirective != null) {
                        ktPackageDirective.accept(this);
                    }
                    this.$c.addFile(file2);
                    this.$topLevelFqNames.put((Object)file2.getPackageFqName(), (Object)packageDirective);
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                    List<KtSimpleNameExpression> list2 = directive.getPackageNames();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getPackageNames(...)");
                    Iterable iterable = list2;
                    LazyTopDownAnalyzer lazyTopDownAnalyzer = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KtSimpleNameExpression it = (KtSimpleNameExpression)element$iv;
                        boolean bl = false;
                        IdentifierChecker identifierChecker = LazyTopDownAnalyzer.access$getIdentifierChecker$p(lazyTopDownAnalyzer);
                        Intrinsics.checkNotNull((Object)it);
                        identifierChecker.checkIdentifier(it, LazyTopDownAnalyzer.access$getTrace$p(lazyTopDownAnalyzer));
                    }
                    LazyTopDownAnalyzer.access$getQualifiedExpressionResolver$p(this.this$0).resolvePackageHeader(directive, LazyTopDownAnalyzer.access$getModuleDescriptor$p(this.this$0), LazyTopDownAnalyzer.access$getTrace$p(this.this$0));
                }

                public void visitImportDirective(@NotNull KtImportDirective importDirective) {
                    Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
                    FileScopeProvider fileScopeProvider = LazyTopDownAnalyzer.access$getFileScopeProvider$p(this.this$0);
                    KtFile ktFile = importDirective.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                    ImportForceResolver importResolver2 = fileScopeProvider.getImportResolver(ktFile);
                    importResolver2.forceResolveImport(importDirective);
                }

                public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                    Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
                    LookupLocation location = classOrObject.isTopLevel() ? (LookupLocation)new KotlinLookupLocation(classOrObject) : (LookupLocation)NoLookupLocation.WHEN_RESOLVE_DECLARATION;
                    ClassDescriptor classDescriptor2 = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).getClassDescriptor(classOrObject, location);
                    Intrinsics.checkNotNull((Object)classDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    ClassDescriptorWithResolutionScopes descriptor2 = (ClassDescriptorWithResolutionScopes)classDescriptor2;
                    this.$c.getDeclaredClasses().put(classOrObject, descriptor2);
                    this.registerDeclarations(classOrObject.getDeclarations());
                    HashMultimap<FqName, KtElement> hashMultimap = this.$topLevelFqNames;
                    Intrinsics.checkNotNullExpressionValue(hashMultimap, (String)"$topLevelFqNames");
                    LazyTopDownAnalyzer.access$registerTopLevelFqName(this.this$0, hashMultimap, classOrObject, descriptor2);
                    this.checkClassOrObjectDeclarations(classOrObject, descriptor2);
                }

                private final void checkClassOrObjectDeclarations(KtClassOrObject classOrObject, ClassDescriptor classDescriptor2) {
                    boolean companionObjectAlreadyFound = false;
                    for (KtDeclaration ktDeclaration : classOrObject.getDeclarations()) {
                        if (ktDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)ktDeclaration).isCompanion()) {
                            if (companionObjectAlreadyFound) {
                                LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.MANY_COMPANION_OBJECTS.on((KtObjectDeclaration)ktDeclaration));
                            }
                            companionObjectAlreadyFound = true;
                            continue;
                        }
                        if (!(ktDeclaration instanceof KtSecondaryConstructor)) continue;
                        if (DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor2)) {
                            LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)ktDeclaration)));
                            continue;
                        }
                        if (classDescriptor2.getKind() != ClassKind.INTERFACE) continue;
                        LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)ktDeclaration)));
                    }
                }

                public void visitClass(@NotNull KtClass klass) {
                    Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                    this.visitClassOrObject(klass);
                    this.registerPrimaryConstructorParameters(klass);
                }

                private final void registerPrimaryConstructorParameters(KtClass klass) {
                    for (KtParameter ktParameter : klass.getPrimaryConstructorParameters()) {
                        if (!ktParameter.hasValOrVar()) continue;
                        Map<KtParameter, PropertyDescriptor> map = this.$c.getPrimaryConstructorParameterProperties();
                        DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(ktParameter);
                        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                        map.put(ktParameter, (PropertyDescriptor)declarationDescriptor);
                    }
                }

                public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2) {
                    Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                    Map<KtSecondaryConstructor, ClassConstructorDescriptor> map = this.$c.getSecondaryConstructors();
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(constructor2);
                    Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
                    map.put(constructor2, (ClassConstructorDescriptor)declarationDescriptor);
                }

                public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
                    Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
                    this.visitClassOrObject(enumEntry);
                }

                public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    this.visitClassOrObject(declaration);
                }

                public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2) {
                    Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(initializer2.getContainingDeclaration());
                    Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    ClassDescriptorWithResolutionScopes containerDescriptor = (ClassDescriptorWithResolutionScopes)declarationDescriptor;
                    this.$c.getAnonymousInitializers().put(initializer2, containerDescriptor);
                }

                public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                    Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                    if (destructuringDeclaration.getContainingKtFile().isScript()) {
                        this.$destructuringDeclarations.add(destructuringDeclaration);
                    }
                }

                public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                    Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                    this.$functions.add(function2);
                }

                public void visitProperty(@NotNull KtProperty property) {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    this.$properties.add(property);
                }

                public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
                    Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                    this.$typeAliases.add(typeAlias);
                }
            });
            psiElement.accept((PsiElementVisitor)visitor2.element);
        }
        this.createFunctionDescriptors(c, (List<? extends KtNamedFunction>)functions2);
        Intrinsics.checkNotNull(topLevelFqNames);
        this.createPropertyDescriptors(c, (Multimap<FqName, KtElement>)topLevelFqNames, (List<? extends KtProperty>)properties2);
        this.createPropertiesFromDestructuringDeclarations(c, (Multimap<FqName, KtElement>)topLevelFqNames, (List<? extends KtDestructuringDeclaration>)destructuringDeclarations);
        this.createTypeAliasDescriptors(c, (Multimap<FqName, KtElement>)topLevelFqNames, (List<KtTypeAlias>)typeAliases);
        this.resolveAllHeadersInClasses(c);
        this.declarationResolver.checkRedeclarationsInPackages(this.topLevelDescriptorProvider, (Multimap<FqName, KtElement>)topLevelFqNames);
        this.declarationResolver.checkRedeclarations(c);
        this.declarationResolver.resolveAnnotationsOnFiles(c, this.fileScopeProvider);
        this.overrideResolver.check(c);
        this.varianceChecker.check(c);
        this.overloadResolver.checkOverloads(c);
        this.bodyResolver.resolveBodies(c);
        this.resolveImportsInAllFiles(c);
        ClassifierUsageCheckerKt.checkClassifierUsages(declarations2, this.classifierUsageCheckers, new ClassifierUsageCheckerContext(this.trace, this.languageVersionSettings, this.deprecationResolver, this.moduleDescriptor));
        return c;
    }

    public static /* synthetic */ TopDownAnalysisContext analyzeDeclarations$default(LazyTopDownAnalyzer lazyTopDownAnalyzer, TopDownAnalysisMode topDownAnalysisMode, Collection collection, DataFlowInfo dataFlowInfo, ExpressionTypingContext expressionTypingContext, int n, Object object) {
        if ((n & 4) != 0) {
            dataFlowInfo = DataFlowInfo.Companion.getEMPTY();
        }
        if ((n & 8) != 0) {
            expressionTypingContext = null;
        }
        return lazyTopDownAnalyzer.analyzeDeclarations(topDownAnalysisMode, collection, dataFlowInfo, expressionTypingContext);
    }

    private final void resolveAllHeadersInClasses(TopDownAnalysisContext c) {
        for (ClassDescriptorWithResolutionScopes classDescriptor2 : c.getAllClasses()) {
            Intrinsics.checkNotNull((Object)classDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor");
            ((LazyClassDescriptor)classDescriptor2).resolveMemberHeaders();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveImportsInAllFiles(TopDownAnalysisContext c) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<KtFile> collection = c.getFiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getFiles(...)");
        Iterable iterable = c.getScripts().keySet();
        Collection<KtFile> collection2 = collection;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtScript ktScript = (KtScript)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(it.getContainingKtFile());
        }
        for (KtFile file2 : CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv))) {
            Intrinsics.checkNotNull((Object)file2);
            this.resolveImportsInFile(file2);
        }
    }

    public final void resolveImportsInFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.fileScopeProvider.getImportResolver(file2).forceResolveNonDefaultImports();
    }

    private final void createTypeAliasDescriptors(TopDownAnalysisContext c, Multimap<FqName, KtElement> topLevelFqNames, List<KtTypeAlias> typeAliases) {
        for (KtTypeAlias typeAlias : typeAliases) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(typeAlias);
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.TypeAliasDescriptor");
            TypeAliasDescriptor descriptor2 = (TypeAliasDescriptor)declarationDescriptor;
            Map<KtTypeAlias, TypeAliasDescriptor> map = c.getTypeAliases();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getTypeAliases(...)");
            map.put(typeAlias, descriptor2);
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            this.registerTopLevelFqName(topLevelFqNames, typeAlias, descriptor2);
        }
    }

    private final void createPropertyDescriptors(TopDownAnalysisContext c, Multimap<FqName, KtElement> topLevelFqNames, List<? extends KtProperty> properties2) {
        for (KtProperty ktProperty : properties2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(ktProperty);
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
            PropertyDescriptor descriptor2 = (PropertyDescriptor)declarationDescriptor;
            c.getProperties().put(ktProperty, descriptor2);
            this.registerTopLevelFqName(topLevelFqNames, ktProperty, descriptor2);
        }
    }

    private final void createFunctionDescriptors(TopDownAnalysisContext c, List<? extends KtNamedFunction> functions2) {
        for (KtNamedFunction ktNamedFunction : functions2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(ktNamedFunction);
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)declarationDescriptor;
            c.getFunctions().put(ktNamedFunction, simpleFunctionDescriptor);
            ForceResolveUtil.forceResolveAllContents(simpleFunctionDescriptor.getAnnotations());
            for (ValueParameterDescriptor parameterDescriptor : simpleFunctionDescriptor.getValueParameters()) {
                ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
            }
        }
    }

    private final void createPropertiesFromDestructuringDeclarations(TopDownAnalysisContext c, Multimap<FqName, KtElement> topLevelFqNames, List<? extends KtDestructuringDeclaration> destructuringDeclarations) {
        for (KtDestructuringDeclaration ktDestructuringDeclaration : destructuringDeclarations) {
            for (KtDestructuringDeclarationEntry entry : ktDestructuringDeclaration.getEntries()) {
                Intrinsics.checkNotNull((Object)entry);
                DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(entry);
                Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                PropertyDescriptor descriptor2 = (PropertyDescriptor)declarationDescriptor;
                Map<KtDestructuringDeclarationEntry, PropertyDescriptor> map = c.getDestructuringDeclarationEntries();
                Intrinsics.checkNotNullExpressionValue(map, (String)"getDestructuringDeclarationEntries(...)");
                map.put(entry, descriptor2);
                ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
                this.registerTopLevelFqName(topLevelFqNames, entry, descriptor2);
            }
        }
    }

    private final void registerTopLevelFqName(Multimap<FqName, KtElement> topLevelFqNames, KtNamedDeclaration declaration, DeclarationDescriptor descriptor2) {
        FqName fqName2;
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && (fqName2 = declaration.getFqName()) != null) {
            topLevelFqNames.put(fqName2, declaration);
        }
    }

    public static final /* synthetic */ LazyDeclarationResolver access$getLazyDeclarationResolver$p(LazyTopDownAnalyzer $this) {
        return $this.lazyDeclarationResolver;
    }

    public static final /* synthetic */ FilePreprocessor access$getFilePreprocessor$p(LazyTopDownAnalyzer $this) {
        return $this.filePreprocessor;
    }

    public static final /* synthetic */ QualifiedExpressionResolver access$getQualifiedExpressionResolver$p(LazyTopDownAnalyzer $this) {
        return $this.qualifiedExpressionResolver;
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(LazyTopDownAnalyzer $this) {
        return $this.moduleDescriptor;
    }

    public static final /* synthetic */ BindingTrace access$getTrace$p(LazyTopDownAnalyzer $this) {
        return $this.trace;
    }

    public static final /* synthetic */ FileScopeProvider access$getFileScopeProvider$p(LazyTopDownAnalyzer $this) {
        return $this.fileScopeProvider;
    }

    public static final /* synthetic */ void access$registerTopLevelFqName(LazyTopDownAnalyzer $this, Multimap topLevelFqNames, KtNamedDeclaration declaration, DeclarationDescriptor descriptor2) {
        $this.registerTopLevelFqName(topLevelFqNames, declaration, descriptor2);
    }

    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(LazyTopDownAnalyzer $this) {
        return $this.identifierChecker;
    }
}

