/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.DirElementInfo;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.HardElementInfo;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance(SmartPsiElementPointerImpl.class);
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    protected final SmartPointerManagerImpl myManager;
    private byte myReferenceCount;
    @Nullable
    SmartPointerTracker.PointerReference pointerReference;

    SmartPsiElementPointerImpl(@NotNull SmartPointerManagerImpl manager, @NotNull E element, @Nullable PsiFile containingFile, boolean forInjected) {
        if (manager == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(1);
        }
        this(manager, element, SmartPsiElementPointerImpl.createElementInfo(manager, element, containingFile, forInjected));
    }

    SmartPsiElementPointerImpl(@NotNull SmartPointerManagerImpl manager, @NotNull E element, @NotNull SmartPointerElementInfo elementInfo) {
        if (manager == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(3);
        }
        if (elementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(4);
        }
        this.myReferenceCount = 1;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElementInfo = elementInfo;
        this.myManager = manager;
        this.cacheElement(element);
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Override
    @Nullable
    public E getElement() {
        if (this.getProject().isDisposed()) {
            return null;
        }
        E element = this.getCachedElement();
        if (element == null || !element.isValid()) {
            element = this.doRestoreElement();
            this.cacheElement(element);
        }
        return element;
    }

    @Nullable
    E doRestoreElement() {
        PsiElement element = this.myElementInfo.restoreElement(this.myManager);
        if (element != null && !element.isValid()) {
            return null;
        }
        return (E)element;
    }

    void cacheElement(@Nullable E element) {
        this.myElement = element == null ? null : (PsiManagerEx.getInstanceEx(this.getProject()).isBatchFilesProcessingMode() ? new WeakReference<E>(element) : new java.lang.ref.SoftReference<E>(element));
    }

    public E getCachedElement() {
        return (E)((PsiElement)SoftReference.dereference(this.myElement));
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file2 = this.getElementInfo().restoreFile(this.myManager);
        if (file2 != null) {
            return file2;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved == null ? null : resolved.getContainingFile();
        }
        return PsiDocumentManager.getInstance(this.getProject()).getPsiFile(doc);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.myElementInfo.getRange(this.myManager);
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return this.myElementInfo.getPsiRange(this.myManager);
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(@NotNull SmartPointerManagerImpl manager, @NotNull E element, @Nullable PsiFile containingFile, boolean forInjected) {
        if (manager == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(7);
        }
        SmartPointerElementInfo elementInfo = SmartPsiElementPointerImpl.doCreateElementInfo(manager.getProject(), element, containingFile, forInjected);
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest()) {
            PsiElement restoredElement = elementInfo.restoreElement(manager);
            if (restoredElement == null) {
                elementInfo = SmartPsiElementPointerImpl.doCreateElementInfo(manager.getProject(), element, containingFile, !forInjected);
                restoredElement = elementInfo.restoreElement(manager);
            }
            if (!element.equals(restoredElement)) {
                LOG.error("Cannot restore " + element + " of " + element.getClass() + " from " + elementInfo + "; restored=" + restoredElement + (restoredElement == null ? "" : " of " + restoredElement.getClass()) + " in " + element.getProject());
            }
        }
        SmartPointerElementInfo smartPointerElementInfo = elementInfo;
        if (smartPointerElementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(8);
        }
        return smartPointerElementInfo;
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo doCreateElementInfo(@NotNull Project project, @NotNull E element, @Nullable PsiFile containingFile, boolean forInjected) {
        SmartPointerElementInfo info;
        if (project == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(9);
        }
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(10);
        }
        if (element instanceof PsiDirectory) {
            return new DirElementInfo((PsiDirectory)element);
        }
        if (element instanceof PsiCompiledElement || containingFile == null) {
            if (element instanceof StubBasedPsiElement && element instanceof PsiCompiledElement) {
                if (element instanceof PsiFile) {
                    return new FileElementInfo((PsiFile)element);
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element, containingFile);
                if (stubReference != null) {
                    return new ClsElementInfo(stubReference);
                }
            }
            return new HardElementInfo(element);
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider && SmartPsiElementPointerImpl.hasReliableRange(element, containingFile)) {
            PsiLanguageInjectionHost hostContext = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile);
            TextRange elementRange = element.getTextRange();
            if (hostContext != null && elementRange != null) {
                SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(hostContext);
                return new InjectedSelfElementInfo(project, element, elementRange, containingFile, hostPointer);
            }
        }
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        if (element instanceof PsiFile) {
            FileViewProvider restored = PsiManager.getInstance(project).findViewProvider(virtualFile);
            return restored != null && restored.getPsi(LanguageUtil.getRootLanguage(element)) == element ? new FileElementInfo((PsiFile)element) : new HardElementInfo(element);
        }
        if (!SmartPsiElementPointerImpl.hasReliableRange(element, containingFile)) {
            return new HardElementInfo(element);
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).getSynchronizer().isDocumentAffectedByTransactions(document)) {
            LOG.error("Smart pointers must not be created during PSI changes");
        }
        if ((info = SmartPsiElementPointerImpl.createAnchorInfo(element, containingFile)) != null) {
            SmartPointerElementInfo smartPointerElementInfo = info;
            if (smartPointerElementInfo == null) {
                SmartPsiElementPointerImpl.$$$reportNull$$$0(11);
            }
            return smartPointerElementInfo;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange == null) {
            return new HardElementInfo(element);
        }
        Identikit.ByType identikit = Identikit.fromPsi(element, LanguageUtil.getRootLanguage(element));
        if (elementRange.isEmpty() && identikit.findPsiElement(containingFile, elementRange.getStartOffset(), elementRange.getEndOffset()) != element) {
            return new HardElementInfo(element);
        }
        if (!containingFile.isPhysical() && document == null) {
            return new HardElementInfo(element);
        }
        ProperTextRange proper = ProperTextRange.create(elementRange);
        return new SelfElementInfo(proper, identikit, containingFile, forInjected);
    }

    private static boolean hasReliableRange(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(12);
        }
        if (containingFile == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(13);
        }
        return (element instanceof ASTDelegatePsiElement || element instanceof ASTNode) && !SmartPsiElementPointerImpl.isFakePsiInNormalFile(element, containingFile);
    }

    private static boolean isFakePsiInNormalFile(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(14);
        }
        if (containingFile == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(15);
        }
        if (element.isPhysical()) {
            return false;
        }
        if (containingFile.isPhysical()) {
            return true;
        }
        TextRange range = element.getTextRange();
        return range == null || PsiTreeUtil.findElementOfClassAtRange(containingFile, range.getStartOffset(), range.getEndOffset(), element.getClass()) != element;
    }

    @Nullable
    private static SmartPointerElementInfo createAnchorInfo(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        StubBasedPsiElement stubPsi;
        int stubId;
        IStubFileElementType<?> stubType;
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(16);
        }
        if (containingFile == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(17);
        }
        if (element instanceof StubBasedPsiElement && containingFile instanceof PsiFileImpl && (stubType = ((PsiFileImpl)containingFile).getElementTypeForStubBuilder()) != null && stubType.shouldBuildStubFor(containingFile.getViewProvider().getVirtualFile()) && (stubId = PsiAnchor.calcStubIndex(stubPsi = (StubBasedPsiElement)element)) != -1) {
            return new AnchorElementInfo(element, (PsiFileImpl)containingFile, stubId, stubPsi.getElementType());
        }
        Pair<Identikit.ByAnchor, PsiElement> pair = Identikit.withAnchor(element, LanguageUtil.getRootLanguage(containingFile));
        if (pair != null) {
            return new AnchorElementInfo((PsiElement)pair.second, containingFile, (Identikit.ByAnchor)pair.first);
        }
        return null;
    }

    @NotNull
    SmartPointerElementInfo getElementInfo() {
        SmartPointerElementInfo smartPointerElementInfo = this.myElementInfo;
        if (smartPointerElementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(18);
        }
        return smartPointerElementInfo;
    }

    static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer<?> pointer1, @NotNull SmartPsiElementPointer<?> pointer2) {
        if (pointer1 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(19);
        }
        if (pointer2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(20);
        }
        if (pointer1 == pointer2) {
            return true;
        }
        ProgressManager.checkCanceled();
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo(), impl1.myManager)) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || cachedElement1.equals(cachedElement2);
        }
        return Comparing.equal(pointer1.getElement(), pointer2.getElement());
    }

    synchronized int incrementAndGetReferenceCount(int delta) {
        if (this.myReferenceCount == 127) {
            return 127;
        }
        if (this.myReferenceCount == 0) {
            return -1;
        }
        this.myReferenceCount = (byte)(this.myReferenceCount + delta);
        return this.myReferenceCount;
    }

    public String toString() {
        return this.myElementInfo.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInfo";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateElementInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createElementInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doCreateElementInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasReliableRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isFakePsiInNormalFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAnchorInfo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

