/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FastStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t*\u0001\u000f\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002'(B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020\u0015J\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0015J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0015J\b\u0010&\u001a\u00020 H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R6\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0012j\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR6\u0010\u001c\u001a*\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0012j\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "skipBreakContinueGotoEdges", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "analyzer", "org/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$analyzer$1", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$analyzer$1;", "loopEntryPointMarkers", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/utils/SmartList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "value", "", "maxExtraStackSize", "getMaxExtraStackSize", "()I", "spilledStacks", "", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "analyze", "", "getStackToSpill", "location", "getActualStack", "getActualStackSize", "getExpectedStackSize", "recordLoopEntryPointMarkers", "Companion", "FixStackFrame", "backend"})
@SourceDebugExtension(value={"SMAP\nFixStackAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,209:1\n384#2,7:210\n*S KotlinDebug\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer\n*L\n93#1:210,7\n*E\n"})
public final class FixStackAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FixStackContext context;
    private final boolean skipBreakContinueGotoEdges;
    @NotNull
    private final analyzer.1 analyzer;
    @NotNull
    private final HashMap<LabelNode, SmartList<AbstractInsnNode>> loopEntryPointMarkers;
    private int maxExtraStackSize;
    @NotNull
    private final HashMap<AbstractInsnNode, List<FixStackValue>> spilledStacks;
    public static final int DEAD_CODE_STACK_SIZE = -1;

    public FixStackAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull FixStackContext context, boolean skipBreakContinueGotoEdges) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.skipBreakContinueGotoEdges = skipBreakContinueGotoEdges;
        FixStackInterpreter fixStackInterpreter = new FixStackInterpreter();
        Function2 function2 = (arg_0, arg_1) -> FixStackAnalyzer.analyzer$lambda$0(this, arg_0, arg_1);
        this.analyzer = new FastStackAnalyzer<FixStackValue, FixStackFrame>(owner, method, this, fixStackInterpreter, (Function2<? super Integer, ? super Integer, FixStackFrame>)function2){
            final /* synthetic */ FixStackAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super($owner, $method, $super_call_param$1, $super_call_param$2);
            }

            protected boolean visitControlFlowEdge(AbstractInsnNode insnNode, int successor) {
                Intrinsics.checkNotNullParameter((Object)insnNode, (String)"insnNode");
                return !FixStackAnalyzer.access$getSkipBreakContinueGotoEdges$p(this.this$0) || !(insnNode instanceof JumpInsnNode) || !this.this$0.getContext().getBreakContinueGotoNodes().contains(insnNode);
            }
        };
        this.loopEntryPointMarkers = new HashMap();
        this.spilledStacks = new HashMap();
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    public final int getMaxExtraStackSize() {
        return this.maxExtraStackSize;
    }

    public final void analyze() {
        this.recordLoopEntryPointMarkers();
        this.analyzer.analyze();
    }

    @Nullable
    public final List<FixStackValue> getStackToSpill(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.spilledStacks.get(location);
    }

    @Nullable
    public final List<FixStackValue> getActualStack(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        FixStackFrame fixStackFrame = (FixStackFrame)this.analyzer.getFrame(location);
        return fixStackFrame != null ? fixStackFrame.getStackContent() : null;
    }

    public final int getActualStackSize(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        FixStackFrame fixStackFrame = (FixStackFrame)this.analyzer.getFrame(location);
        return fixStackFrame != null ? fixStackFrame.getStackSizeWithExtra() : -1;
    }

    public final int getExpectedStackSize(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        SmartList smartList = (SmartList)((Map)this.loopEntryPointMarkers).get(location);
        List expectedStackSizeNodes = smartList != null ? (List)smartList : CollectionsKt.listOf((Object)location);
        for (AbstractInsnNode node : expectedStackSizeNodes) {
            FixStackFrame fixStackFrame = (FixStackFrame)this.analyzer.getFrame(node);
            if (fixStackFrame == null) continue;
            FixStackFrame frame = fixStackFrame;
            return frame.getStackSizeWithExtra();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final void recordLoopEntryPointMarkers() {
        Iterator<AbstractInsnNode> iterator2 = this.context.getFakeAlwaysFalseIfeqMarkers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<AbstractInsnNode> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            AbstractInsnNode marker;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            AbstractInsnNode next = marker.getNext();
            if (!(next instanceof JumpInsnNode)) continue;
            Map map = this.loopEntryPointMarkers;
            LabelNode key$iv = ((JumpInsnNode)next).label;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SmartList answer$iv = new SmartList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((SmartList)object).add(marker);
        }
    }

    private static final FixStackFrame analyzer$lambda$0(FixStackAnalyzer this$0, int nLocals, int nStack) {
        return this$0.new FixStackFrame(nLocals, nStack);
    }

    public static final /* synthetic */ boolean access$getSkipBreakContinueGotoEdges$p(FixStackAnalyzer $this) {
        return $this.skipBreakContinueGotoEdges;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$Companion;", "", "<init>", "()V", "DEAD_CODE_STACK_SIZE", "", "backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0016\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0002H\u0016J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J&\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "nLocals", "", "nStack", "<init>", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;II)V", "extraStack", "Lcom/intellij/util/containers/Stack;", "init", "src", "clearStack", "", "execute", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "stackSizeWithExtra", "getStackSizeWithExtra", "()I", "getStackContent", "", "push", "value", "pushAll", "values", "", "pop", "setStack", "i", "merge", "", "frame", "executeBeforeInlineCallMarker", "saveStackAndClear", "executeAfterInlineCallMarker", "executeRestoreStackInTryCatch", "executeSaveStackBeforeTry", "backend"})
    @SourceDebugExtension(value={"SMAP\nFixStackAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1869#2,2:210\n*S KotlinDebug\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame\n*L\n150#1:210,2\n*E\n"})
    public final class FixStackFrame
    extends Frame<FixStackValue> {
        @NotNull
        private final Stack<FixStackValue> extraStack;

        public FixStackFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
            this.extraStack = new Stack();
        }

        @Override
        @NotNull
        public Frame<FixStackValue> init(@NotNull Frame<? extends FixStackValue> src) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            this.extraStack.clear();
            this.extraStack.addAll((Collection)((FixStackFrame)src).extraStack);
            Frame<FixStackValue> frame = super.init(src);
            Intrinsics.checkNotNullExpressionValue(frame, (String)"init(...)");
            return frame;
        }

        @Override
        public void clearStack() {
            this.extraStack.clear();
            super.clearStack();
        }

        @Override
        public void execute(@NotNull AbstractInsnNode insn, @NotNull Interpreter<FixStackValue> interpreter2) {
            Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
            Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
            if (PseudoInsn.SAVE_STACK_BEFORE_TRY.isa(insn)) {
                this.executeSaveStackBeforeTry(insn);
            } else if (PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.isa(insn)) {
                this.executeRestoreStackInTryCatch(insn);
            } else if (InlineCodegenUtilsKt.isBeforeInlineMarker(insn)) {
                this.executeBeforeInlineCallMarker(insn);
            } else if (InlineCodegenUtilsKt.isAfterInlineMarker(insn)) {
                this.executeAfterInlineCallMarker(insn);
            } else if (insn.getOpcode() == 177) {
                return;
            }
            super.execute(insn, interpreter2);
        }

        public final int getStackSizeWithExtra() {
            return super.getStackSize() + this.extraStack.size();
        }

        @NotNull
        public final List<FixStackValue> getStackContent() {
            ArrayList savedStack = new ArrayList();
            int n = super.getStackSize();
            for (int i = 0; i < n; ++i) {
                savedStack.add(super.getStack(i));
            }
            savedStack.addAll((Collection)this.extraStack);
            return savedStack;
        }

        @Override
        public void push(@NotNull FixStackValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            if (super.getStackSize() < this.getMaxStackSize()) {
                super.push((Value)value2);
            } else {
                this.extraStack.add(value2);
                FixStackAnalyzer.this.maxExtraStackSize = Math.max(FixStackAnalyzer.this.getMaxExtraStackSize(), this.extraStack.size());
            }
        }

        private final void pushAll(Collection<? extends FixStackValue> values2) {
            Iterable $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FixStackValue it = (FixStackValue)element$iv;
                boolean bl = false;
                this.push(it);
            }
        }

        @Override
        @NotNull
        public FixStackValue pop() {
            FixStackValue fixStackValue;
            if (!((Collection)this.extraStack).isEmpty()) {
                FixStackValue fixStackValue2 = this.extraStack.pop();
                Intrinsics.checkNotNull((Object)fixStackValue2);
                fixStackValue = fixStackValue2;
            } else {
                Object v = super.pop();
                Intrinsics.checkNotNull(v);
                fixStackValue = (FixStackValue)v;
            }
            return fixStackValue;
        }

        @Override
        public void setStack(int i, @NotNull FixStackValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            if (i < super.getMaxStackSize()) {
                super.setStack(i, (Value)value2);
            } else {
                this.extraStack.set(i - this.getMaxStackSize(), value2);
            }
        }

        @Override
        public boolean merge(@NotNull Frame<? extends FixStackValue> frame, @NotNull Interpreter<FixStackValue> interpreter2) {
            Intrinsics.checkNotNullParameter(frame, (String)"frame");
            Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
            throw new UnsupportedOperationException("Stack normalization should not merge frames");
        }

        private final void executeBeforeInlineCallMarker(AbstractInsnNode insn) {
            this.saveStackAndClear(insn);
        }

        private final void saveStackAndClear(AbstractInsnNode insn) {
            List<FixStackValue> savedValues = this.getStackContent();
            ((Map)FixStackAnalyzer.this.spilledStacks).put(insn, savedValues);
            this.clearStack();
        }

        private final void executeAfterInlineCallMarker(AbstractInsnNode insn) {
            AbstractInsnNode beforeInlineMarker = FixStackAnalyzer.this.getContext().getOpeningInlineMethodMarker().get(insn);
            if (this.getStackSize() > 0) {
                List savedValues;
                FixStackValue returnValue = this.pop();
                this.clearStack();
                List list = savedValues = (List)((Map)FixStackAnalyzer.this.spilledStacks).get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)list);
                this.pushAll(list);
                this.push(returnValue);
            } else {
                List savedValues;
                List list = savedValues = (List)((Map)FixStackAnalyzer.this.spilledStacks).get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)list);
                this.pushAll(list);
            }
        }

        private final void executeRestoreStackInTryCatch(AbstractInsnNode insn) {
            AbstractInsnNode saveNode = FixStackAnalyzer.this.getContext().getSaveStackMarkerForRestoreMarker().get(insn);
            Map map = FixStackAnalyzer.this.spilledStacks;
            AbstractInsnNode abstractInsnNode = saveNode;
            Intrinsics.checkNotNull((Object)abstractInsnNode);
            Object v = map.get(abstractInsnNode);
            if (v == null) {
                boolean bl = false;
                throw new AssertionError((Object)(InlineCodegenUtilsKt.getInsnText(insn) + ": Restore stack is unavailable for " + InlineCodegenUtilsKt.getInsnText(saveNode)));
            }
            List savedValues = (List)v;
            this.pushAll(savedValues);
        }

        private final void executeSaveStackBeforeTry(AbstractInsnNode insn) {
            this.saveStackAndClear(insn);
        }
    }
}

