/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.DefinitelyNotNullTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ReifiedTypeParameterSubstitutionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        if (resolvedCall2 == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(0);
        }
        if (reportOn == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(2);
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments = resolvedCall2.getTypeArguments();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments.entrySet()) {
            TypeParameterDescriptor parameter = entry.getKey();
            KotlinType argument = entry.getValue();
            ClassifierDescriptor argumentDeclarationDescriptor = argument.getConstructor().getDeclarationDescriptor();
            if (!parameter.isReified() && !ReifiedTypeParameterSubstitutionChecker.isTypeParameterOfKotlinArray(parameter)) continue;
            KtTypeProjection typeProjection = (KtTypeProjection)CollectionsKt.getOrNull(resolvedCall2.getCall().getTypeArguments(), (int)parameter.getIndex());
            this.checkTypeArgument(typeProjection != null ? typeProjection : reportOn, context, argument, argumentDeclarationDescriptor, false);
            if (typeProjection == null || !(argument instanceof DefinitelyNotNullTypeMarker)) continue;
            context.getTrace().report(Errors.DEFINITELY_NON_NULLABLE_AS_REIFIED.on(typeProjection));
        }
    }

    private void checkTypeArgument(@NotNull PsiElement reportErrorOn, @NotNull CallCheckerContext context, KotlinType argument, ClassifierDescriptor argumentDeclarationDescriptor, boolean isArrayArgumentCheck) {
        if (reportErrorOn == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(4);
        }
        if (argumentDeclarationDescriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)argumentDeclarationDescriptor;
            if (typeParameter.isReified()) {
                return;
            }
            DiagnosticFactory1 diagnosticFactory = isArrayArgumentCheck ? (DiagnosticFactory1)Errors.TYPE_PARAMETER_AS_REIFIED_ARRAY.chooseFactory(context.getLanguageVersionSettings()) : Errors.TYPE_PARAMETER_AS_REIFIED;
            context.getTrace().report(diagnosticFactory.on(reportErrorOn, typeParameter));
        } else if (TypeUtilsKt.cannotBeReified(argument)) {
            context.getTrace().report(Errors.REIFIED_TYPE_FORBIDDEN_SUBSTITUTION.on(reportErrorOn, argument));
        } else if (argumentDeclarationDescriptor instanceof ClassDescriptor && KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)argumentDeclarationDescriptor)) {
            KotlinType arrayTypeArgument = argument.getArguments().get(0).getType();
            ClassifierDescriptor arrayTypeArgumentDescriptor = arrayTypeArgument.getConstructor().getDeclarationDescriptor();
            this.checkTypeArgument(reportErrorOn, context, arrayTypeArgument, arrayTypeArgumentDescriptor, true);
        }
    }

    private static boolean isTypeParameterOfKotlinArray(@NotNull TypeParameterDescriptor parameter) {
        DeclarationDescriptor container;
        if (parameter == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(5);
        }
        return (container = parameter.getContainingDeclaration()) instanceof ClassDescriptor && KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)container);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportOn";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportErrorOn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeArgument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeParameterOfKotlinArray";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

