/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers.expressions;

import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContext;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContextKt;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibErrors;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExpressionChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/expressions/JsKlibJsCodeCallChecker;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibCallChecker;", "<init>", "()V", "jsCodeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isJsFunCall", "", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;", "reporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "JsErrorReporter", "ir.serialization.js"})
public final class JsKlibJsCodeCallChecker
implements JsKlibExpressionChecker<IrCall> {
    @NotNull
    public static final JsKlibJsCodeCallChecker INSTANCE = new JsKlibJsCodeCallChecker();
    @NotNull
    private static final FqName jsCodeFqName = JsStandardClassIds.Callables.JsCode.asSingleFqName();

    private JsKlibJsCodeCallChecker() {
    }

    private final boolean isJsFunCall(IrCall $this$isJsFunCall) {
        return $this$isJsFunCall.getSymbol().isBound() ? AdditionalIrUtilsKt.hasEqualFqName((IrDeclarationWithName)$this$isJsFunCall.getSymbol().getOwner(), jsCodeFqName) : AdditionalIrUtilsKt.hasEqualFqName($this$isJsFunCall.getSymbol(), jsCodeFqName);
    }

    @Override
    public void check(@NotNull IrCall expression2, @NotNull JsKlibDiagnosticContext context2, @NotNull IrDiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!CommonConfigurationKeysKt.getLanguageVersionSettings(context2.getCompilerConfiguration()).getLanguageVersion().getUsesK2()) {
            return;
        }
        if (!this.isJsFunCall(expression2)) {
            return;
        }
        IrExpression jsCodeExpr = (IrExpression)expression2.getArguments().get(0);
        if (!(jsCodeExpr instanceof IrConst) || !Intrinsics.areEqual((Object)((IrConst)jsCodeExpr).getKind(), (Object)IrConstKind.String.INSTANCE)) {
            IrExpression irExpression = jsCodeExpr;
            if (irExpression == null) {
                irExpression = expression2;
            }
            JsKlibDiagnosticContextKt.at(reporter, irExpression, context2).report(JsKlibErrors.INSTANCE.getJSCODE_CAN_NOT_VERIFY_JAVASCRIPT());
            return;
        }
        Object object = ((IrConst)jsCodeExpr).getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String jsCodeStr = (String)object;
        try {
            Object fileName;
            JsErrorReporter jsErrorReporter;
            List<JsStatement> statements;
            Collection collection;
            JsFunctionScope parserScope = new JsFunctionScope(new JsRootScope(new JsProgram()), "<js fun>");
            Object object2 = context2.getContainingFile();
            if (object2 == null || (object2 = ((IrFile)object2).getFileEntry()) == null || (object2 = object2.getName()) == null) {
                object2 = "<unknown file>";
            }
            if ((collection = (Collection)(statements = ParserUtilsKt.parseExpressionOrStatement(jsCodeStr, jsErrorReporter = new JsErrorReporter(jsCodeExpr, context2, reporter), parserScope, new CodePosition(0, 0), (String)(fileName = object2)))) == null || collection.isEmpty()) {
                JsKlibDiagnosticContextKt.at(reporter, jsCodeExpr, context2).report(JsKlibErrors.INSTANCE.getJSCODE_NO_JAVASCRIPT_PRODUCED());
            }
        }
        catch (AbortParsingException abortParsingException) {
            // empty catch block
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/expressions/JsKlibJsCodeCallChecker$JsErrorReporter;", "Lcom/google/gwt/dev/js/rhino/ErrorReporter;", "codeExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;", "reporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;)V", "getCodeExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;", "getReporter", "()Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "warning", "", "message", "", "startPosition", "Lcom/google/gwt/dev/js/rhino/CodePosition;", "endPosition", "error", "ir.serialization.js"})
    private static final class JsErrorReporter
    implements ErrorReporter {
        @NotNull
        private final IrExpression codeExpression;
        @NotNull
        private final JsKlibDiagnosticContext context;
        @NotNull
        private final IrDiagnosticReporter reporter;

        public JsErrorReporter(@NotNull IrExpression codeExpression, @NotNull JsKlibDiagnosticContext context2, @NotNull IrDiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)codeExpression, (String)"codeExpression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.codeExpression = codeExpression;
            this.context = context2;
            this.reporter = reporter;
        }

        @NotNull
        public final IrExpression getCodeExpression() {
            return this.codeExpression;
        }

        @NotNull
        public final JsKlibDiagnosticContext getContext() {
            return this.context;
        }

        @NotNull
        public final IrDiagnosticReporter getReporter() {
            return this.reporter;
        }

        @Override
        public void warning(@NotNull String message2, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
            Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
            JsKlibDiagnosticContextKt.at(this.reporter, this.codeExpression, this.context).report(JsKlibErrors.INSTANCE.getJSCODE_WARNING(), message2);
        }

        @Override
        public void error(@NotNull String message2, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
            Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
            JsKlibDiagnosticContextKt.at(this.reporter, this.codeExpression, this.context).report(JsKlibErrors.INSTANCE.getJSCODE_ERROR(), message2);
            throw new AbortParsingException();
        }
    }
}

