/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.incremental;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.incremental.ClassSnapshot;
import org.jetbrains.kotlin.gradle.incremental.DataSerializer;
import org.jetbrains.kotlin.gradle.incremental.JavaClassSnapshot;
import org.jetbrains.kotlin.gradle.incremental.JavaClassSnapshotExternalizer;
import org.jetbrains.kotlin.gradle.incremental.KotlinClassSnapshot;
import org.jetbrains.kotlin.gradle.incremental.KotlinClassSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/incremental/ClassSnapshotDataSerializer;", "Lorg/jetbrains/kotlin/gradle/incremental/DataSerializer;", "Lorg/jetbrains/kotlin/gradle/incremental/ClassSnapshot;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "snapshot", "kotlin-gradle-plugin"})
public final class ClassSnapshotDataSerializer
implements DataSerializer<ClassSnapshot> {
    @NotNull
    public static final ClassSnapshotDataSerializer INSTANCE = new ClassSnapshotDataSerializer();

    private ClassSnapshotDataSerializer() {
    }

    public void save(@NotNull DataOutput output2, @NotNull ClassSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Object object = snapshot.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"snapshot.javaClass.name");
        ExternalizersKt.writeString((DataOutput)output2, (String)object);
        object = snapshot;
        if (object instanceof KotlinClassSnapshot) {
            KotlinClassSnapshotExternalizer.INSTANCE.save(output2, (KotlinClassSnapshot)snapshot);
        } else if (object instanceof JavaClassSnapshot) {
            JavaClassSnapshotExternalizer.INSTANCE.save(output2, (JavaClassSnapshot)snapshot);
        }
    }

    @NotNull
    public ClassSnapshot read(@NotNull DataInput input) {
        ClassSnapshot classSnapshot;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String className = ExternalizersKt.readString((DataInput)input);
        if (Intrinsics.areEqual((Object)className, (Object)KotlinClassSnapshot.class.getName())) {
            classSnapshot = KotlinClassSnapshotExternalizer.INSTANCE.read(input);
        } else if (Intrinsics.areEqual((Object)className, (Object)JavaClassSnapshot.class.getName())) {
            classSnapshot = JavaClassSnapshotExternalizer.INSTANCE.read(input);
        } else {
            throw (Throwable)new IllegalStateException(Intrinsics.stringPlus((String)"Unrecognized class: ", (Object)className).toString());
        }
        return classSnapshot;
    }

    @Override
    @NotNull
    public ClassSnapshot fromByteArray(@NotNull byte[] byteArray) {
        return DataSerializer.DefaultImpls.fromByteArray(this, byteArray);
    }

    @Override
    @NotNull
    public ClassSnapshot load(@NotNull File file) {
        return DataSerializer.DefaultImpls.load(this, file);
    }

    @Override
    public void save(@NotNull File file, @NotNull ClassSnapshot value) {
        DataSerializer.DefaultImpls.save(this, file, value);
    }

    @Override
    @NotNull
    public byte[] toByteArray(@NotNull ClassSnapshot value) {
        return DataSerializer.DefaultImpls.toByteArray(this, value);
    }
}

