/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.CompilationSourceSetUtil;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultKotlinSourceSetKt;
import org.jetbrains.kotlin.gradle.plugin.sources.UnsatisfiedSourceSetVisibilityException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001c\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0006H\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a(\u0010\u000b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\b\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u0000\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"checkSourceSetVisibilityRequirements", "", "sourceSets", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "compilationsBySourceSet", "", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "project", "Lorg/gradle/api/Project;", "getSourceSetsFromAssociatedCompilations", "fromCompilation", "getVisibleSourceSetsFromAssociateCompilations", "", "participatesInCompilations", "sourceSet", "kotlin-gradle-plugin"})
public final class SourceSetsVisibilityInferenceKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<KotlinCompilation<?>, Set<KotlinSourceSet>> getSourceSetsFromAssociatedCompilations(@NotNull KotlinCompilation<?> fromCompilation) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(fromCompilation, (String)"fromCompilation");
        Iterable<KotlinCompilation<?>> $this$associate$iv = KotlinCompilationsKt.getAssociateWithTransitiveClosure(fromCompilation);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<KotlinCompilation<?>> iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            KotlinCompilation it = (KotlinCompilation)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)it.getAllKotlinSourceSets());
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final List<KotlinSourceSet> getVisibleSourceSetsFromAssociateCompilations(@NotNull Project project, @NotNull KotlinSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        return SourceSetsVisibilityInferenceKt.getVisibleSourceSetsFromAssociateCompilations((Set)MapsKt.getValue(CompilationSourceSetUtil.INSTANCE.compilationsBySourceSets(project), (Object)sourceSet));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinSourceSet> getVisibleSourceSetsFromAssociateCompilations(@NotNull Set<? extends KotlinCompilation<?>> participatesInCompilations) {
        Set set2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participatesInCompilations, (String)"participatesInCompilations");
        Iterable $this$map$iv = participatesInCompilations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Set set3;
            void it;
            KotlinCompilation kotlinCompilation = (KotlinCompilation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<KotlinCompilation<?>, Set<KotlinSourceSet>> sourceSetsInAssociatedCompilations = SourceSetsVisibilityInferenceKt.getSourceSetsFromAssociatedCompilations(it);
            int n = sourceSetsInAssociatedCompilations.size();
            switch (n) {
                case 0: {
                    set3 = SetsKt.emptySet();
                    break;
                }
                case 1: {
                    set3 = (Set)CollectionsKt.single((Iterable)sourceSetsInAssociatedCompilations.values());
                    break;
                }
                default: {
                    Set set4;
                    Set $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u2d2_u24lambda_u2d1 = set4 = (Set)new LinkedHashSet();
                    boolean bl2 = false;
                    for (Map.Entry<KotlinCompilation<?>, Set<KotlinSourceSet>> entry : sourceSetsInAssociatedCompilations.entrySet()) {
                        Set<KotlinSourceSet> sourceSets = entry.getValue();
                        $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u2d2_u24lambda_u2d1.addAll((Collection)sourceSets);
                    }
                    set3 = set4;
                }
            }
            Set set5 = set3;
            collection.add(set5);
        }
        List visibleInCompilations = (List)destination$iv$iv;
        int n = visibleInCompilations.size();
        switch (n) {
            case 0: {
                set2 = SetsKt.emptySet();
                break;
            }
            case 1: {
                set2 = (Set)CollectionsKt.single((List)visibleInCompilations);
                break;
            }
            default: {
                Set set6;
                Set $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u2d4 = set6 = CollectionsKt.toMutableSet((Iterable)((Iterable)CollectionsKt.first((List)visibleInCompilations)));
                boolean bl = false;
                Iterable $this$forEach$iv = visibleInCompilations.subList(1, visibleInCompilations.size());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Set it = (Set)element$iv;
                    boolean bl3 = false;
                    $this$getVisibleSourceSetsFromAssociateCompilations_u24lambda_u2d4.retainAll(it);
                }
                set2 = set6;
            }
        }
        return CollectionsKt.toList((Iterable)set2);
    }

    public static final void checkSourceSetVisibilityRequirements(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SourceSetsVisibilityInferenceKt.checkSourceSetVisibilityRequirements((Iterable)KotlinProjectExtensionKt.getKotlinExtension(project).getSourceSets(), CompilationSourceSetUtil.INSTANCE.compilationsBySourceSets(project));
    }

    public static final void checkSourceSetVisibilityRequirements(@NotNull Iterable<? extends KotlinSourceSet> sourceSets, @NotNull Map<KotlinSourceSet, ? extends Set<? extends KotlinCompilation<?>>> compilationsBySourceSet) {
        Intrinsics.checkNotNullParameter(sourceSets, (String)"sourceSets");
        Intrinsics.checkNotNullParameter(compilationsBySourceSet, (String)"compilationsBySourceSet");
        Iterable<? extends KotlinSourceSet> $this$forEach$iv = sourceSets;
        boolean $i$f$forEach = false;
        Iterator<? extends KotlinSourceSet> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            List<KotlinSourceSet> inferredVisibility;
            Set requiredButNotVisible;
            KotlinSourceSet element$iv;
            KotlinSourceSet sourceSet = element$iv = iterator.next();
            boolean bl = false;
            Set requiredVisibility = sourceSet.getRequiresVisibilityOf();
            Set set2 = compilationsBySourceSet.get(sourceSet);
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            if (!(!((Collection)(requiredButNotVisible = SetsKt.minus((Set)SetsKt.minus((Set)requiredVisibility, (Iterable)(inferredVisibility = SourceSetsVisibilityInferenceKt.getVisibleSourceSetsFromAssociateCompilations(set2))), (Iterable)DefaultKotlinSourceSetKt.withAllDependsOnSourceSets(sourceSet)))).isEmpty())) continue;
            Set compilations = (Set)MapsKt.getValue(compilationsBySourceSet, (Object)sourceSet);
            throw new UnsatisfiedSourceSetVisibilityException(sourceSet, compilations, inferredVisibility, requiredButNotVisible);
        }
    }
}

