/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.TaskOutputsBackup;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0006\u0010%\u001a\u00020\"J\u0006\u0010&\u001a\u00020\"J\u0006\u0010'\u001a\u00020\"J\u0018\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u0019*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "snapshotsDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "outputs", "Lorg/gradle/api/file/FileCollection;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/file/FileSystemOperations;Lorg/gradle/api/file/DirectoryProperty;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/logging/Logger;)V", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "getFileSystemOperations", "()Lorg/gradle/api/file/FileSystemOperations;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getOutputs", "()Lorg/gradle/api/file/FileCollection;", "getSnapshotsDir", "()Lorg/gradle/api/provider/Provider;", "normalizedToBeRelative", "", "Ljava/nio/file/Path;", "getNormalizedToBeRelative", "(Ljava/nio/file/Path;)Ljava/lang/String;", "pathRelativeToBuildDirectory", "Ljava/io/File;", "getPathRelativeToBuildDirectory", "(Ljava/io/File;)Ljava/lang/String;", "compressDirectoryToZip", "", "snapshotFile", "outputPath", "createSnapshot", "deleteSnapshot", "restoreOutputs", "uncompressZipIntoDirectory", "outputDirectory", "Companion", "kotlin-gradle-plugin"})
public final class TaskOutputsBackup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystemOperations fileSystemOperations;
    @NotNull
    private final DirectoryProperty buildDirectory;
    @NotNull
    private final Provider<Directory> snapshotsDir;
    @NotNull
    private final FileCollection outputs;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final String DIRECTORY_SNAPSHOT_ARCHIVE_FILE = "snapshot.zip";

    public TaskOutputsBackup(@NotNull FileSystemOperations fileSystemOperations, @NotNull DirectoryProperty buildDirectory, @NotNull Provider<Directory> snapshotsDir, @NotNull FileCollection outputs, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        Intrinsics.checkNotNullParameter((Object)buildDirectory, (String)"buildDirectory");
        Intrinsics.checkNotNullParameter(snapshotsDir, (String)"snapshotsDir");
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.fileSystemOperations = fileSystemOperations;
        this.buildDirectory = buildDirectory;
        this.snapshotsDir = snapshotsDir;
        this.outputs = outputs;
        this.logger = logger;
    }

    @NotNull
    public final FileSystemOperations getFileSystemOperations() {
        return this.fileSystemOperations;
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        return this.buildDirectory;
    }

    @NotNull
    public final Provider<Directory> getSnapshotsDir() {
        return this.snapshotsDir;
    }

    @NotNull
    public final FileCollection getOutputs() {
        return this.outputs;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void createSnapshot() {
        Set set2 = this.outputs.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"outputs.files");
        Iterable $this$forEachIndexed$iv = CollectionsKt.toSortedSet((Iterable)set2);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void outputPath;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            File file = (File)item$iv;
            int index = n;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append(index).append((Object)File.separator);
            Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
            String pathInSnapshot = stringBuilder.append(this.getPathRelativeToBuildDirectory((File)outputPath)).toString();
            if (outputPath.isDirectory()) {
                Object object = Files.list(outputPath.toPath());
                Throwable throwable = null;
                try {
                    Stream it22 = (Stream)object;
                    boolean bl3 = false;
                    boolean it22 = it22.findFirst().isPresent();
                }
                catch (Throwable it22) {
                    throwable = it22;
                    throw it22;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                }
                if (it22) {
                    Object $this$createSnapshot_u24lambda_u2d2_u24lambda_u2d1 = object = ((RegularFile)this.getSnapshotsDir().map(new Transformer(pathInSnapshot){
                        final /* synthetic */ String $pathInSnapshot;
                        {
                            this.$pathInSnapshot = $pathInSnapshot;
                        }

                        public final RegularFile transform(Directory it) {
                            return it.file(this.$pathInSnapshot);
                        }
                    }).get()).getAsFile();
                    boolean bl4 = false;
                    this.compressDirectoryToZip(new File((File)$this$createSnapshot_u24lambda_u2d2_u24lambda_u2d1, DIRECTORY_SNAPSHOT_ARCHIVE_FILE), (File)outputPath);
                    continue;
                }
            }
            this.getFileSystemOperations().copy(new Action((File)outputPath, this, pathInSnapshot){
                final /* synthetic */ File $outputPath;
                final /* synthetic */ TaskOutputsBackup this$0;
                final /* synthetic */ String $pathInSnapshot;
                {
                    this.$outputPath = $outputPath;
                    this.this$0 = $receiver;
                    this.$pathInSnapshot = $pathInSnapshot;
                }

                public final void execute(CopySpec spec) {
                    Object[] objectArray = new Object[]{this.$outputPath};
                    spec.from(objectArray);
                    spec.into((Object)this.this$0.getSnapshotsDir().map(new Transformer(this.$pathInSnapshot){
                        final /* synthetic */ String $pathInSnapshot;
                        {
                            this.$pathInSnapshot = $pathInSnapshot;
                        }

                        public final File transform(Directory it) {
                            return it.file(this.$pathInSnapshot).getAsFile().getParentFile();
                        }
                    }));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void restoreOutputs() {
        this.fileSystemOperations.delete(new Action(this){
            final /* synthetic */ TaskOutputsBackup this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DeleteSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getOutputs()};
                it.delete(objectArray);
            }
        });
        Set set2 = this.outputs.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"outputs.files");
        Iterable $this$forEachIndexed$iv = CollectionsKt.toSortedSet((Iterable)set2);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void outputPath;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            File file = (File)item$iv;
            int index = n;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append(index).append((Object)File.separator);
            Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
            String pathInSnapshot = stringBuilder.append(this.getPathRelativeToBuildDirectory((File)outputPath)).toString();
            File fileInSnapshot = ((Directory)this.getSnapshotsDir().get()).file(pathInSnapshot).getAsFile();
            if (fileInSnapshot.isDirectory()) {
                File snapshotArchive = new File(fileInSnapshot, DIRECTORY_SNAPSHOT_ARCHIVE_FILE);
                if (!snapshotArchive.exists()) {
                    this.getLogger().warn(StringsKt.trimMargin$default((String)("\n                        |Failed to restore task outputs as snapshot file " + snapshotArchive.getAbsolutePath() + " does not exist!\n                        |On recompilation full rebuild will be performed.\n                        "), null, (int)1, null));
                    return;
                }
                this.uncompressZipIntoDirectory(snapshotArchive, (File)outputPath);
                continue;
            }
            this.getFileSystemOperations().copy(new Action(this, (File)outputPath, pathInSnapshot){
                final /* synthetic */ TaskOutputsBackup this$0;
                final /* synthetic */ File $outputPath;
                final /* synthetic */ String $pathInSnapshot;
                {
                    this.this$0 = $receiver;
                    this.$outputPath = $outputPath;
                    this.$pathInSnapshot = $pathInSnapshot;
                }

                public final void execute(CopySpec spec) {
                    Object[] objectArray = new Object[]{this.this$0.getSnapshotsDir().map(new Transformer(this.$pathInSnapshot){
                        final /* synthetic */ String $pathInSnapshot;
                        {
                            this.$pathInSnapshot = $pathInSnapshot;
                        }

                        public final File transform(Directory it) {
                            return it.file(this.$pathInSnapshot).getAsFile().getParentFile();
                        }
                    })};
                    spec.from(objectArray);
                    spec.into((Object)this.$outputPath.getParentFile());
                }
            });
        }
    }

    public final void deleteSnapshot() {
        this.fileSystemOperations.delete(new Action(this){
            final /* synthetic */ TaskOutputsBackup this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DeleteSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getSnapshotsDir()};
                it.delete(objectArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void compressDirectoryToZip(File snapshotFile, File outputPath) {
        snapshotFile.getParentFile().mkdirs();
        snapshotFile.createNewFile();
        Closeable closeable = new FileOutputStream(snapshotFile);
        int n = 8192;
        closeable = new ZipOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipOutputStream zip = (ZipOutputStream)closeable;
            boolean bl = false;
            zip.setLevel(0);
            Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)outputPath)), (Function1)compressDirectoryToZip.1.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                ZipEntry entry = new ZipEntry(FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file, (File)outputPath)));
                zip.putNextEntry(entry);
                Closeable closeable2 = new FileInputStream(file);
                int n2 = 8192;
                closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n2);
                Throwable throwable2 = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)closeable2;
                    boolean bl3 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)zip, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                zip.closeEntry();
            }
            zip.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void uncompressZipIntoDirectory(File snapshotFile, File outputDirectory2) {
        Path outputPath = outputDirectory2.toPath();
        URI snapshotUri = URI.create(Intrinsics.stringPlus((String)"jar:", (Object)snapshotFile.toURI()));
        Closeable closeable = FileSystems.newFileSystem(snapshotUri, MapsKt.emptyMap());
        Throwable throwable = null;
        try {
            FileSystem zipFs = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = zipFs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"zipFs.rootDirectories");
            Iterable<Path> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<Path> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Path element$iv;
                Path rootDir2 = element$iv = iterator.next();
                boolean bl2 = false;
                AutoCloseable autoCloseable = Files.walk(rootDir2, new FileVisitOption[0]);
                Throwable throwable2 = null;
                try {
                    Stream paths = (Stream)autoCloseable;
                    boolean bl3 = false;
                    paths.forEach(new Consumer(outputPath, this){
                        final /* synthetic */ Path $outputPath;
                        final /* synthetic */ TaskOutputsBackup this$0;
                        {
                            this.$outputPath = $outputPath;
                            this.this$0 = $receiver;
                        }

                        public final void accept(Path it) {
                            if (Files.isDirectory(it, new LinkOption[0])) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                Files.createDirectories(this.$outputPath.resolve(TaskOutputsBackup.access$getNormalizedToBeRelative(this.this$0, it)), new FileAttribute[0]);
                            } else if (Files.isRegularFile(it, new LinkOption[0])) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(it, this.$outputPath.resolve(TaskOutputsBackup.access$getNormalizedToBeRelative(this.this$0, it)), copyOptionArray);
                            }
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String getNormalizedToBeRelative(Path $this$normalizedToBeRelative) {
        return Intrinsics.areEqual((Object)((Object)$this$normalizedToBeRelative).toString(), (Object)"/") ? "." : StringsKt.removePrefix((String)((Object)$this$normalizedToBeRelative).toString(), (CharSequence)"/");
    }

    private final String getPathRelativeToBuildDirectory(File $this$pathRelativeToBuildDirectory) {
        File buildDir2 = ((Directory)this.buildDirectory.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)buildDir2, (String)"buildDir");
        String string = FilesKt.relativeTo((File)$this$pathRelativeToBuildDirectory, (File)buildDir2).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"relativeTo(buildDir).path");
        return string;
    }

    public static final /* synthetic */ String access$getNormalizedToBeRelative(TaskOutputsBackup $this, Path $receiver) {
        return $this.getNormalizedToBeRelative($receiver);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup$Companion;", "", "()V", "DIRECTORY_SNAPSHOT_ARCHIVE_FILE", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

