/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributeKind;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriterKt;
import org.jetbrains.kotlin.gradle.report.TextTable;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.TaskExecutionData;
import org.jetbrains.kotlin.gradle.utils.Printer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriter;", "Ljava/io/Serializable;", "outputFile", "Ljava/io/File;", "printMetrics", "", "(Ljava/io/File;Z)V", "p", "Lorg/jetbrains/kotlin/gradle/utils/Printer;", "printBuildAttributes", "", "buildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "printBuildInfo", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "printBuildPerformanceMetrics", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetrics;", "printBuildReport", "printBuildTimes", "buildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "printTaskLog", "task", "Lorg/jetbrains/kotlin/gradle/report/data/TaskExecutionData;", "printTaskOverview", "printTasksLog", "process", "log", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin"})
public final class PlainTextBuildReportWriter
implements Serializable {
    @NotNull
    private final File outputFile;
    private final boolean printMetrics;
    private Printer p;

    public PlainTextBuildReportWriter(@NotNull File outputFile2, boolean printMetrics) {
        Intrinsics.checkNotNullParameter((Object)outputFile2, (String)"outputFile");
        this.outputFile = outputFile2;
        this.printMetrics = printMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull BuildExecutionData build, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        try {
            Object object;
            this.outputFile.getParentFile().mkdirs();
            if (!this.outputFile.getParentFile().exists() || !this.outputFile.getParentFile().isDirectory()) {
                log.error("Kotlin build report cannot be created: '" + this.outputFile + ".parentFile' is a file or do not have permissions to create");
                return;
            }
            Object object2 = this.outputFile;
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            Object object4 = object = object2;
            object = new OutputStreamWriter((OutputStream)(object4 = (OutputStream)new FileOutputStream((File)object4)), (Charset)object3);
            object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
            object3 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object2;
                boolean bl = false;
                this.p = new Printer(writer, null, null, 6, null);
                this.printBuildReport(build);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            log.lifecycle("Kotlin build report is written to " + this.outputFile.getCanonicalPath());
        }
        catch (Exception e) {
            log.error("Could not write Kotlin build report to " + this.outputFile.getCanonicalPath(), (Throwable)e);
        }
    }

    private final void printBuildReport(BuildExecutionData build) {
        this.printBuildInfo(build);
        this.printMetrics(build.getAggregatedMetrics());
        this.printTaskOverview(build);
        this.printTasksLog(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildInfo(BuildExecutionData build) {
        Printer printer;
        void this_$iv;
        String[] stringArray = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            stringArray = null;
        }
        String[] stringArray2 = stringArray;
        String headLine$iv = "Gradle start parameters:";
        boolean $i$f$withIndent = false;
        String[] stringArray3 = new String[]{headLine$iv};
        this_$iv.println(stringArray3);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = build.getStartParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                Printer printer2 = this.p;
                if (printer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer2 = null;
                }
                String[] stringArray4 = new String[]{it};
                printer2.println(stringArray4);
            }
            stringArray3 = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer3 = null;
        }
        printer3.println(new String[0]);
        if (!((Collection)build.getFailureMessages()).isEmpty()) {
            Printer printer4 = this.p;
            if (printer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer4 = null;
            }
            stringArray2 = new String[]{"Build failed: " + build.getFailureMessages()};
            printer4.println(stringArray2);
        }
        if ((printer = this.p) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        printer.println(new String[0]);
    }

    private final void printMetrics(BuildMetrics buildMetrics) {
        if (!this.printMetrics) {
            return;
        }
        this.printBuildTimes(buildMetrics.getBuildTimes());
        this.printBuildPerformanceMetrics(buildMetrics.getBuildPerformanceMetrics());
        this.printBuildAttributes(buildMetrics.getBuildAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printBuildTimes(BuildTimes buildTimes) {
        Map collectedBuildTimes = buildTimes.asMap();
        if (collectedBuildTimes.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        String[] stringArray = new String[]{"Time metrics:"};
        printer.println(stringArray);
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer2 = null;
        }
        Printer this_$iv = printer2;
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            HashSet<BuildTime> visitedBuildTimes = new HashSet<BuildTime>();
            for (BuildTime buildTime : BuildTime.values()) {
                if (buildTime.getParent() != null) continue;
                PlainTextBuildReportWriter.printBuildTimes$lambda-6$printBuildTime(visitedBuildTimes, collectedBuildTimes, this, buildTime);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer3 = null;
        }
        printer3.println(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildPerformanceMetrics(BuildPerformanceMetrics buildMetrics) {
        void this_$iv;
        Map allBuildMetrics = buildMetrics.asMap();
        if (allBuildMetrics.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        Printer printer2 = printer;
        String headLine$iv = "Build performance metrics:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            for (BuildPerformanceMetric metric : BuildPerformanceMetric.values()) {
                Long l;
                if ((Long)allBuildMetrics.get(metric) == null) continue;
                long it = ((Number)l).longValue();
                boolean bl2 = false;
                Printer printer3 = this.p;
                if (printer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer3 = null;
                }
                String[] stringArray2 = new String[]{metric.name() + ": " + it};
                printer3.println(stringArray2);
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer4 = this.p;
        if (printer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer4 = null;
        }
        printer4.println(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildAttributes(BuildAttributes buildAttributes) {
        void this_$iv;
        Map allAttributes = buildAttributes.asMap();
        if (allAttributes.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        Printer printer2 = printer;
        String headLine$iv = "Build attributes:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            void $this$groupByTo$iv$iv;
            boolean bl = false;
            Iterable $this$groupBy$iv = allAttributes.entrySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                BuildAttributeKind key$iv$iv = ((BuildAttribute)it.getKey()).getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            SortedMap attributesByKind = MapsKt.toSortedMap((Map)destination$iv$iv);
            for (Map.Entry entry : ((Map)attributesByKind).entrySet()) {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv$iv;
                BuildAttributeKind kind = (BuildAttributeKind)entry.getKey();
                List attributesCounts = (List)entry.getValue();
                Printer printer3 = this.p;
                if (printer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer3 = null;
                }
                String string = kind.name();
                Intrinsics.checkNotNullExpressionValue((Object)attributesCounts, (String)"attributesCounts");
                Iterable $i$f$groupByTo2 = attributesCounts;
                String string2 = string;
                Printer printer4 = printer3;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map.Entry entry2 = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    BuildAttribute k = (BuildAttribute)entry2.getKey();
                    int v = ((Number)entry2.getValue()).intValue();
                    collection.add(TuplesKt.to((Object)k.name(), (Object)v));
                }
                collection = (List)destination$iv$iv2;
                PlainTextBuildReportWriterKt.access$printMap(printer4, string2, MapsKt.toMap((Iterable)collection));
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer5 = this.p;
        if (printer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer5 = null;
        }
        printer5.println(new String[0]);
    }

    private final void printTaskOverview(BuildExecutionData build) {
        long allTasksTimeMs = 0L;
        long kotlinTotalTimeMs = 0L;
        ArrayList<TaskExecutionData> kotlinTasks = new ArrayList<TaskExecutionData>();
        for (TaskExecutionData taskExecutionData : build.getTaskExecutionData()) {
            long taskTimeMs = taskExecutionData.getTotalTimeMs();
            allTasksTimeMs += taskTimeMs;
            if (!taskExecutionData.isKotlinTask()) continue;
            kotlinTotalTimeMs += taskTimeMs;
            kotlinTasks.add(taskExecutionData);
        }
        if (kotlinTasks.isEmpty()) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            String[] stringArray = new String[]{"No Kotlin task was run"};
            printer.println(stringArray);
            return;
        }
        String ktTaskPercent = KotlinBuildReporterHandlerKt.asString((double)kotlinTotalTimeMs / (double)allTasksTimeMs * (double)100, 1);
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        String[] stringArray = new String[]{"Total time for Kotlin tasks: " + KotlinBuildReporterHandlerKt.formatTime(kotlinTotalTimeMs) + " (" + ktTaskPercent + " % of all tasks time)"};
        printer.println(stringArray);
        String[] stringArray2 = new String[]{"Time", "% of Kotlin time", "Task"};
        TextTable textTable = new TextTable(stringArray2);
        Iterable $this$sortedByDescending$iv = kotlinTasks;
        boolean $i$f$sortedByDescending = false;
        for (TaskExecutionData task3 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                TaskExecutionData it = (TaskExecutionData)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalTimeMs());
                it = (TaskExecutionData)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalTimeMs()));
            }
        })) {
            long timeMs = task3.getTotalTimeMs();
            String percent = KotlinBuildReporterHandlerKt.asString((double)timeMs / (double)kotlinTotalTimeMs * (double)100, 1);
            String[] stringArray3 = new String[]{KotlinBuildReporterHandlerKt.formatTime(timeMs), percent + " %", task3.getTaskPath()};
            textTable.addRow(stringArray3);
        }
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer2 = null;
        }
        textTable.printTo(printer2);
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer3 = null;
        }
        printer3.println(new String[0]);
    }

    private final void printTasksLog(BuildExecutionData build) {
        for (TaskExecutionData task2 : build.getTaskExecutionData()) {
            this.printTaskLog(task2);
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            printer.println(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printTaskLog(TaskExecutionData task2) {
        Object object;
        String skipMessage = task2.getSkipMessage();
        if (skipMessage != null) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            object = new String[]{"Task '" + task2.getTaskPath() + "' was skipped: " + skipMessage};
            printer.println((String)object);
        } else {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            object = new String[]{"Task '" + task2.getTaskPath() + "' finished in " + KotlinBuildReporterHandlerKt.formatTime(task2.getTotalTimeMs())};
            printer.println((String)object);
        }
        if (!((Collection)task2.getIcLogLines()).isEmpty()) {
            void this_$iv;
            String[] stringArray;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            object = printer;
            String headLine$iv = "Compilation log for task '" + task2.getTaskPath() + "':";
            boolean $i$f$withIndent = false;
            if (headLine$iv != null) {
                stringArray = new String[]{headLine$iv};
                this_$iv.println(stringArray);
            }
            this_$iv.pushIndent();
            try {
                boolean bl = false;
                Iterable $this$forEach$iv = task2.getIcLogLines();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Printer printer2 = this.p;
                    if (printer2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                        printer2 = null;
                    }
                    String[] stringArray2 = new String[]{it};
                    printer2.println(stringArray2);
                }
                stringArray = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        this.printMetrics(task2.getBuildMetrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void printBuildTimes$lambda-6$printBuildTime(HashSet<BuildTime> visitedBuildTimes, Map<BuildTime, Long> collectedBuildTimes, PlainTextBuildReportWriter this$0, BuildTime buildTime) {
        block11: {
            if (!visitedBuildTimes.add(buildTime)) {
                return;
            }
            Long timeMs = collectedBuildTimes.get(buildTime);
            if (timeMs != null) {
                Printer printer = this$0.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer = null;
                }
                String[] stringArray = new String[]{buildTime.name() + ": " + KotlinBuildReporterHandlerKt.formatTime(timeMs)};
                printer.println(stringArray);
                Printer printer2 = this$0.p;
                if (printer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer2 = null;
                }
                Printer this_$iv = printer2;
                Object headLine$iv = null;
                boolean $i$f$withIndent = false;
                this_$iv.pushIndent();
                try {
                    Unit unit;
                    boolean bl = false;
                    List list2 = (List)BuildTime.Companion.getChildren().get(buildTime);
                    if (list2 != null) {
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BuildTime it = (BuildTime)element$iv;
                            boolean bl2 = false;
                            PlainTextBuildReportWriter.printBuildTimes$lambda-6$printBuildTime(visitedBuildTimes, collectedBuildTimes, this$0, it);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv.popIndent();
                }
            }
            List list3 = (List)BuildTime.Companion.getChildren().get(buildTime);
            if (list3 == null) break block11;
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BuildTime it = (BuildTime)element$iv;
                boolean bl = false;
                PlainTextBuildReportWriter.printBuildTimes$lambda-6$printBuildTime(visitedBuildTimes, collectedBuildTimes, this$0, it);
            }
        }
    }
}

