/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks.artifact;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonToolOptions;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.targets.native.tasks.artifact.KotlinArtifact;
import org.jetbrains.kotlin.gradle.targets.native.tasks.artifact.KotlinNativeArtifact;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0014\u0010\u001f\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!J\u001f\u0010\u0015\u001a\u00020\r2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\"\"\u00020\u0017\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b'J(\u0010(\u001a\u00020\u0005*\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0016J(\u0010.\u001a\u00020\u0005*\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/artifact/KotlinNativeArtifact;", "Lorg/jetbrains/kotlin/gradle/targets/native/tasks/artifact/KotlinArtifact;", "()V", "binaryOptions", "", "", "getBinaryOptions$kotlin_gradle_plugin", "()Ljava/util/Map;", "isStatic", "", "kotlinOptionsFn", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinCommonToolOptions;", "", "Lkotlin/ExtensionFunctionType;", "getKotlinOptionsFn$kotlin_gradle_plugin", "()Lkotlin/jvm/functions/Function1;", "setKotlinOptionsFn$kotlin_gradle_plugin", "(Lkotlin/jvm/functions/Function1;)V", "linkerOptions", "", "modes", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "getModes", "()Ljava/util/Set;", "setModes", "(Ljava/util/Set;)V", "binaryOption", "name", "value", "kotlinOptions", "fn", "Lorg/gradle/api/Action;", "", "([Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;)V", "validate", "project", "Lorg/gradle/api/Project;", "validate$kotlin_gradle_plugin", "registerExportDependencies", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "artifactName", "deps", "", "registerLibsDependencies", "kotlin-gradle-plugin"})
public abstract class KotlinNativeArtifact
extends KotlinArtifact {
    @NotNull
    private Set<? extends NativeBuildType> modes = NativeBuildType.Companion.getDEFAULT_BUILD_TYPES();
    @JvmField
    public boolean isStatic;
    @JvmField
    @NotNull
    public List<String> linkerOptions = CollectionsKt.emptyList();
    @NotNull
    private Function1<? super KotlinCommonToolOptions, Unit> kotlinOptionsFn = kotlinOptionsFn.1.INSTANCE;
    @NotNull
    private final Map<String, String> binaryOptions = new LinkedHashMap();

    @NotNull
    public final Set<NativeBuildType> getModes() {
        return this.modes;
    }

    public final void setModes(@NotNull Set<? extends NativeBuildType> set2) {
        Intrinsics.checkNotNullParameter(set2, (String)"<set-?>");
        this.modes = set2;
    }

    public final void modes(NativeBuildType ... modes) {
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        this.modes = ArraysKt.toSet((Object[])modes);
    }

    @NotNull
    public final Function1<KotlinCommonToolOptions, Unit> getKotlinOptionsFn$kotlin_gradle_plugin() {
        return this.kotlinOptionsFn;
    }

    public final void setKotlinOptionsFn$kotlin_gradle_plugin(@NotNull Function1<? super KotlinCommonToolOptions, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.kotlinOptionsFn = function1;
    }

    public final void kotlinOptions(@NotNull Action<KotlinCommonToolOptions> fn2) {
        Intrinsics.checkNotNullParameter(fn2, (String)"fn");
        this.kotlinOptionsFn = (Function1)new Function1<KotlinCommonToolOptions, Unit>(fn2){

            public final void invoke(KotlinCommonToolOptions p0) {
                ((Action)this.receiver).execute((Object)p0);
            }

            @NotNull
            public final String getSignature() {
                return "execute(Ljava/lang/Object;)V";
            }

            @NotNull
            public final String getName() {
                return "execute";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Action.class);
            }
        };
    }

    @NotNull
    public final Map<String, String> getBinaryOptions$kotlin_gradle_plugin() {
        return this.binaryOptions;
    }

    public final void binaryOption(@NotNull String name2, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.binaryOptions.put(name2, value);
    }

    @Override
    public boolean validate$kotlin_gradle_plugin(@NotNull Project project, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Logger logger = project.getLogger();
        if (this.getModules$kotlin_gradle_plugin().isEmpty()) {
            logger.error("Native library '" + name2 + "' wasn't configured because it requires at least one module for linking");
            return false;
        }
        if (this.modes.isEmpty()) {
            logger.error("Native library '" + name2 + "' wasn't configured because it requires at least one build type in modes");
            return false;
        }
        return true;
    }

    @NotNull
    public final String registerLibsDependencies(@NotNull Project $this$registerLibsDependencies, @NotNull KonanTarget target2, @NotNull String artifactName, @NotNull Set<? extends Object> deps) {
        Intrinsics.checkNotNullParameter((Object)$this$registerLibsDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        Object object = new String[]{UtilsKt.getPresetName((KonanTarget)target2), artifactName, "linkLibrary"};
        String librariesConfigurationName = StringUtilsKt.lowerCamelCaseName(object);
        object = $this$registerLibsDependencies.getConfigurations().maybeCreate(librariesConfigurationName);
        Configuration $this$registerLibsDependencies_u24lambda_u2d0 = (Configuration)object;
        boolean bl = false;
        $this$registerLibsDependencies_u24lambda_u2d0.setVisible(false);
        $this$registerLibsDependencies_u24lambda_u2d0.setCanBeConsumed(false);
        $this$registerLibsDependencies_u24lambda_u2d0.setCanBeResolved(true);
        $this$registerLibsDependencies_u24lambda_u2d0.setTransitive(true);
        $this$registerLibsDependencies_u24lambda_u2d0.getAttributes().attribute(KotlinPlatformType.Companion.getAttribute(), (Object)KotlinPlatformType.native);
        $this$registerLibsDependencies_u24lambda_u2d0.getAttributes().attribute(KotlinNativeTarget.Companion.getKonanTargetAttribute(), (Object)target2.getName());
        $this$registerLibsDependencies_u24lambda_u2d0.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)$this$registerLibsDependencies.getProject().getObjects().named(Usage.class, "kotlin-api"));
        Iterable $this$forEach$iv = deps;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$registerLibsDependencies.getDependencies().add(librariesConfigurationName, it);
        }
        return librariesConfigurationName;
    }

    @NotNull
    public final String registerExportDependencies(@NotNull Project $this$registerExportDependencies, @NotNull KonanTarget target2, @NotNull String artifactName, @NotNull Set<? extends Object> deps) {
        Intrinsics.checkNotNullParameter((Object)$this$registerExportDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        Object object = new String[]{UtilsKt.getPresetName((KonanTarget)target2), artifactName, "linkExport"};
        String exportConfigurationName = StringUtilsKt.lowerCamelCaseName(object);
        object = $this$registerExportDependencies.getConfigurations().maybeCreate(exportConfigurationName);
        Configuration $this$registerExportDependencies_u24lambda_u2d2 = (Configuration)object;
        boolean bl = false;
        $this$registerExportDependencies_u24lambda_u2d2.setVisible(false);
        $this$registerExportDependencies_u24lambda_u2d2.setCanBeConsumed(false);
        $this$registerExportDependencies_u24lambda_u2d2.setCanBeResolved(true);
        $this$registerExportDependencies_u24lambda_u2d2.setTransitive(false);
        $this$registerExportDependencies_u24lambda_u2d2.getAttributes().attribute(KotlinPlatformType.Companion.getAttribute(), (Object)KotlinPlatformType.native);
        $this$registerExportDependencies_u24lambda_u2d2.getAttributes().attribute(KotlinNativeTarget.Companion.getKonanTargetAttribute(), (Object)target2.getName());
        $this$registerExportDependencies_u24lambda_u2d2.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)$this$registerExportDependencies.getProject().getObjects().named(Usage.class, "kotlin-api"));
        Iterable $this$forEach$iv = deps;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$registerExportDependencies.getDependencies().add(exportConfigurationName, it);
        }
        return exportConfigurationName;
    }
}

