/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.cookie;

import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.Cookie;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.CookieOrigin;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.CookieRestrictionViolationException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.MalformedCookieException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.SetCookie;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value2.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value2));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

