/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.transforms;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.compilerRunner.btapi.SharedApiClassesClassLoaderProvider;
import org.jetbrains.kotlin.gradle.internal.ClassLoadersCachingBuildService;

@CacheableTransform
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform$Parameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "getClassSnapshotGranularity", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "classpathEntryDirOrJar", "Ljava/io/File;", "gradleUserHomeDir", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class BuildToolsApiClasspathEntrySnapshotTransform
implements TransformAction<Parameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        File classpathEntryInputDirOrJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        StringBuilder stringBuilder = new StringBuilder();
        String string = classpathEntryInputDirOrJar.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classpathEntryInputDirOrJar.name");
        File snapshotOutputFile = outputs.file((Object)stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'_', (boolean)false, (int)4, null)).append("-snapshot.bin").toString());
        Intrinsics.checkNotNullExpressionValue((Object)classpathEntryInputDirOrJar, (String)"classpathEntryInputDirOrJar");
        File file = ((Directory)((Parameters)this.getParameters()).getGradleUserHomeDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.gradleUserHomeDir.get().asFile");
        ClassSnapshotGranularity granularity = this.getClassSnapshotGranularity(classpathEntryInputDirOrJar, file);
        ClassLoader classLoader = ((ClassLoadersCachingBuildService)((Parameters)this.getParameters()).getClassLoadersCachingService$kotlin_gradle_plugin_common().get()).getClassLoader(CollectionsKt.toList((Iterable)((Iterable)((Parameters)this.getParameters()).getClasspath$kotlin_gradle_plugin_common())), SharedApiClassesClassLoaderProvider.INSTANCE);
        CompilationService compilationService = CompilationService.Companion.loadImplementation(classLoader);
        ClasspathEntrySnapshot snapshot = compilationService.calculateClasspathSnapshot(classpathEntryInputDirOrJar, granularity);
        Intrinsics.checkNotNullExpressionValue((Object)snapshotOutputFile, (String)"snapshotOutputFile");
        snapshot.saveSnapshot(snapshotOutputFile);
    }

    private final ClassSnapshotGranularity getClassSnapshotGranularity(File classpathEntryDirOrJar, File gradleUserHomeDir) {
        return FilesKt.startsWith((File)classpathEntryDirOrJar, (File)gradleUserHomeDir) || Intrinsics.areEqual((Object)classpathEntryDirOrJar.getName(), (Object)"android.jar") ? ClassSnapshotGranularity.CLASS_LEVEL : ClassSnapshotGranularity.CLASS_MEMBER_LEVEL;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "()V", "classLoadersCachingService", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/internal/ClassLoadersCachingBuildService;", "getClassLoadersCachingService$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Property;", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "gradleUserHomeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGradleUserHomeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "kotlin-gradle-plugin_common"})
    public static abstract class Parameters
    implements TransformParameters {
        @Internal
        @NotNull
        public abstract DirectoryProperty getGradleUserHomeDir();

        @Internal
        @NotNull
        public abstract Property<ClassLoadersCachingBuildService> getClassLoadersCachingService$kotlin_gradle_plugin_common();

        @Classpath
        @NotNull
        public abstract ConfigurableFileCollection getClasspath$kotlin_gradle_plugin_common();
    }
}

