/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android;

import com.android.build.gradle.api.AndroidSourceSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidBaseSourceSetName;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidVariantType;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidVariantTypeKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetInfo;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetInfoKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.utils.FailuresKt;
import org.jetbrains.kotlin.gradle.utils.ObjectCollectionExtKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetFactory;", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "kotlin", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinProjectExtension;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "diagnosticsCollector", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;Lorg/jetbrains/kotlin/gradle/dsl/KotlinProjectExtension;Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector;)V", "configuredKotlinSourceSets", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "getOrCreateConfiguredKotlinSourceSet", "kotlinSourceSetName", "", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getOrCreateKotlinSourceSet", "name", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinAndroidSourceSetFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAndroidSourceSetFactory.kt\norg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetFactory\n+ 2 runProjectConfigurationHealthCheck.kt\norg/jetbrains/kotlin/gradle/utils/RunProjectConfigurationHealthCheckKt\n*L\n1#1,74:1\n60#2,6:75\n*S KotlinDebug\n*F\n+ 1 KotlinAndroidSourceSetFactory.kt\norg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetFactory\n*L\n30#1:75,6\n*E\n"})
public final class KotlinAndroidSourceSetFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinAndroidTarget target;
    @NotNull
    private final KotlinProjectExtension kotlin;
    @NotNull
    private final KotlinAndroidSourceSetLayout layout;
    @NotNull
    private final KotlinToolingDiagnosticsCollector diagnosticsCollector;
    @NotNull
    private final Set<KotlinSourceSet> configuredKotlinSourceSets;
    @NotNull
    private static final Logger logger;

    public KotlinAndroidSourceSetFactory(@NotNull KotlinAndroidTarget target2, @NotNull KotlinProjectExtension kotlin2, @NotNull KotlinAndroidSourceSetLayout layout, @NotNull KotlinToolingDiagnosticsCollector diagnosticsCollector) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)kotlin2, (String)"kotlin");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        this.target = target2;
        this.kotlin = kotlin2;
        this.layout = layout;
        this.diagnosticsCollector = diagnosticsCollector;
        this.configuredKotlinSourceSets = new LinkedHashSet();
    }

    @NotNull
    public final KotlinSourceSet getOrCreateConfiguredKotlinSourceSet(@NotNull String kotlinSourceSetName, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSetName, (String)"kotlinSourceSetName");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        KotlinSourceSet kotlinSourceSet = this.getOrCreateKotlinSourceSet(kotlinSourceSetName, androidSourceSet);
        if (this.configuredKotlinSourceSets.add(kotlinSourceSet)) {
            this.layout.getSourceSetConfigurator().configure(this.target, kotlinSourceSet, androidSourceSet);
            Project $this$runProjectConfigurationHealthCheck$iv = this.target.getProject();
            boolean $i$f$runProjectConfigurationHealthCheck = false;
            if (!(!((Collection)FailuresKt.getFailures($this$runProjectConfigurationHealthCheck$iv)).isEmpty())) {
                Project $this$getOrCreateConfiguredKotlinSourceSet_u24lambda_u240 = $this$runProjectConfigurationHealthCheck$iv;
                boolean bl = false;
                KotlinAndroidSourceSetLayout layout = this.layout;
                layout.getChecker().checkCreatedSourceSet(this.diagnosticsCollector, this.target, layout, kotlinSourceSet, androidSourceSet);
            }
        }
        return kotlinSourceSet;
    }

    private final KotlinSourceSet getOrCreateKotlinSourceSet(String name2, AndroidSourceSet androidSourceSet) {
        return (KotlinSourceSet)ObjectCollectionExtKt.getOrCreate$default(this.kotlin.getSourceSets(), name2, null, (Function1)new Function1<KotlinSourceSet, Unit>(name2, androidSourceSet){
            final /* synthetic */ String $name;
            final /* synthetic */ AndroidSourceSet $androidSourceSet;
            {
                this.$name = $name;
                this.$androidSourceSet = $androidSourceSet;
                super(1);
            }

            public final void invoke(@NotNull KotlinSourceSet kotlinSourceSet) {
                Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
                KotlinAndroidSourceSetInfo kotlinAndroidSourceSetInfo = KotlinAndroidSourceSetInfoKt.getAndroidSourceSetInfoOrNull(kotlinSourceSet);
                if (kotlinAndroidSourceSetInfo != null) {
                    KotlinAndroidSourceSetInfo kotlinAndroidSourceSetInfo2 = kotlinAndroidSourceSetInfo;
                    String string = this.$name;
                    AndroidSourceSet androidSourceSet = this.$androidSourceSet;
                    KotlinAndroidSourceSetInfo info = kotlinAndroidSourceSetInfo2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)info.getKotlinSourceSetName(), (Object)string)) {
                        boolean $i$a$-check-KotlinAndroidSourceSetFactory$getOrCreateKotlinSourceSet$1$1$32 = false;
                        String $i$a$-check-KotlinAndroidSourceSetFactory$getOrCreateKotlinSourceSet$1$1$32 = "Bad 'androidSourceSetInfo.kotlinSourceSetName' on KotlinSourceSet:" + string + ": Expected: " + kotlinSourceSet.getName() + " Found: " + info.getKotlinSourceSetName();
                        throw new IllegalStateException($i$a$-check-KotlinAndroidSourceSetFactory$getOrCreateKotlinSourceSet$1$1$32.toString());
                    }
                    if (!Intrinsics.areEqual((Object)info.getAndroidSourceSetName(), (Object)androidSourceSet.getName())) {
                        boolean bl2 = false;
                        String string2 = "Bad 'androidSourceSetInfo.androidSourceSetName' on KotlinSourceSet:" + string + ": Expected: " + androidSourceSet.getName() + " Found: " + info.getAndroidSourceSetName();
                        throw new IllegalStateException(string2.toString());
                    }
                    return;
                }
                String string = this.$androidSourceSet.getName();
                Object object = AndroidBaseSourceSetName.Companion.byName(this.$androidSourceSet.getName());
                if (object == null || (object = AndroidVariantTypeKt.getVariantType(object)) == null) {
                    object = AndroidVariantType.Unknown;
                }
                KotlinAndroidSourceSetInfoKt.setAndroidSourceSetInfo(kotlinSourceSet, new KotlinAndroidSourceSetInfo.Mutable(this.$name, string, (AndroidVariantType)((Object)object), null, 8, null));
                KotlinAndroidSourceSetFactory.access$getCompanion$p().getLogger().debug("Created KotlinSourceSet: " + kotlinSourceSet.getName() + " for AndroidSourceSet: " + this.$androidSourceSet.getName());
            }
        }, 2, null);
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    static {
        Logger logger = Logging.getLogger(KotlinAndroidSourceSetFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(KotlinAndroidS\u2026ceSetFactory::class.java)");
        KotlinAndroidSourceSetFactory.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetFactory$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin_common"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

