/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Converter;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.primitives.ShortsMethodsForWeb;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Shorts
extends ShortsMethodsForWeb {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short value2) {
        return value2;
    }

    public static short checkedCast(long value2) {
        short result2 = (short)value2;
        Preconditions.checkArgument((long)result2 == value2, "Out of range: %s", value2);
        return result2;
    }

    public static short saturatedCast(long value2) {
        if (value2 > 32767L) {
            return Short.MAX_VALUE;
        }
        if (value2 < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)value2;
    }

    public static int compare(short a, short b) {
        return a - b;
    }

    public static boolean contains(short[] array2, short target2) {
        for (short value2 : array2) {
            if (value2 != target2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(short[] array2, short target2) {
        return Shorts.indexOf(array2, target2, 0, array2.length);
    }

    private static int indexOf(short[] array2, short target2, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(short[] array2, short[] target2) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target2, "target");
        if (target2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array2.length - target2.length + 1; ++i2) {
            for (int j = 0; j < target2.length; ++j) {
                if (array2[i2 + j] != target2[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array2, short target2) {
        return Shorts.lastIndexOf(array2, target2, 0, array2.length);
    }

    private static int lastIndexOf(short[] array2, short target2, int start2, int end) {
        for (int i2 = end - 1; i2 >= start2; --i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short min(short ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        short min = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] >= min) continue;
            min = array2[i2];
        }
        return min;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short max(short ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        short max = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] <= max) continue;
            max = array2[i2];
        }
        return max;
    }

    @Beta
    public static short constrainToRange(short value2, short min, short max) {
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", (int)min, (int)max);
        return value2 < min ? min : (value2 < max ? value2 : max);
    }

    public static short[] concat(short[] ... arrays) {
        int length = 0;
        for (short[] array2 : arrays) {
            length += array2.length;
        }
        short[] result2 = new short[length];
        int pos = 0;
        for (short[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    @GwtIncompatible
    public static byte[] toByteArray(short value2) {
        return new byte[]{(byte)(value2 >> 8), (byte)value2};
    }

    @GwtIncompatible
    public static short fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 2, "array too small: %s < %s", bytes.length, 2);
        return Shorts.fromBytes(bytes[0], bytes[1]);
    }

    @GwtIncompatible
    public static short fromBytes(byte b1, byte b2) {
        return (short)(b1 << 8 | b2 & 0xFF);
    }

    @Beta
    public static Converter<String, Short> stringConverter() {
        return ShortConverter.INSTANCE;
    }

    public static short[] ensureCapacity(short[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, short ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 6);
        builder.append(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(array2[i2]);
        }
        return builder.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(short[] array2) {
        Preconditions.checkNotNull(array2);
        Shorts.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(short[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Shorts.reverse(array2, fromIndex, toIndex);
    }

    public static void reverse(short[] array2) {
        Preconditions.checkNotNull(array2);
        Shorts.reverse(array2, 0, array2.length);
    }

    public static void reverse(short[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        for (int j = toIndex - 1; i2 < j; ++i2, --j) {
            short tmp = array2[i2];
            array2[i2] = array2[j];
            array2[j] = tmp;
        }
    }

    public static short[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        short[] array2 = new short[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = ((Number)Preconditions.checkNotNull(boxedArray[i2])).shortValue();
        }
        return array2;
    }

    public static List<Short> asList(short ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements RandomAccess,
    Serializable {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ShortArrayAsList(short[] array2) {
            this(array2, 0, array2.length);
        }

        ShortArrayAsList(short[] array2, int start2, int end) {
            this.array = array2;
            this.start = start2;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Short get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(@CheckForNull Object target2) {
            return target2 instanceof Short && Shorts.indexOf(this.array, (Short)target2, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Short && (i2 = Shorts.indexOf(this.array, (Short)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Short && (i2 = Shorts.lastIndexOf(this.array, (Short)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int index, Short element) {
            Preconditions.checkElementIndex(index, this.size());
            short oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Short> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList that = (ShortArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Shorts.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 6);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }

        short[] toShortArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] left, short[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                int result2 = Shorts.compare(left[i2], right[i2]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Shorts.lexicographicalComparator()";
        }
    }

    private static final class ShortConverter
    extends Converter<String, Short>
    implements Serializable {
        static final ShortConverter INSTANCE = new ShortConverter();
        private static final long serialVersionUID = 1L;

        private ShortConverter() {
        }

        @Override
        protected Short doForward(String value2) {
            return Short.decode(value2);
        }

        @Override
        protected String doBackward(Short value2) {
            return value2.toString();
        }

        public String toString() {
            return "Shorts.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

