/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.J2ktIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.CollectPreconditions;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.Hashing;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableAsList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableBiMap;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableCollection;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMapEntry;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMapEntrySet;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMapKeySet;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.JdkBackedImmutableBiMap;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.RegularImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.UnmodifiableIterator;
import org.jetbrains.kotlin.com.google.errorprone.annotations.concurrent.LazyInit;
import org.jetbrains.kotlin.com.google.j2objc.annotations.RetainedWith;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap(null, null, ImmutableMap.EMPTY_ENTRY_ARRAY, 0, 0);
    static final double MAX_LOAD_FACTOR = 1.2;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] keyTable;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] valueTable;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableBiMap<V, K> inverse;

    static <K, V> ImmutableBiMap<K, V> fromEntries(Map.Entry<K, V> ... entries2) {
        return RegularImmutableBiMap.fromEntryArray(entries2.length, entries2);
    }

    static <K, V> ImmutableBiMap<K, V> fromEntryArray(int n,  @Nullable Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        int tableSize = Hashing.closedTableSize(n, 1.2);
        int mask = tableSize - 1;
        @Nullable ImmutableMapEntry<K, V>[] keyTable = ImmutableMapEntry.createEntryArray(tableSize);
        @Nullable ImmutableMapEntry<K, V>[] valueTable = ImmutableMapEntry.createEntryArray(tableSize);
        Map.Entry<K, V>[] entries2 = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int hashCode = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            Map.Entry<K, V> entry2 = Objects.requireNonNull(entryArray[i2]);
            K key = entry2.getKey();
            V value2 = entry2.getValue();
            CollectPreconditions.checkEntryNotNull(key, value2);
            int keyHash = key.hashCode();
            int valueHash = value2.hashCode();
            int keyBucket = Hashing.smear(keyHash) & mask;
            int valueBucket = Hashing.smear(valueHash) & mask;
            ImmutableMapEntry nextInKeyBucket = keyTable[keyBucket];
            ImmutableMapEntry nextInValueBucket = valueTable[valueBucket];
            try {
                RegularImmutableMap.checkNoConflictInKeyBucket(key, value2, nextInKeyBucket, true);
                RegularImmutableBiMap.checkNoConflictInValueBucket(value2, entry2, nextInValueBucket);
            }
            catch (RegularImmutableMap.BucketOverflowException e) {
                return JdkBackedImmutableBiMap.create(n, entryArray);
            }
            ImmutableMapEntry newEntry = nextInValueBucket == null && nextInKeyBucket == null ? RegularImmutableMap.makeImmutable(entry2, key, value2) : new ImmutableMapEntry.NonTerminalImmutableBiMapEntry<K, V>(key, value2, nextInKeyBucket, nextInValueBucket);
            keyTable[keyBucket] = newEntry;
            valueTable[valueBucket] = newEntry;
            entries2[i2] = newEntry;
            hashCode += keyHash ^ valueHash;
        }
        return new RegularImmutableBiMap(keyTable, valueTable, entries2, mask, hashCode);
    }

    private RegularImmutableBiMap(@CheckForNull @Nullable ImmutableMapEntry<K, V>[] keyTable, @CheckForNull @Nullable ImmutableMapEntry<K, V>[] valueTable, Map.Entry<K, V>[] entries2, int mask, int hashCode) {
        this.keyTable = keyTable;
        this.valueTable = valueTable;
        this.entries = entries2;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    private static void checkNoConflictInValueBucket(Object value2, Map.Entry<?, ?> entry2, @CheckForNull ImmutableMapEntry<?, ?> valueBucketHead) throws RegularImmutableMap.BucketOverflowException {
        int bucketSize = 0;
        while (valueBucketHead != null) {
            RegularImmutableBiMap.checkNoConflict(!value2.equals(valueBucketHead.getValue()), "value", entry2, valueBucketHead);
            if (++bucketSize > 8) {
                throw new RegularImmutableMap.BucketOverflowException();
            }
            valueBucketHead = valueBucketHead.getNextInValueBucket();
        }
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        return RegularImmutableMap.get(key, this.keyTable, this.mask);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        Preconditions.checkNotNull(action2);
        for (Map.Entry<K, V> entry2 : this.entries) {
            action2.accept(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.isEmpty()) {
            return ImmutableBiMap.of();
        }
        Inverse result2 = this.inverse;
        return result2 == null ? (this.inverse = new Inverse()) : result2;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    @J2ktIncompatible
    private static class InverseSerializedForm<K, V>
    implements Serializable {
        private final ImmutableBiMap<K, V> forward;
        private static final long serialVersionUID = 1L;

        InverseSerializedForm(ImmutableBiMap<K, V> forward) {
            this.forward = forward;
        }

        Object readResolve() {
            return this.forward.inverse();
        }
    }

    private final class Inverse
    extends ImmutableBiMap<V, K> {
        private Inverse() {
        }

        @Override
        public int size() {
            return this.inverse().size();
        }

        @Override
        public ImmutableBiMap<K, V> inverse() {
            return RegularImmutableBiMap.this;
        }

        @Override
        public void forEach(BiConsumer<? super V, ? super K> action2) {
            Preconditions.checkNotNull(action2);
            RegularImmutableBiMap.this.forEach((? super K k, ? super V v) -> action2.accept((Object)v, (Object)k));
        }

        @Override
        @CheckForNull
        public K get(@CheckForNull Object value2) {
            if (value2 == null || RegularImmutableBiMap.this.valueTable == null) {
                return null;
            }
            int bucket = Hashing.smear(value2.hashCode()) & RegularImmutableBiMap.this.mask;
            for (ImmutableMapEntry entry2 = RegularImmutableBiMap.this.valueTable[bucket]; entry2 != null; entry2 = entry2.getNextInValueBucket()) {
                if (!value2.equals(entry2.getValue())) continue;
                return entry2.getKey();
            }
            return null;
        }

        @Override
        ImmutableSet<V> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<V, K>> createEntrySet() {
            return new InverseEntrySet();
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return new InverseSerializedForm(RegularImmutableBiMap.this);
        }

        @J2ktIncompatible
        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Use InverseSerializedForm");
        }

        final class InverseEntrySet
        extends ImmutableMapEntrySet<V, K> {
            InverseEntrySet() {
            }

            @Override
            ImmutableMap<V, K> map() {
                return Inverse.this;
            }

            @Override
            boolean isHashCodeFast() {
                return true;
            }

            @Override
            public int hashCode() {
                return RegularImmutableBiMap.this.hashCode;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<V, K>> iterator() {
                return this.asList().iterator();
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<V, K>> action2) {
                this.asList().forEach(action2);
            }

            @Override
            ImmutableList<Map.Entry<V, K>> createAsList() {
                return new ImmutableAsList<Map.Entry<V, K>>(){

                    @Override
                    public Map.Entry<V, K> get(int index) {
                        Map.Entry entry2 = RegularImmutableBiMap.this.entries[index];
                        return Maps.immutableEntry(entry2.getValue(), entry2.getKey());
                    }

                    @Override
                    ImmutableCollection<Map.Entry<V, K>> delegateCollection() {
                        return InverseEntrySet.this;
                    }

                    @Override
                    @J2ktIncompatible
                    @GwtIncompatible
                    Object writeReplace() {
                        return super.writeReplace();
                    }
                };
            }

            @Override
            @J2ktIncompatible
            @GwtIncompatible
            Object writeReplace() {
                return super.writeReplace();
            }
        }
    }
}

