/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.profiling;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLClassLoader;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerReflected;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerHelper;", "", "<init>", "()V", "", "libPath", "Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "getInstance", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "Ljava/lang/Class;", "loadAsyncProfilerClass", "(Ljava/lang/String;)Ljava/lang/Class;", "instance", "Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nAsyncProfilerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerWrapper.kt\norg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class AsyncProfilerHelper {
    @NotNull
    public static final AsyncProfilerHelper INSTANCE = new AsyncProfilerHelper();
    @Nullable
    private static AsyncProfilerReflected instance;

    private AsyncProfilerHelper() {
    }

    @NotNull
    public final AsyncProfilerReflected getInstance(@Nullable String libPath) {
        AsyncProfilerReflected asyncProfilerReflected = instance;
        if (asyncProfilerReflected != null) {
            AsyncProfilerReflected it = asyncProfilerReflected;
            boolean bl = false;
            return it;
        }
        Class<?> profilerClass = this.loadAsyncProfilerClass(libPath);
        MethodHandle getInstanceHandle = MethodHandles.lookup().findStatic(profilerClass, "getInstance", MethodType.methodType(profilerClass, String.class));
        MethodHandle executeHandle = MethodHandles.lookup().findVirtual(profilerClass, "execute", MethodType.methodType(String.class, String.class));
        MethodHandle stopHandle = MethodHandles.lookup().findVirtual(profilerClass, "stop", MethodType.methodType(Void.TYPE));
        MethodHandle getVersionHandle = MethodHandles.lookup().findVirtual(profilerClass, "getVersion", MethodType.methodType(String.class));
        Object object = new Object[]{libPath};
        Object instance = getInstanceHandle.invokeWithArguments(object);
        Object it = object = new AsyncProfilerReflected(executeHandle, instance, stopHandle, getVersionHandle){
            private final MethodHandle boundExecute;
            private final MethodHandle boundStop;
            private final MethodHandle boundGetVersion;
            {
                this.boundExecute = $executeHandle.bindTo($instance);
                this.boundStop = $stopHandle.bindTo($instance);
                this.boundGetVersion = $getVersionHandle.bindTo($instance);
            }

            public String execute(String command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                Object[] objectArray = new Object[]{command};
                Object object = this.boundExecute.invokeWithArguments(objectArray);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                return (String)object;
            }

            public void stop() {
                this.boundStop.invokeWithArguments(new Object[0]);
            }

            public String getVersion() {
                Object object = this.boundGetVersion.invokeWithArguments(new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                return (String)object;
            }
        };
        boolean bl = false;
        AsyncProfilerHelper.instance = (AsyncProfilerReflected)it;
        return (AsyncProfilerReflected)object;
    }

    private final Class<?> loadAsyncProfilerClass(String libPath) {
        Class<?> clazz;
        String fqName = "one.profiler.AsyncProfiler";
        try {
            clazz = Class.forName(fqName);
            Intrinsics.checkNotNull(clazz);
        }
        catch (ClassNotFoundException e) {
            if (libPath == null) {
                throw e;
            }
            File directory = new File(libPath).getParentFile();
            if (!directory.isDirectory()) {
                boolean $i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22 = false;
                Intrinsics.checkNotNull((Object)directory);
                File $i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22 = directory;
                throw new IllegalStateException(((Object)$i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22).toString());
            }
            Intrinsics.checkNotNull((Object)directory);
            File apiJar = FilesKt.resolve((File)directory, (String)"async-profiler.jar");
            if (!apiJar.exists()) {
                throw new IllegalStateException(("To use async-profiler, either add it to the compiler classpath, or put async-profiler.jar at this path: " + apiJar).toString());
            }
            URL[] uRLArray = new URL[]{apiJar.toURI().toURL()};
            URLClassLoader classLoader = new URLClassLoader(uRLArray, null);
            Class<?> clazz2 = classLoader.loadClass(fqName);
            Intrinsics.checkNotNull(clazz2);
            clazz = clazz2;
        }
        return clazz;
    }
}

