/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.UnmodifiableIterator;
import org.jetbrains.kotlin.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @CheckForNull
    private volatile transient Map.Entry<K, V> cacheEntry;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V put(K key, V value2) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value2);
        this.clearCache();
        return this.backingMap.put(key, value2);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V remove(Object key) {
        Preconditions.checkNotNull(key);
        this.clearCache();
        return this.backingMap.remove(key);
    }

    final void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    @CheckForNull
    V get(Object key) {
        Preconditions.checkNotNull(key);
        V value2 = this.getIfCached(key);
        if (value2 == null) {
            return this.getWithoutCaching(key);
        }
        return value2;
    }

    @CheckForNull
    final V getWithoutCaching(Object key) {
        Preconditions.checkNotNull(key);
        return this.backingMap.get(key);
    }

    final boolean containsKey(@CheckForNull Object key) {
        return this.getIfCached(key) != null || this.backingMap.containsKey(key);
    }

    final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry2 = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.cacheEntry = entry2;
                        return entry2.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@CheckForNull Object key) {
                return MapIteratorCache.this.containsKey(key);
            }
        };
    }

    @CheckForNull
    V getIfCached(@CheckForNull Object key) {
        Map.Entry<K, V> entry2 = this.cacheEntry;
        if (entry2 != null && entry2.getKey() == key) {
            return entry2.getValue();
        }
        return null;
    }

    void clearCache() {
        this.cacheEntry = null;
    }
}

