/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;

public final class BundleUtil {
    private static final Method SET_PARENT = ReflectionUtil.getDeclaredMethod(ResourceBundle.class, "setParent", ResourceBundle.class);
    private static final Logger LOG = Logger.getInstance(BundleUtil.class);

    @Nullable
    public static ResourceBundle loadLanguageBundle(@Nullable ClassLoader pluginClassLoader, String name2) {
        if (pluginClassLoader == null) {
            return null;
        }
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        ResourceBundle pluginBundle = ResourceBundle.getBundle(name2, Locale.getDefault(), pluginClassLoader, control);
        if (pluginBundle == null) {
            return null;
        }
        ResourceBundle base = ResourceBundle.getBundle(name2);
        try {
            if (SET_PARENT != null) {
                SET_PARENT.invoke((Object)pluginBundle, base);
            }
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
        return pluginBundle;
    }
}

