/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Collections;
import java.util.Iterator;

public abstract class FlatteningIterator<Group, Value>
implements Iterator<Value> {
    private final Iterator<? extends Group> valuesIterator;
    private Iterator<Value> groupIterator;
    private Boolean hasNextCache;

    public FlatteningIterator(Iterator<? extends Group> groups) {
        this.valuesIterator = groups;
        this.groupIterator = Collections.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextCache != null) {
            return this.hasNextCache;
        }
        while (!this.groupIterator.hasNext() && this.valuesIterator.hasNext()) {
            this.groupIterator = this.createValueIterator(this.valuesIterator.next());
        }
        this.hasNextCache = this.groupIterator.hasNext();
        return this.hasNextCache;
    }

    protected abstract Iterator<Value> createValueIterator(Group var1);

    @Override
    public Value next() {
        if (!this.hasNext()) {
            throw new AssertionError();
        }
        this.hasNextCache = null;
        return this.groupIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

