/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.MutableObservableSet;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0004\"\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u0013\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u001c\u0010\u001d\u001a\u00020\t2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0096\u0002J\u0015\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010$\u001a\u00020\u00122\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u0016\u0010%\u001a\u00020\u00122\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u001c\u0010(\u001a\u00020\t2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bH\u0016R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/MutableObservableSetImpl;", "T", "Lorg/jetbrains/kotlin/gradle/utils/MutableObservableSet;", "elements", "", "([Ljava/lang/Object;)V", "forAllActions", "", "Lkotlin/Function1;", "", "size", "", "getSize", "()I", "underlying", "", "whenObjectAddedActions", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "", "clear", "contains", "containsAll", "equals", "other", "", "forAll", "action", "hashCode", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "toString", "", "whenObjectAdded", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nObservableSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObservableSet.kt\norg/jetbrains/kotlin/gradle/utils/MutableObservableSetImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,95:1\n1863#2,2:96\n1863#2,2:98\n37#3:100\n36#3,3:101\n37#3:106\n36#3,3:107\n13402#4,2:104\n13402#4,2:110\n*S KotlinDebug\n*F\n+ 1 ObservableSet.kt\norg/jetbrains/kotlin/gradle/utils/MutableObservableSetImpl\n*L\n26#1:96,2\n38#1:98,2\n45#1:100\n45#1:101,3\n46#1:106\n46#1:107,3\n45#1:104,2\n46#1:110,2\n*E\n"})
public final class MutableObservableSetImpl<T>
implements MutableObservableSet<T> {
    @NotNull
    private final Set<T> underlying;
    @NotNull
    private final List<Function1<T, Unit>> whenObjectAddedActions;
    @NotNull
    private final List<Function1<T, Unit>> forAllActions;

    public MutableObservableSetImpl(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.underlying = SetsKt.mutableSetOf((Object[])Arrays.copyOf(elements, elements.length));
        this.whenObjectAddedActions = new ArrayList();
        this.forAllActions = new ArrayList();
        CollectionsKt.addAll((Collection)this.underlying, (Object[])elements);
    }

    @Override
    public void whenObjectAdded(@NotNull Function1<? super T, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.whenObjectAddedActions.add(action2);
    }

    @Override
    public void forAll(@NotNull Function1<? super T, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.forAllActions.add(action2);
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.underlying);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action2.invoke(element$iv);
        }
    }

    public int getSize() {
        return this.underlying.size();
    }

    @Override
    public void clear() {
        this.underlying.clear();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Set elementsToAdd = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)elements), (Iterable)this.underlying);
        Iterable $this$forEach$iv = elementsToAdd;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object p0 = element$iv = iterator2.next();
            boolean bl = false;
            this.add((T)p0);
        }
        return !((Collection)elementsToAdd).isEmpty();
    }

    @Override
    public boolean add(T element) {
        boolean added = this.underlying.add(element);
        if (added) {
            Function1 action2;
            Function1 element$iv;
            Collection $this$toTypedArray$iv = this.whenObjectAddedActions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            Function1[] $this$forEach$iv = thisCollection$iv2.toArray(new Function1[0]);
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int thisCollection$iv2 = 0; thisCollection$iv2 < n; ++thisCollection$iv2) {
                action2 = element$iv = $this$forEach$iv[thisCollection$iv2];
                boolean bl = false;
                action2.invoke(element);
            }
            $this$toTypedArray$iv = this.forAllActions;
            $i$f$toTypedArray = false;
            Collection thisCollection$iv3 = $this$toTypedArray$iv;
            $this$forEach$iv = thisCollection$iv3.toArray(new Function1[0]);
            $i$f$forEach = false;
            n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                action2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                action2.invoke(element);
            }
        }
        return added;
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.underlying.iterator();
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.underlying.retainAll(elements);
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.underlying.removeAll(elements);
    }

    @Override
    public boolean remove(Object element) {
        return this.underlying.remove(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.underlying.containsAll(elements);
    }

    @Override
    public boolean contains(Object element) {
        return this.underlying.contains(element);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return Intrinsics.areEqual(this.underlying, (Object)other);
    }

    @Override
    public int hashCode() {
        return ((Object)this.underlying).hashCode();
    }

    @NotNull
    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array2);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

