/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans;

import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanConsumer;

public interface BooleanIterator
extends PrimitiveIterator<Boolean, BooleanConsumer> {
    public boolean nextBoolean();

    @Override
    @Deprecated
    default public Boolean next() {
        return this.nextBoolean();
    }

    @Override
    default public void forEachRemaining(BooleanConsumer action2) {
        Objects.requireNonNull(action2);
        while (this.hasNext()) {
            action2.accept(this.nextBoolean());
        }
    }

    @Override
    @Deprecated
    default public void forEachRemaining(Consumer<? super Boolean> action2) {
        this.forEachRemaining(action2 instanceof BooleanConsumer ? (BooleanConsumer)action2 : action2::accept);
    }

    default public int skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must be nonnegative: " + n);
        }
        int i2 = n;
        while (i2-- != 0 && this.hasNext()) {
            this.nextBoolean();
        }
        return n - i2 - 1;
    }
}

