/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterators;

public abstract class AbstractByteCollection
extends AbstractCollection<Byte>
implements ByteCollection {
    protected AbstractByteCollection() {
    }

    @Override
    public abstract ByteIterator iterator();

    @Override
    public boolean add(byte k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(byte k) {
        ByteIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextByte()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(byte k) {
        ByteIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextByte()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Byte key) {
        return ByteCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return ByteCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return ByteCollection.super.remove(key);
    }

    @Override
    public byte[] toArray(byte[] a) {
        int size = this.size();
        if (a == null) {
            a = new byte[size];
        } else if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        ByteIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    public byte[] toByteArray() {
        return this.toArray((byte[])null);
    }

    @Override
    @Deprecated
    public byte[] toByteArray(byte[] a) {
        return this.toArray(a);
    }

    @Override
    public boolean addAll(ByteCollection c) {
        boolean retVal = false;
        ByteIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextByte())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> c) {
        if (c instanceof ByteCollection) {
            return this.addAll((ByteCollection)c);
        }
        return super.addAll(c);
    }

    @Override
    public boolean containsAll(ByteCollection c) {
        ByteIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextByte())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.containsAll((ByteCollection)c);
        }
        return super.containsAll(c);
    }

    @Override
    public boolean removeAll(ByteCollection c) {
        boolean retVal = false;
        ByteIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextByte())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.removeAll((ByteCollection)c);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(ByteCollection c) {
        boolean retVal = false;
        ByteIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c.contains(i2.nextByte())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.retainAll((ByteCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        ByteIterator i2 = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            byte k = i2.nextByte();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

